/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.descriptor.format;

import java.io.ByteArrayOutputStream;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorStyle;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextCode;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultNDescriptorFormat
extends DefaultFormatBase<NDescriptorFormat>
implements NDescriptorFormat {
    private boolean compact;
    private NDescriptor desc;
    private NDescriptorStyle descriptorStyle;

    public DefaultNDescriptorFormat() {
        super("descriptor-format");
    }

    @Override
    public NDescriptorFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    @Override
    public NDescriptorStyle getDescriptorStyle() {
        return this.descriptorStyle;
    }

    @Override
    public NDescriptorFormat setDescriptorStyle(NDescriptorStyle descriptorStyle) {
        this.descriptorStyle = descriptorStyle;
        return this;
    }

    @Override
    public NDescriptorFormat compact(boolean compact) {
        return this.setCompact(compact);
    }

    @Override
    public NDescriptorFormat compact() {
        return this.compact(true);
    }

    @Override
    public boolean isCompact() {
        return this.compact;
    }

    @Override
    public NDescriptorFormat setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    public NDescriptor getDescriptor() {
        return this.desc;
    }

    public NDescriptorFormat setDescriptor(NDescriptor desc) {
        this.desc = desc;
        return this;
    }

    @Override
    public NDescriptorFormat setValue(NDescriptor desc) {
        return this.setDescriptor(desc);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }

    @Override
    public void print(NPrintStream out) {
        NDescriptorStyle s = this.getDescriptorStyle();
        if (s == null) {
            s = NDescriptorStyle.NUTS;
        }
        switch (s) {
            case NUTS: {
                if (this.isNtf()) {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    NElementWriter.ofJson().setNtf(true).setCompact(this.isCompact()).write((Object)this.desc, os);
                    NTextCode r = NText.ofCode("json", os.toString());
                    out.print(r);
                    break;
                }
                NElementWriter.ofJson().setCompact(this.isCompact()).write((Object)this.desc, out);
                break;
            }
            case MANIFEST: {
                throw new NUnsupportedOperationException(NMsg.ofC("formatting descriptor in %s format is not yet implemented yet, your help is more than welcome", s));
            }
            case MAVEN: {
                throw new NUnsupportedOperationException(NMsg.ofC("formatting descriptor in %s format is not yet implemented yet, your help is more than welcome", s));
            }
        }
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

