/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.util;

import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NIteratorBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class NDependencyUtils {
    public static String normalizeDependencyType(String s1) {
        return NStringUtils.trimToNull(s1);
    }

    public static String toExclusionListString(NId[] exclusions) {
        TreeSet<String> ex = new TreeSet<String>();
        for (NId exclusion : exclusions) {
            ex.add(exclusion.getShortName());
        }
        return String.join((CharSequence)",", ex);
    }

    public static boolean isOptionalDependency(NDependency d) {
        return !NDependencyUtils.isRequiredDependency(d);
    }

    public static boolean isRequiredDependency(NDependency d) {
        if (d.isOptional()) {
            return false;
        }
        return NDependencyScope.parse(d.getScope()).orElse(NDependencyScope.API) != NDependencyScope.SYSTEM;
    }

    public static Iterator<NDependency> itIdToDep(NIterator<NId> id) {
        return NIteratorBuilder.of(id).map(NFunction.of(NId::toDependency).redescribe((Supplier)NElementDescribables.ofDesc("IdToDependency"))).build();
    }

    public static Iterator<NDependency> itIdToDep(NIterator<NId> id, NDependency copyFrom) {
        String _optional = copyFrom.getOptional();
        String _scope = copyFrom.getScope();
        return NIteratorBuilder.of(id).map(NFunction.of(x -> x.toDependency().builder().setOptional(_optional).setScope(_scope).build()).redescribe((Supplier)NElementDescribables.ofDesc("IdToDependency"))).build();
    }

    public static boolean isDefaultOptional(String s1) {
        return (s1 = NStringUtils.trim(s1)).isEmpty() || s1.equals("false");
    }
}

