/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Objects;
import net.thevpc.nuts.artifact.NArtifactNotFoundException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyTreeNode;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NRepositoryFilter;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.dependency.util.NDependencyUtils;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.NDefaultClassLoaderNode;

public final class NClassLoaderUtils {
    public static NClassLoaderNode definitionToClassLoaderNodeSafer(NDefinition def, NRepositoryFilter repositoryFilter) {
        try {
            return NClassLoaderUtils.definitionToClassLoaderNode(def, repositoryFilter);
        }
        catch (NArtifactNotFoundException ex) {
            return NClassLoaderUtils.definitionToClassLoaderNode(def, null);
        }
    }

    public static NClassLoaderNode definitionToClassLoaderNode(NDefinition def, NRepositoryFilter repositoryFilter) {
        def.getDependencies().get();
        def.getContent().get();
        def.getContent().flatMap(NPath::toURL).get();
        return new NDefaultClassLoaderNode(def.getId(), (URL)def.getContent().flatMap(NPath::toURL).orNull(), true, true, (NClassLoaderNode[])def.getDependencies().get().transitiveWithSource().stream().map(x -> NClassLoaderUtils.toClassLoaderNodeWithOptional(x, false, repositoryFilter)).filter(Objects::nonNull).toArray(NClassLoaderNode[]::new));
    }

    private static NClassLoaderNode toClassLoaderNode(NDependencyTreeNode d, boolean withChildren, NRepositoryFilter repositoryFilter) {
        return NClassLoaderUtils.toClassLoaderNodeWithOptional(d, false, withChildren, repositoryFilter);
    }

    private static NClassLoaderNode toClassLoaderNodeWithOptional(NDependency d, boolean optional, NRepositoryFilter repositoryFilter) {
        URL url;
        NPath cc = null;
        if (!optional && NDependencyUtils.isOptionalDependency(d)) {
            optional = true;
        }
        NId id = d.toId();
        try {
            cc = NSearchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).setRepositoryFilter(repositoryFilter).latest().getResultDefinitions().map(x -> x.getContent().orNull()).filter(x -> x != null).findFirst().orNull();
            if (cc == null) {
                return null;
            }
        }
        catch (NArtifactNotFoundException nArtifactNotFoundException) {
            // empty catch block
        }
        if (cc != null && (url = cc.toURL().orNull()) != null) {
            ArrayList aa = new ArrayList();
            return new NDefaultClassLoaderNode(id, url, true, true, aa.toArray(new NClassLoaderNode[0]));
        }
        if (optional) {
            return null;
        }
        throw new NArtifactNotFoundException(id.getLongId());
    }

    private static NClassLoaderNode toClassLoaderNodeWithOptional(NDependencyTreeNode d, boolean isOptional, boolean withChildren, NRepositoryFilter repositoryFilter) {
        URL url;
        NPath cc = null;
        if (!isOptional && !NDependencyUtils.isRequiredDependency(d.getDependency())) {
            isOptional = true;
        }
        try {
            cc = NFetchCmd.of(d.getDependency().toId()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setRepositoryFilter(repositoryFilter).getResultContent();
        }
        catch (NArtifactNotFoundException nArtifactNotFoundException) {
            // empty catch block
        }
        if (cc != null && (url = cc.toURL().orNull()) != null) {
            ArrayList<NClassLoaderNode> aa = new ArrayList<NClassLoaderNode>();
            if (withChildren) {
                for (NDependencyTreeNode child : d.getChildren()) {
                    NClassLoaderNode q = NClassLoaderUtils.toClassLoaderNodeWithOptional(child, isOptional, true, repositoryFilter);
                    if (q == null) continue;
                    aa.add(q);
                }
            }
            return new NDefaultClassLoaderNode(d.getDependency().toId(), url, true, true, aa.toArray(new NClassLoaderNode[0]));
        }
        if (isOptional) {
            return null;
        }
        throw new NArtifactNotFoundException(d.getDependency().toId().getLongId());
    }

    public static URL[] resolveClasspathURLs(ClassLoader contextClassLoader) {
        ArrayList<URL> all = new ArrayList<URL>();
        if (contextClassLoader != null) {
            if (contextClassLoader instanceof URLClassLoader) {
                all.addAll(Arrays.asList(((URLClassLoader)contextClassLoader).getURLs()));
            } else {
                try {
                    Enumeration<URL> r = contextClassLoader.getResources("META-INF/MANIFEST.MF");
                    while (r.hasMoreElements()) {
                        URL u = r.nextElement();
                        if ("jrt".equals(u.getProtocol()) || !"jar".equals(u.getProtocol()) || !u.getFile().endsWith("!/META-INF/MANIFEST.MF")) continue;
                        String jar = u.getFile().substring(0, u.getFile().length() - "!/META-INF/MANIFEST.MF".length());
                        all.add(CoreIOUtils.urlOf(jar));
                    }
                }
                catch (IOException | UncheckedIOException exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new URL[0]);
    }
}

