/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.solver.maven;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyTreeNode;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.runtime.standalone.dependency.DefaultNDependencies;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.MavenNDependencySolver;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyInfo;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyInfoSet;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyTreeNodeBuild;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyTreeNodeBuildComparator;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;

class PassProcessor {
    private final MavenNDependencySolver mavenNDependencySolver;
    NDependencyTreeNodeBuildComparator nDependencyTreeNodeBuildComparator = new NDependencyTreeNodeBuildComparator();
    List<NDependencyTreeNodeBuild> mergedRootNodeBuilders = new ArrayList<NDependencyTreeNodeBuild>();
    List<NDependencyTreeNodeBuild> nonMergedRootNodeBuilders = new ArrayList<NDependencyTreeNodeBuild>();
    PriorityQueue<NDependencyTreeNodeBuild> queue = new PriorityQueue<NDependencyTreeNodeBuild>(this.nDependencyTreeNodeBuildComparator);
    PriorityQueue<NDependencyTreeNodeBuild> providedQueue = new PriorityQueue<NDependencyTreeNodeBuild>(this.nDependencyTreeNodeBuildComparator);
    Set<NId> sourceIds = new LinkedHashSet<NId>();
    LinkedHashSet<NDependency> immediates = new LinkedHashSet();
    NDependencyInfoSet mergedVisitedSet = new NDependencyInfoSet();
    NDependencyInfoSet nonMergedVisitedSet = new NDependencyInfoSet();
    NDependencyTreeNodeBuild currentNode;
    int currentDepth;

    public PassProcessor(MavenNDependencySolver mavenNDependencySolver) {
        this.mavenNDependencySolver = mavenNDependencySolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processNode(NDependencyTreeNodeBuild currentNode, boolean pushProvidedElsewhere) {
        this.mavenNDependencySolver.doLog("processCurrentNonProvided " + currentNode);
        if (currentNode.depth > this.currentDepth) {
            this.currentDepth = currentNode.depth;
        } else if (currentNode.depth < this.currentDepth) {
            throw new IllegalArgumentException("invalid depth " + currentNode.depth + "<" + this.currentDepth);
        }
        NDependencyInfo oldDepInfo = this.mergedVisitedSet.find(currentNode.dependency);
        if (oldDepInfo != null) {
            if (oldDepInfo.dependency.getVersion().equals(currentNode.dependency.getVersion())) {
                this.mavenNDependencySolver.doLog("processCurrentNonProvided already visited " + currentNode.dependency);
                return;
            }
            this.mavenNDependencySolver.doLog("processCurrentNonProvided already visited with other version " + currentNode.dependency + " >>> " + oldDepInfo);
            return;
        }
        if (currentNode.provided && pushProvidedElsewhere) {
            this.providedQueue.add(currentNode);
            return;
        }
        currentNode.build0();
        if (currentNode.def == null) {
            return;
        }
        NDescriptor effectiveDescriptor = currentNode.getEffectiveDescriptor();
        if (effectiveDescriptor == null) return;
        if (!currentNode.isAcceptableDependency(currentNode.dependency)) {
            return;
        }
        NId id = currentNode.getEffectiveId();
        if (currentNode.depth == 0) {
            if (!this.sourceIds.add(id) || !this.mergedVisitedSet.add(currentNode.key)) return;
            this.mergedRootNodeBuilders.add(currentNode);
            currentNode.includedInClassPath = true;
            List<NDependency> immediate = CoreFilterUtils.filterDependencies(id, currentNode.getEffectiveDescriptor().getDependencies(), this.mavenNDependencySolver.effDependencyFilter);
            this.immediates.addAll(immediate);
        } else {
            NDependencyInfo nextId = currentNode.key;
            if (this.mergedVisitedSet.contains(nextId) || !this.nonMergedVisitedSet.add(nextId)) return;
            this.mergedVisitedSet.add(nextId);
            currentNode.includedInClassPath = true;
        }
        if (currentNode.depth == 0) {
            this.nonMergedRootNodeBuilders.add(currentNode);
            currentNode.includedInClassPath = true;
        } else {
            this.mergedRootNodeBuilders.add(currentNode);
            currentNode.includedInClassPath = true;
        }
        for (NDependency dependency : effectiveDescriptor.getDependencies()) {
            if (currentNode.isAcceptableDependency(dependency)) {
                NDependencyTreeNodeBuild childNode = new NDependencyTreeNodeBuild(this.mavenNDependencySolver, currentNode, dependency, null, currentNode.depth + 1);
                currentNode.children.add(childNode);
                if (currentNode.provided && pushProvidedElsewhere) {
                    this.providedQueue.add(currentNode);
                    continue;
                }
                this.queue.add(childNode);
                continue;
            }
            this.mavenNDependencySolver.logRejectedDependency(dependency);
        }
    }

    public NDependencies run() {
        for (NDependencyTreeNodeBuild def : this.mavenNDependencySolver.defs) {
            this.queue.add(def);
        }
        while (!this.queue.isEmpty()) {
            this.currentNode = (NDependencyTreeNodeBuild)this.queue.remove();
            this.processNode(this.currentNode, true);
        }
        if (this.mavenNDependencySolver.includedProvided) {
            this.queue.addAll(this.providedQueue);
            if (!this.queue.isEmpty()) {
                this.currentDepth = 0;
                while (!this.queue.isEmpty()) {
                    this.currentNode = (NDependencyTreeNodeBuild)this.queue.remove();
                    this.processNode(this.currentNode, false);
                }
            }
        }
        List<NDependencyTreeNode> mergedRootNodes = this.mergedRootNodeBuilders.stream().map(NDependencyTreeNodeBuild::build).collect(Collectors.toList());
        List<NDependencyTreeNode> nonMergedRootNodes = this.nonMergedRootNodeBuilders.stream().map(NDependencyTreeNodeBuild::build).collect(Collectors.toList());
        NDependency[] mergedDepsList = (NDependency[])this.mergedVisitedSet.visitedSet.values().stream().map(NDependencyInfo::getDependency).toArray(NDependency[]::new);
        NDependency[] nonMergedDepsList = (NDependency[])this.nonMergedVisitedSet.visitedSet.values().stream().map(NDependencyInfo::getDependency).toArray(NDependency[]::new);
        return new DefaultNDependencies(this.mavenNDependencySolver.getName(), this.sourceIds.toArray(new NId[0]), this.mavenNDependencySolver.getDependencyFilter(), this.immediates.toArray(new NDependency[0]), nonMergedDepsList, nonMergedRootNodes.toArray(new NDependencyTreeNode[0]), mergedDepsList, mergedRootNodes.toArray(new NDependencyTreeNode[0]), () -> NElement.ofString("solver"));
    }
}

