/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.solver.maven;

import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.solver.maven.NDependencyTreeNodeBuild;

class NDependencyInfo {
    NId normalized;
    NId real;
    int depth;
    NDependency dependency;
    boolean optional;
    boolean provided;

    public NDependencyInfo(NDependency dependency, int depth, boolean optional, boolean provided) {
        this.real = dependency.toId();
        this.normalized = NDependencyInfo.normalizedId(this.real);
        this.depth = depth;
        this.dependency = dependency;
        this.optional = optional;
        this.provided = provided;
    }

    public static NId normalizedId(NId id) {
        return id.getShortId();
    }

    public static NId normalizedId(NDependency id) {
        return NDependencyInfo.normalizedId(id.toId());
    }

    public static NDependencyInfo of(NDependencyTreeNodeBuild currentNode) {
        return new NDependencyInfo(currentNode.dependency, currentNode.depth, currentNode.optional, currentNode.provided);
    }

    public NDependency getDependency() {
        return this.dependency;
    }

    public String toString() {
        return "NDependencyInfo{normalized=" + this.normalized + ", real=" + this.real + ", depth=" + this.depth + ", dependency=" + this.dependency + '}';
    }
}

