/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NDependencyUtils;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyTypeFilter
extends AbstractDependencyFilter {
    private String type = null;

    public NDependencyTypeFilter(String type) {
        super(NFilterOp.CUSTOM);
        this.type = type;
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        String curr = NDependencyUtils.normalizeDependencyType(dependency.getType());
        String toCheck = NDependencyUtils.normalizeDependencyType(this.type);
        return Objects.equals(curr, toCheck);
    }

    public String toString() {
        return this.type == null || this.type.isEmpty() ? "empty-type" : "type=" + this.type;
    }

    @Override
    public NDependencyFilter simplify() {
        return this;
    }
}

