/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyOsFilter
extends AbstractDependencyFilter {
    private Set<NOsFamily> os = EnumSet.noneOf(NOsFamily.class);

    public NDependencyOsFilter() {
        super(NFilterOp.CUSTOM);
    }

    private NDependencyOsFilter(Collection<NOsFamily> os) {
        super(NFilterOp.CUSTOM);
        this.os = EnumSet.copyOf(os);
    }

    public NDependencyOsFilter(String os) {
        super(NFilterOp.CUSTOM);
        this.os = EnumSet.noneOf(NOsFamily.class);
        for (String e : StringTokenizerUtils.splitDefault(os)) {
            if (e.isEmpty()) continue;
            this.os.add(NOsFamily.parse(e).orNull());
        }
    }

    public NDependencyOsFilter add(Collection<NOsFamily> oses) {
        if (oses == null) {
            return this;
        }
        EnumSet<NOsFamily> s2 = EnumSet.copyOf(this.os);
        NCollections.addAllNonNull(s2, oses);
        return new NDependencyOsFilter(s2);
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        List<String> current = dependency.getCondition().getOs();
        boolean empty = true;
        if (current != null) {
            for (String e : current) {
                if (e.isEmpty()) continue;
                empty = false;
                if (!this.os.contains(NOsFamily.parse(e).orNull())) continue;
                return true;
            }
        }
        return empty;
    }

    public String toString() {
        return CoreStringUtils.trueOrEqOrIn("os", this.os.stream().map(x -> x.id()).collect(Collectors.toList()));
    }

    @Override
    public NDependencyFilter simplify() {
        return this.os.isEmpty() ? (NDependencyFilter)NDependencyFilters.of().always() : this;
    }
}

