/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.dependency.filter.AbstractDependencyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDependencyFilterAnd
extends AbstractDependencyFilter
implements NComplexExpressionString {
    private final NDependencyFilter[] all;

    public NDependencyFilterAnd(NDependencyFilter ... all) {
        super(NFilterOp.AND);
        this.all = all;
    }

    @Override
    public boolean acceptDependency(NDependency dependency, NId from) {
        for (NDependencyFilter nDependencyFilter : this.all) {
            if (nDependencyFilter == null || nDependencyFilter.acceptDependency(dependency, from)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NDependencyFilter simplify() {
        return CoreFilterUtils.simplifyFilterAnd(NDependencyFilter.class, this, this.all);
    }

    public String toString() {
        return CoreStringUtils.trueOrAnd(Arrays.stream(this.all).map(NComplexExpressionString::toString).collect(Collectors.toList()));
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDependencyFilterAnd other = (NDependencyFilterAnd)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Arrays.asList(this.all);
    }
}

