/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyArchFamilyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyDEFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterAnd;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterFalse;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterNone;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterOr;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterParser;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyFilterTrue;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyOptionalFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyOsDistIdFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyOsFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyPlatformFamilyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyPlatformIdFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyScopeFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyTypeFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NExclusionDependencyFilter;
import net.thevpc.nuts.runtime.standalone.dependency.filter.ScopeNDependencyFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNTypedFilters;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NScorableContext;

public class InternalNDependencyFilters
extends InternalNTypedFilters<NDependencyFilter>
implements NDependencyFilters {
    public InternalNDependencyFilters(NWorkspace workspace) {
        super(NDependencyFilter.class);
    }

    @Override
    public NDependencyFilter always() {
        return new NDependencyFilterTrue();
    }

    @Override
    public NDependencyFilter never() {
        return new NDependencyFilterFalse();
    }

    @Override
    public NDependencyFilter all(NFilter ... others) {
        List<NDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NDependencyFilter)all.get(0);
        }
        return new NDependencyFilterAnd(all.toArray(new NDependencyFilter[0])).simplify();
    }

    @Override
    public NDependencyFilter any(NFilter ... others) {
        List<NDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NDependencyFilter)all.get(0);
        }
        return new NDependencyFilterOr(all.toArray(new NDependencyFilter[0])).simplify();
    }

    @Override
    public NDependencyFilter not(NFilter other) {
        return new NDependencyFilterNone((NDependencyFilter)other);
    }

    @Override
    public NDependencyFilter none(NFilter ... others) {
        List<NDependencyFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NDependencyFilterNone(all.toArray(new NDependencyFilter[0])).simplify();
    }

    @Override
    public NDependencyFilter from(NFilter a) {
        if (a == null) {
            return null;
        }
        NDependencyFilter t = this.as(a);
        NAssert.requireNonNull(t, "InstallDependencyFilter");
        return t;
    }

    @Override
    public NDependencyFilter as(NFilter a) {
        if (a instanceof NDependencyFilter) {
            return (NDependencyFilter)a;
        }
        return null;
    }

    @Override
    public NDependencyFilter parse(String expression) {
        return (NDependencyFilter)new NDependencyFilterParser(expression).parse();
    }

    @Override
    public NDependencyFilter nonnull(NFilter filter) {
        return (NDependencyFilter)super.nonnull(filter);
    }

    @Override
    public NDependencyFilter byScope(NDependencyScopePattern ... scopes) {
        if (scopes == null || scopes.length == 0) {
            return this.always();
        }
        return new ScopeNDependencyFilter(scopes).simplify();
    }

    @Override
    public NDependencyFilter byScope(NDependencyScope scope) {
        if (scope == null) {
            return this.always();
        }
        return new NDependencyScopeFilter().add(Arrays.asList(scope)).simplify();
    }

    @Override
    public NDependencyFilter byScope(NDependencyScope ... scopes) {
        if (scopes == null) {
            return this.always();
        }
        return new NDependencyScopeFilter().add(Arrays.asList(scopes)).simplify();
    }

    @Override
    public NDependencyFilter byScope(Collection<NDependencyScope> scopes) {
        if (scopes == null) {
            return this.always();
        }
        return new NDependencyScopeFilter().add(scopes).simplify();
    }

    @Override
    public NDependencyFilter byOptional(Boolean optional) {
        if (optional == null) {
            return this.always();
        }
        return new NDependencyOptionalFilter(optional).simplify();
    }

    @Override
    public NDependencyFilter byExclude(NDependencyFilter filter, String[] exclusions) {
        return new NExclusionDependencyFilter(filter, (NId[])Arrays.stream(exclusions).map(x -> NId.get(x).get()).toArray(NId[]::new)).simplify();
    }

    @Override
    public NDependencyFilter byArch(Collection<NArchFamily> archs) {
        if (archs == null) {
            return this.always();
        }
        return new NDependencyArchFamilyFilter().add(archs).simplify();
    }

    @Override
    public NDependencyFilter byArch(NArchFamily arch) {
        if (arch == null) {
            return this.always();
        }
        return new NDependencyArchFamilyFilter().add(Arrays.asList(arch)).simplify();
    }

    @Override
    public NDependencyFilter byArch(NArchFamily ... archs) {
        if (archs == null) {
            return this.always();
        }
        return new NDependencyArchFamilyFilter().add(Arrays.asList(archs)).simplify();
    }

    @Override
    public NDependencyFilter byArch(String arch) {
        if (arch == null) {
            return this.always();
        }
        return new NDependencyArchFamilyFilter(arch);
    }

    @Override
    public NDependencyFilter byOs(Collection<NOsFamily> os) {
        if (os == null) {
            return this.always();
        }
        return new NDependencyOsFilter().add(os).simplify();
    }

    @Override
    public NDependencyFilter byCurrentDesktop() {
        return this.byDesktop(NWorkspace.of().getDesktopEnvironmentFamilies());
    }

    @Override
    public NDependencyFilter byCurrentArch() {
        return this.byArch(NWorkspace.of().getArchFamily());
    }

    @Override
    public NDependencyFilter byCurrentOs() {
        return this.byOs(NWorkspace.of().getOsFamily());
    }

    @Override
    public NDependencyFilter byRegularType() {
        return this.byType(null).or(this.byType("jar"));
    }

    @Override
    public NDependencyFilter byCurrentEnv() {
        return this.byCurrentOs().and(this.byCurrentArch()).and(this.byCurrentDesktop());
    }

    @Override
    public NDependencyFilter byRunnable(boolean optional, boolean anyEnv) {
        return this.byScope(NDependencyScopePattern.RUN, NDependencyScopePattern.COMPILE).and(this.byOptional(optional ? null : Boolean.valueOf(false))).and(this.byRegularType()).and(anyEnv ? null : this.byCurrentEnv());
    }

    @Override
    public NDependencyFilter byRunnable(boolean optional) {
        return this.byScope(NDependencyScopePattern.RUN, NDependencyScopePattern.COMPILE).and(this.byOptional(optional ? null : Boolean.valueOf(false))).and(this.byRegularType()).and(this.byCurrentEnv());
    }

    @Override
    public NDependencyFilter byRunnable() {
        return this.byRunnable(false, false);
    }

    @Override
    public NDependencyFilter byOs(NOsFamily os) {
        if (os == null) {
            return this.always();
        }
        return new NDependencyOsFilter().add(Arrays.asList(os)).simplify();
    }

    @Override
    public NDependencyFilter byOs(NOsFamily ... os) {
        if (os == null) {
            return this.always();
        }
        return new NDependencyOsFilter().add(Arrays.asList(os)).simplify();
    }

    @Override
    public NDependencyFilter byDesktop(NDesktopEnvironmentFamily de) {
        if (de == null) {
            return this.always();
        }
        return new NDependencyDEFilter().add(Arrays.asList(de)).simplify();
    }

    @Override
    public NDependencyFilter byDesktop(NDesktopEnvironmentFamily ... de) {
        if (de == null) {
            return this.always();
        }
        return new NDependencyDEFilter().add(Arrays.asList(de)).simplify();
    }

    @Override
    public NDependencyFilter byDesktop(Collection<NDesktopEnvironmentFamily> de) {
        return this.byDesktop(de.toArray(new NDesktopEnvironmentFamily[0]));
    }

    @Override
    public NDependencyFilter byType(String type) {
        return new NDependencyTypeFilter(type).simplify();
    }

    @Override
    public NDependencyFilter byOs(String os) {
        if (os == null) {
            return this.always();
        }
        return new NDependencyOsFilter(os).simplify();
    }

    @Override
    public NDependencyFilter byOsDist(String osDist) {
        if (osDist == null) {
            return this.always();
        }
        return new NDependencyOsDistIdFilter().add(Collections.singletonList(NId.get(osDist).get())).simplify();
    }

    @Override
    public NDependencyFilter byOsDist(String ... osDists) {
        if (osDists == null || osDists.length == 0) {
            return this.always();
        }
        return new NDependencyOsDistIdFilter().add(Arrays.stream(osDists).map(x -> NId.get(x).get()).collect(Collectors.toList())).simplify();
    }

    @Override
    public NDependencyFilter byOsDist(Collection<String> osDists) {
        if (osDists == null || osDists.isEmpty()) {
            return this.always();
        }
        return new NDependencyOsDistIdFilter().add(osDists.stream().map(x -> NId.get(x).get()).collect(Collectors.toList())).simplify();
    }

    @Override
    public NDependencyFilter byPlatform(NPlatformFamily ... pf) {
        if (pf == null || pf.length == 0) {
            return this.always();
        }
        return new NDependencyPlatformFamilyFilter().add(Arrays.asList(pf)).simplify();
    }

    @Override
    public NDependencyFilter byPlatform(String ... pf) {
        if (pf == null || pf.length == 0) {
            return this.always();
        }
        return new NDependencyPlatformIdFilter().add(Arrays.stream(pf).map(x -> NId.get(x).get()).collect(Collectors.toList())).simplify();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

