/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyScopePattern;

public class NDependencyScopes {
    public static boolean isDefaultScope(String s1) {
        return NDependencyScope.parse(s1).orElse(NDependencyScope.API) == NDependencyScope.API;
    }

    public static boolean isCompileScope(String scope) {
        if (scope == null) {
            return true;
        }
        NDependencyScope r = NDependencyScope.parse(scope).orElse(NDependencyScope.API);
        return r != null && r.isCompile();
    }

    public static int getScopesPriority(String s1) {
        NDependencyScope r = NDependencyScope.parse(s1).orElse(NDependencyScope.API);
        if (r == null) {
            return -1;
        }
        switch (r) {
            case IMPLEMENTATION: {
                return 26;
            }
            case API: {
                return 25;
            }
            case RUNTIME: {
                return 24;
            }
            case PROVIDED: {
                return 23;
            }
            case SYSTEM: {
                return 22;
            }
            case OTHER: {
                return 21;
            }
            case TEST_IMPLEMENTATION: {
                return 16;
            }
            case TEST_API: {
                return 15;
            }
            case TEST_RUNTIME: {
                return 14;
            }
            case TEST_PROVIDED: {
                return 13;
            }
            case TEST_SYSTEM: {
                return 12;
            }
            case TEST_OTHER: {
                return 11;
            }
            case IMPORT: {
                return 1;
            }
        }
        return -1;
    }

    public static EnumSet<NDependencyScope> add(Collection<NDependencyScope> a, NDependencyScopePattern ... b) {
        EnumSet<NDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NDependencyScope> bb = NDependencyScopes.expand(b == null ? null : Arrays.asList(b));
        aa.addAll(bb);
        return aa;
    }

    public static EnumSet<NDependencyScope> add(Collection<NDependencyScope> a, NDependencyScope ... b) {
        EnumSet<NDependencyScope> aa = EnumSet.copyOf(a);
        List<Object> bb = b == null ? Collections.emptyList() : Arrays.asList(b);
        aa.addAll(bb);
        return aa;
    }

    public static EnumSet<NDependencyScope> removeScopes(Collection<NDependencyScope> a, Collection<NDependencyScope> b) {
        EnumSet<NDependencyScope> aa = EnumSet.copyOf(a);
        Collection<Object> bb = b == null ? Collections.emptyList() : b;
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NDependencyScope> removeScopePatterns(Collection<NDependencyScope> a, Collection<NDependencyScopePattern> b) {
        EnumSet<NDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NDependencyScope> bb = NDependencyScopes.expand(b);
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NDependencyScope> remove(Collection<NDependencyScope> a, NDependencyScopePattern ... b) {
        EnumSet<NDependencyScope> aa = EnumSet.copyOf(a);
        EnumSet<NDependencyScope> bb = NDependencyScopes.expand(b == null ? null : Arrays.asList(b));
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NDependencyScope> remove(Collection<NDependencyScope> a, NDependencyScope ... b) {
        EnumSet<NDependencyScope> aa = EnumSet.copyOf(a);
        Collection<Object> bb = b == null ? Collections.emptySet() : Arrays.asList(b);
        aa.removeAll(bb);
        return aa;
    }

    public static EnumSet<NDependencyScope> expand(Collection<NDependencyScopePattern> other) {
        EnumSet<NDependencyScope> a = EnumSet.noneOf(NDependencyScope.class);
        if (other != null) {
            for (NDependencyScopePattern s : other) {
                if (s == null) continue;
                a.addAll(s.toScopes());
            }
        }
        return a;
    }
}

