/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NDependencyScopePattern;
import net.thevpc.nuts.runtime.standalone.dependency.filter.NDependencyScopeFilter;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NRef;

public class NDependencyFilterUtils {
    public static Set<NDependencyScope> toScopeFilterPossibilities(NDependencyFilter filter) {
        if (filter instanceof NDependencyScopeFilter) {
            return new LinkedHashSet<NDependencyScope>(((NDependencyScopeFilter)filter).getScopes());
        }
        if (filter.getFilterOp() == NFilterOp.AND) {
            LinkedHashSet<NDependencyScope> a = null;
            for (NFilter subFilter : filter.getSubFilters()) {
                Set<NDependencyScope> r = NDependencyFilterUtils.toScopeFilterPossibilities((NDependencyFilter)subFilter);
                if (r == null) {
                    return null;
                }
                if (a == null) {
                    a = new LinkedHashSet<NDependencyScope>(r);
                    continue;
                }
                a.retainAll(r);
            }
            if (a == null) {
                return new LinkedHashSet<NDependencyScope>();
            }
            return a;
        }
        if (filter.getFilterOp() == NFilterOp.OR) {
            LinkedHashSet<NDependencyScope> a = null;
            for (NFilter subFilter : filter.getSubFilters()) {
                Set<NDependencyScope> r = NDependencyFilterUtils.toScopeFilterPossibilities((NDependencyFilter)subFilter);
                if (r == null) {
                    return null;
                }
                if (a == null) {
                    a = new LinkedHashSet<NDependencyScope>(r);
                    continue;
                }
                a.addAll(r);
            }
            if (a == null) {
                return new LinkedHashSet<NDependencyScope>();
            }
            return a;
        }
        return null;
    }

    public static boolean isScopeFilter(NDependencyFilter filter) {
        if (filter instanceof NDependencyScopeFilter) {
            return true;
        }
        if (filter.getFilterOp() == NFilterOp.AND) {
            return filter.getSubFilters().stream().allMatch(x -> NDependencyFilterUtils.isScopeFilter((NDependencyFilter)x));
        }
        if (filter.getFilterOp() == NFilterOp.OR) {
            return filter.getSubFilters().stream().allMatch(x -> NDependencyFilterUtils.isScopeFilter((NDependencyFilter)x));
        }
        return false;
    }

    public static NDependencyFilter addScope(NDependencyFilter parent, final NDependencyScopePattern scope) {
        if (parent == null) {
            return NDependencyFilters.of().byScope(scope);
        }
        if (scope == null) {
            return parent;
        }
        final NRef<Boolean> found = NRef.of(false);
        NDependencyFilter np = NDependencyFilterUtils.replaceFilter(parent, (Function<NDependencyFilter, NDependencyFilter>)new NFunction<NDependencyFilter, NDependencyFilter>(){

            @Override
            public NDependencyFilter apply(NDependencyFilter old) {
                Set<NDependencyScope> li = NDependencyFilterUtils.toScopeFilterPossibilities(old);
                if (li != null) {
                    found.set(true);
                    LinkedHashSet<NDependencyScope> li2 = new LinkedHashSet<NDependencyScope>(li);
                    li2.addAll(scope.toScopes());
                    if (!li2.equals(li)) {
                        return NDependencyFilters.of().byScope(li2.toArray(new NDependencyScope[0]));
                    }
                }
                return old;
            }
        });
        if (!found.get().booleanValue()) {
            np = np.and(NDependencyFilters.of().byScope(scope));
        }
        return np;
    }

    public static NDependencyFilter replaceFilter(NDependencyFilter parent, Function<NDependencyFilter, NDependencyFilter> replacer) {
        if (parent == null) {
            return null;
        }
        NDependencyFilter n = replacer.apply(parent);
        if (n == null) {
            return null;
        }
        if (n != parent) {
            return n;
        }
        if (parent.getFilterOp() == NFilterOp.AND) {
            ArrayList<NDependencyFilter> newList = new ArrayList<NDependencyFilter>();
            boolean someChanges = false;
            for (NFilter subFilter : parent.getSubFilters()) {
                n = replacer.apply((NDependencyFilter)subFilter);
                if (n == null) {
                    someChanges = true;
                    continue;
                }
                if (n == subFilter) {
                    newList.add(n);
                    continue;
                }
                someChanges = true;
                newList.add(n);
            }
            if (someChanges) {
                return (NDependencyFilter)NDependencyFilters.of().all(newList.toArray(new NDependencyFilter[0]));
            }
            return parent;
        }
        return parent;
    }
}

