/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.dependency;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyFilter;
import net.thevpc.nuts.artifact.NDependencyTreeNode;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.util.NIterator;
import net.thevpc.nuts.util.NStream;

public class DefaultNDependencies
implements NDependencies {
    private String solver;
    private NId[] sourceIds;
    private NDependencyFilter filter;
    private NDependency[] immediateDependencies;
    private NDependency[] nonMergedDependencies;
    private NDependencyTreeNode[] nonMergedNodes;
    private NDependency[] mergedDependencies;
    private NDependencyTreeNode[] mergedNodes;
    private transient Supplier<NElement> description;

    public DefaultNDependencies(String solver, NId[] ids, NDependencyFilter filter, NDependency[] immediateDependencies, NDependency[] nonMergedDependencies, NDependencyTreeNode[] nonMergedNodes, NDependency[] mergedDependencies, NDependencyTreeNode[] mergedNodes, Supplier<NElement> description) {
        this.sourceIds = ids;
        this.solver = solver;
        this.filter = filter;
        this.immediateDependencies = immediateDependencies;
        this.nonMergedDependencies = nonMergedDependencies;
        this.nonMergedNodes = nonMergedNodes;
        this.mergedNodes = mergedNodes;
        this.mergedDependencies = mergedDependencies;
        this.description = description;
    }

    @Override
    public String solver() {
        return this.solver;
    }

    @Override
    public NStream<NId> sourceIds() {
        return NStream.ofIterator((Iterator)NIterator.of(Arrays.asList(this.sourceIds).iterator()).redescribe(this.description));
    }

    @Override
    public NDependencyFilter filter() {
        return this.filter;
    }

    @Override
    public NStream<NDependency> immediate() {
        return NStream.ofIterator((Iterator)NIterator.of(Arrays.asList(this.immediateDependencies).iterator()).redescribe(this.description));
    }

    @Override
    public NStream<NDependency> transitive() {
        return NStream.ofIterator((Iterator)NIterator.of(Arrays.asList(this.nonMergedDependencies).iterator()).redescribe(this.description));
    }

    @Override
    public NStream<NDependencyTreeNode> transitiveNodes() {
        return NStream.ofIterator((Iterator)NIterator.of(Arrays.asList(this.nonMergedNodes).iterator()).redescribe(this.description));
    }

    @Override
    public NStream<NDependency> transitiveWithSource() {
        return NStream.ofIterator((Iterator)NIterator.of(Arrays.asList(this.mergedDependencies).iterator()).redescribe(this.description));
    }

    @Override
    public NStream<NDependencyTreeNode> sourceNodes() {
        return NStream.ofIterator((Iterator)NIterator.of(Arrays.asList(this.mergedNodes).iterator()).redescribe(this.description));
    }

    @Override
    public List<NDependency> toList() {
        return this.transitive().toList();
    }

    @Override
    public NIterator<NDependency> iterator() {
        return this.transitive().iterator();
    }

    @Override
    public NElement describe() {
        return NElementDescribables.safeDescribe(this.description);
    }

    @Override
    public NDependencies redescribe(Supplier<NElement> description) {
        this.description = description;
        return this;
    }
}

