/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.repository.impl.main.NInstalledRepository;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NInstallStatusDefinitionFilter2
extends AbstractDefinitionFilter {
    private final Mode mode;
    private final boolean value;

    public static NDefinitionFilter ofInstalled(boolean value) {
        return new NInstallStatusDefinitionFilter2(Mode.INSTALLED, value);
    }

    public static NDefinitionFilter ofInstalledOrRequired(boolean value) {
        return new NInstallStatusDefinitionFilter2(Mode.INSTALLED_OR_REQUIRED, value);
    }

    public static NDefinitionFilter ofRequired(boolean value) {
        return new NInstallStatusDefinitionFilter2(Mode.REQUIRED, value);
    }

    public static NDefinitionFilter ofObsolete(boolean value) {
        return new NInstallStatusDefinitionFilter2(Mode.OBSOLETE, value);
    }

    public static NDefinitionFilter ofDefaultVersion(boolean value) {
        return new NInstallStatusDefinitionFilter2(Mode.DEFAULT_VERSION, value);
    }

    public static NDefinitionFilter ofDeployed(boolean value) {
        return new NInstallStatusDefinitionFilter2(Mode.DEPLOYED, value);
    }

    public NInstallStatusDefinitionFilter2(Mode mode, boolean value) {
        super(NFilterOp.CUSTOM);
        this.mode = mode;
        this.value = value;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isValue() {
        return this.value;
    }

    @Override
    public boolean acceptDefinition(NDefinition definition) {
        NInstalledRepository installedRepository = NWorkspaceExt.of().getInstalledRepository();
        NInstallInformation n = installedRepository.getInstallInformation(definition.getId());
        NInstallStatus status = n.getInstallStatus();
        if (status == null) {
            return false;
        }
        switch (this.mode.ordinal()) {
            case 0: {
                return status.isInstalled();
            }
            case 2: {
                return status.isDeployed();
            }
            case 1: {
                return status.isRequired();
            }
            case 4: {
                return status.isObsolete();
            }
            case 5: {
                return status.isDefaultVersion();
            }
            case 6: {
                return status.isInstalledOrRequired();
            }
            case 3: {
                return status.isNonDeployed();
            }
        }
        return false;
    }

    @Override
    public NDefinitionFilter simplify() {
        return this;
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Collections.emptyList();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.value});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NInstallStatusDefinitionFilter2 that = (NInstallStatusDefinitionFilter2)o;
        return this.value == that.value && Objects.equals((Object)this.mode, (Object)that.mode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.value) {
            sb.append("!");
        }
        sb.append((Object)this.mode);
        return sb.toString();
    }

    public static enum Mode {
        INSTALLED,
        REQUIRED,
        DEPLOYED,
        NON_DEPLOYED,
        OBSOLETE,
        DEFAULT_VERSION,
        INSTALLED_OR_REQUIRED;

    }
}

