/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterPlatform
extends AbstractDefinitionFilter {
    private final String platform;

    public NDefinitionFilterPlatform(String packaging) {
        super(NFilterOp.CUSTOM);
        this.platform = packaging;
    }

    public String getPlatform() {
        return this.platform;
    }

    @Override
    public boolean acceptDefinition(NDefinition descriptor) {
        return CoreFilterUtils.matchesPlatform(this.platform, descriptor.getDescriptor().getCondition().getPlatform());
    }

    @Override
    public NDefinitionFilter simplify() {
        if (NBlankable.isBlank(this.platform)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.platform);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterPlatform other = (NDefinitionFilterPlatform)obj;
        return Objects.equals(this.platform, other.platform);
    }

    public String toString() {
        return "Platform{" + this.platform + '}';
    }
}

