/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterOs
extends AbstractDefinitionFilter {
    private final String os;

    public NDefinitionFilterOs(String os) {
        super(NFilterOp.CUSTOM);
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    @Override
    public boolean acceptDefinition(NDefinition descriptor) {
        return CoreFilterUtils.matchesOs(this.os, descriptor.getDescriptor().getCondition().getOs());
    }

    @Override
    public NDefinitionFilter simplify() {
        if (NBlankable.isBlank(this.os)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.os);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterOs other = (NDefinitionFilterOs)obj;
        return Objects.equals(this.os, other.os);
    }

    public String toString() {
        return "Os{" + this.os + '}';
    }
}

