/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.dependency.util.NComplexExpressionString;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterNone
extends AbstractDefinitionFilter {
    private NDefinitionFilter[] all;

    public NDefinitionFilterNone(NDefinitionFilter ... all) {
        super(NFilterOp.NOT);
        ArrayList<NDefinitionFilter> valid = new ArrayList<NDefinitionFilter>();
        if (all != null) {
            for (NDefinitionFilter filter : all) {
                if (filter == null) continue;
                valid.add(filter);
            }
        }
        this.all = valid.toArray(new NDefinitionFilter[0]);
    }

    @Override
    public boolean acceptDefinition(NDefinition id) {
        if (this.all.length == 0) {
            return true;
        }
        for (NDefinitionFilter filter : this.all) {
            if (!filter.acceptDefinition(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public NDefinitionFilter simplify() {
        return CoreFilterUtils.simplifyFilterNone(NDefinitionFilter.class, this, this.all);
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Arrays.deepHashCode(this.all);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterNone other = (NDefinitionFilterNone)obj;
        return Arrays.deepEquals(this.all, other.all);
    }

    public String toString() {
        return CoreStringUtils.trueOrNone(Arrays.stream(this.all).map(NComplexExpressionString::toString).collect(Collectors.toList()));
    }

    @Override
    public List<NFilter> getSubFilters() {
        return Arrays.asList(this.all);
    }
}

