/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterDesktopEnvironment
extends AbstractDefinitionFilter {
    private final String desktopEnvironment;

    public NDefinitionFilterDesktopEnvironment(String desktopEnvironment) {
        super(NFilterOp.CUSTOM);
        this.desktopEnvironment = desktopEnvironment;
    }

    public String getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    @Override
    public boolean acceptDefinition(NDefinition descriptor) {
        return CoreFilterUtils.matchesDesktopEnvironment(this.desktopEnvironment, descriptor.getDescriptor().getCondition().getDesktopEnvironment());
    }

    @Override
    public NDefinitionFilter simplify() {
        if (NBlankable.isBlank(this.desktopEnvironment)) {
            return null;
        }
        return this;
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.desktopEnvironment);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterDesktopEnvironment other = (NDefinitionFilterDesktopEnvironment)obj;
        return Objects.equals(this.desktopEnvironment, other.desktopEnvironment);
    }

    public String toString() {
        return "Platform{" + this.desktopEnvironment + '}';
    }
}

