/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.version.filter.DefaultNVersionFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionFilterByVersion
extends AbstractDefinitionFilter {
    private NVersionFilter versionFilter;

    public NDefinitionFilterByVersion(String versionFilter, NVersionComparator versionComparator) {
        super(NFilterOp.CUSTOM);
        this.versionFilter = (NVersionFilter)DefaultNVersionFilter.parse(versionFilter, versionComparator).get().simplify();
    }

    @Override
    public boolean acceptDefinition(NDefinition definition) {
        if (this.versionFilter != null) {
            return this.versionFilter.acceptVersion(definition.getId().getVersion());
        }
        return true;
    }

    @Override
    public NDefinitionFilter simplify() {
        switch (this.versionFilter.getFilterOp()) {
            case TRUE: {
                return (NDefinitionFilter)NDefinitionFilters.of().always();
            }
            case FALSE: {
                return (NDefinitionFilter)NDefinitionFilters.of().never();
            }
        }
        return this;
    }

    public String toString() {
        return "version=" + this.versionFilter;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.versionFilter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterByVersion other = (NDefinitionFilterByVersion)obj;
        return Objects.equals(this.versionFilter, other.versionFilter);
    }
}

