/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;

public class NDefinitionFilterByMapVersion
extends AbstractDefinitionFilter {
    private NVersionFilter versionFilter;

    public NDefinitionFilterByMapVersion(NVersionFilter versionFilter) {
        super(NFilterOp.CONVERT);
        this.versionFilter = versionFilter;
    }

    @Override
    public boolean acceptDefinition(NDefinition definition) {
        if (this.versionFilter != null) {
            return this.versionFilter.acceptVersion(definition.getId().getVersion());
        }
        return true;
    }

    @Override
    public NDefinitionFilter simplify() {
        NVersionFilter id2;
        if (this.versionFilter != null && this.versionFilter instanceof NSimplifiable && (id2 = (NVersionFilter)((NSimplifiable)((Object)this.versionFilter)).simplify()) != this.versionFilter) {
            if (id2 == null) {
                return null;
            }
            return new NDefinitionFilterByMapVersion(id2);
        }
        return this;
    }

    public String toString() {
        return "Version{" + this.versionFilter + '}';
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.versionFilter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionFilterByMapVersion other = (NDefinitionFilterByMapVersion)obj;
        return Objects.equals(this.versionFilter, other.versionFilter);
    }
}

