/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NLiteral;

public class NDefinitionExecRuntimeFilter
extends AbstractDefinitionFilter {
    private NId apiId;
    private boolean communityRuntime;

    public NDefinitionExecRuntimeFilter(NId apiId, boolean communityRuntime) {
        super(NFilterOp.CUSTOM);
        this.apiId = apiId;
        this.communityRuntime = communityRuntime;
    }

    @Override
    public boolean acceptDefinition(NDefinition other) {
        if (other.getId().getShortName().equals("net.thevpc.nuts:nuts-runtime")) {
            if (this.apiId == null) {
                return true;
            }
            for (NDependency dependency : other.getDescriptor().getDependencies()) {
                if (!dependency.toId().getShortName().equals(this.apiId.getShortName())) continue;
                return this.apiId.getVersion().equals(dependency.toId().getVersion());
            }
        }
        if (this.communityRuntime) {
            if (!other.getDescriptor().getPropertyValue("nuts-runtime").flatMap(NLiteral::asBoolean).orElse(false).booleanValue()) {
                return false;
            }
            for (NDependency dependency : other.getDescriptor().getDependencies()) {
                if (!dependency.toId().getShortName().equals(this.apiId.getShortName())) continue;
                if (this.apiId == null) {
                    return true;
                }
                return this.apiId.getVersion().equals(dependency.toId().getVersion());
            }
        }
        return false;
    }

    @Override
    public NDefinitionFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "runtime";
        }
        return "runtime(" + this.apiId.getVersion() + ")";
    }
}

