/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionExecExtensionFilter
extends AbstractDefinitionFilter {
    private NId apiId;

    public NDefinitionExecExtensionFilter(NId apiId) {
        super(NFilterOp.CUSTOM);
        this.apiId = apiId;
    }

    @Override
    public boolean acceptDefinition(NDefinition other) {
        if (other.getDescriptor().getIdType() != NIdType.EXTENSION) {
            return false;
        }
        for (NDependency dependency : other.getDescriptor().getDependencies()) {
            if (!dependency.toId().getShortName().equals(this.apiId.getShortName())) continue;
            if (this.apiId == null) {
                return true;
            }
            return this.apiId.getVersion().equals(dependency.toId().getVersion());
        }
        return false;
    }

    @Override
    public NDefinitionFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "extension";
        }
        return "extension(" + this.apiId.getVersion() + ")";
    }
}

