/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.util.NFilterOp;

public class NDefinitionExecCompanionFilter
extends AbstractDefinitionFilter {
    private NId apiId;
    private Set<String> companions;

    public NDefinitionExecCompanionFilter(NId apiId, String[] shortIds) {
        super(NFilterOp.CUSTOM);
        this.apiId = apiId;
        this.companions = new HashSet<String>(Arrays.asList(shortIds));
    }

    @Override
    public boolean acceptDefinition(NDefinition other) {
        if (this.companions.contains(other.getId().getShortName())) {
            for (NDependency dependency : other.getDescriptor().getDependencies()) {
                if (!dependency.toId().getShortName().equals(this.apiId.getShortName())) continue;
                if (this.apiId == null) {
                    return true;
                }
                return this.apiId.getVersion().equals(dependency.toId().getVersion());
            }
            return false;
        }
        return false;
    }

    @Override
    public NDefinitionFilter simplify() {
        return this;
    }

    public String toString() {
        if (this.apiId == null) {
            return "companion";
        }
        return "companion(" + this.apiId.getVersion() + ")";
    }
}

