/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NStream;

public class NDefinitionDesktopEnvironmentFamilyFilter
extends AbstractDefinitionFilter {
    private Set<NDesktopEnvironmentFamily> accepted = new HashSet<NDesktopEnvironmentFamily>();

    public NDefinitionDesktopEnvironmentFamilyFilter(Collection<NDesktopEnvironmentFamily> accepted) {
        super(NFilterOp.CUSTOM);
        LinkedHashSet s2 = new LinkedHashSet();
        NCollections.addAllNonNull(s2, accepted);
        this.accepted = new LinkedHashSet<NDesktopEnvironmentFamily>(s2);
    }

    @Override
    public boolean acceptDefinition(NDefinition def) {
        List<NDesktopEnvironmentFamily> current = NStream.ofIterable(def.getDescriptor().getCondition().getDesktopEnvironment()).filterNonBlank().map(x -> NDesktopEnvironmentFamily.parse(x).orNull()).filterNonBlank().toList();
        if (current.isEmpty() || this.accepted.isEmpty()) {
            return true;
        }
        for (NDesktopEnvironmentFamily osf : this.accepted) {
            if (!CoreFilterUtils.matchesEnum(osf, current)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return CoreStringUtils.trueOrEqOrIn("desktopEnvironmentFamily", this.accepted.stream().map(x -> x.toString()).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter simplify() {
        return this.accepted.isEmpty() ? (NDefinitionFilter)NDefinitionFilters.of().always() : this;
    }
}

