/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.runtime.standalone.definition.filter.AbstractDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;

public class NDefaultVersionDefinitionFilter
extends AbstractDefinitionFilter
implements NDefinitionFilter,
NSimplifiable<NDefinitionFilter> {
    private final Boolean defaultVersion;

    public NDefaultVersionDefinitionFilter(Boolean defaultVersion) {
        super(NFilterOp.CUSTOM);
        this.defaultVersion = defaultVersion;
    }

    @Override
    public boolean acceptDefinition(NDefinition definition) {
        if (this.defaultVersion == null) {
            return true;
        }
        return NWorkspaceExt.of().getInstalledRepository().isDefaultVersion(definition.getId()) == this.defaultVersion.booleanValue();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.defaultVersion);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefaultVersionDefinitionFilter other = (NDefaultVersionDefinitionFilter)obj;
        return Objects.equals(this.defaultVersion, other.defaultVersion);
    }

    @Override
    public NDefinitionFilter simplify() {
        if (this.defaultVersion == null) {
            return (NDefinitionFilter)NDefinitionFilters.of().always();
        }
        return this;
    }

    public String toString() {
        return "defaultVersion(" + this.defaultVersion + ")";
    }
}

