/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NDefinitionFilters;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.platform.NArchFamily;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefaultVersionDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionArchFamilyFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionDesktopEnvironmentFamilyFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionDesktopEnvironmentIdFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionExecCompanionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionExecExtensionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionExecRuntimeFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterAnd;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterArch;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterById;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterByMapVersion;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterByVersion;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterFalse;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterNone;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterOr;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterPackaging;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterParser;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFilterTrue;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionFlagsIdFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionOsDistIdFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionOsFamilyFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionOsIdFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionPlatformFamilyFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NDefinitionPlatformIdFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NInstallStatusDefinitionFilter2;
import net.thevpc.nuts.runtime.standalone.definition.filter.NLockedIdExtensionDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NPatternDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NutsAPIDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.definition.filter.NutsBootNDefinitionFilter;
import net.thevpc.nuts.runtime.standalone.util.filters.InternalNTypedFilters;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilter;
import net.thevpc.nuts.util.NScorableContext;

public class InternalNDefinitionFilters
extends InternalNTypedFilters<NDefinitionFilter>
implements NDefinitionFilters {
    public InternalNDefinitionFilters(NWorkspace workspace) {
        super(NDefinitionFilter.class);
    }

    @Override
    public NDefinitionFilter always() {
        return new NDefinitionFilterTrue();
    }

    @Override
    public NDefinitionFilter never() {
        return new NDefinitionFilterFalse();
    }

    @Override
    public NDefinitionFilter not(NFilter other) {
        return new NDefinitionFilterNone((NDefinitionFilter)other);
    }

    @Override
    public NDefinitionFilter byPackaging(String ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NDefinitionFilterPackaging> packs = new ArrayList<NDefinitionFilterPackaging>();
        for (String v : values) {
            packs.add(new NDefinitionFilterPackaging(v));
        }
        if (packs.size() == 1) {
            return (NDefinitionFilter)packs.get(0);
        }
        return this.all(packs.toArray(new NDefinitionFilter[0]));
    }

    @Override
    public NDefinitionFilter byArch(String ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NDefinitionFilterArch> packs = new ArrayList<NDefinitionFilterArch>();
        for (String v : values) {
            packs.add(new NDefinitionFilterArch(v));
        }
        if (packs.size() == 1) {
            return (NDefinitionFilter)packs.get(0);
        }
        return this.all(packs.toArray(new NDefinitionFilter[0]));
    }

    @Override
    public NDefinitionFilter byArch(NArchFamily ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        ArrayList<NDefinitionFilterArch> packs = new ArrayList<NDefinitionFilterArch>();
        for (NArchFamily v : values) {
            packs.add(new NDefinitionFilterArch(v.id()));
        }
        if (packs.size() == 1) {
            return (NDefinitionFilter)packs.get(0);
        }
        return this.all(packs.toArray(new NDefinitionFilter[0]));
    }

    @Override
    public NDefinitionFilter byOsDist(String ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionOsDistIdFilter(Arrays.stream(values).map(x -> x == null ? null : NId.of(x)).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byOsFamily(NOsFamily ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionOsFamilyFilter(Arrays.asList(values));
    }

    @Override
    public NDefinitionFilter byArchFamily(NArchFamily ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionArchFamilyFilter(Arrays.asList(values));
    }

    @Override
    public NDefinitionFilter byOs(String ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionOsIdFilter(Arrays.stream(values).map(x -> x == null ? null : NId.get(x).orNull()).filter(x -> x != null).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byOs(NId ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionOsIdFilter(Arrays.stream(values).filter(x -> x != null).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byPlatform(NId ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionPlatformIdFilter(Arrays.stream(values).filter(x -> x != null).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byPlatformFamily(NPlatformFamily ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionPlatformFamilyFilter(Arrays.stream(values).filter(x -> x != null).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byPlatform(String ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionPlatformIdFilter(Arrays.stream(values).map(x -> x == null ? null : NId.get(x).orNull()).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byDesktopEnvironmentFamily(NDesktopEnvironmentFamily ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionDesktopEnvironmentFamilyFilter(Arrays.stream(values).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byDesktopEnvironment(String ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionDesktopEnvironmentIdFilter(Arrays.stream(values).map(x -> x == null ? null : NId.get(x).orNull()).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byDesktopEnvironment(NId ... values) {
        if (values == null || values.length == 0) {
            return this.always();
        }
        return new NDefinitionDesktopEnvironmentIdFilter(Arrays.stream(values).collect(Collectors.toList()));
    }

    @Override
    public NDefinitionFilter byExtension(NVersion targetApiVersion) {
        return new NDefinitionExecExtensionFilter(targetApiVersion == null ? null : NId.get("net.thevpc.nuts:nuts").get().builder().setVersion(targetApiVersion).build());
    }

    @Override
    public NDefinitionFilter byRuntime(NVersion targetApiVersion) {
        return new NDefinitionExecRuntimeFilter(targetApiVersion == null ? null : NId.get("net.thevpc.nuts:nuts").get().builder().setVersion(targetApiVersion).build(), false);
    }

    @Override
    public NDefinitionFilter byCompanion(NVersion targetApiVersion) {
        return new NDefinitionExecCompanionFilter(targetApiVersion == null ? null : NId.get("net.thevpc.nuts:nuts").get().builder().setVersion(targetApiVersion).build(), (String[])NExtensions.of().getCompanionIds().stream().map(NId::getShortName).toArray(String[]::new));
    }

    @Override
    public NDefinitionFilter byApiVersion(NVersion apiVersion) {
        if (apiVersion == null) {
            apiVersion = NWorkspace.of().getApiVersion();
        }
        return new NutsAPIDefinitionFilter(apiVersion);
    }

    @Override
    public NDefinitionFilter byBootVersion(NVersion bootVersion) {
        if (bootVersion == null) {
            bootVersion = NWorkspace.of().getBootVersion();
        }
        return new NutsBootNDefinitionFilter(bootVersion);
    }

    @Override
    public NDefinitionFilter byLockedIds(String ... ids) {
        return new NLockedIdExtensionDefinitionFilter((NId[])Arrays.stream(ids).filter(NBlankable::isNonBlank).map(x -> NId.get(x).get()).toArray(NId[]::new));
    }

    @Override
    public NDefinitionFilter byLockedIds(NId ... ids) {
        return new NLockedIdExtensionDefinitionFilter((NId[])Arrays.stream(ids).filter(Objects::nonNull).toArray(NId[]::new));
    }

    @Override
    public NDefinitionFilter byVersion(String version) {
        return new NDefinitionFilterByVersion(version, null);
    }

    @Override
    public NDefinitionFilter byVersion(NVersion version) {
        return new NDefinitionFilterByMapVersion(version.filter());
    }

    @Override
    public NDefinitionFilter byVersion(NVersionFilter version) {
        return new NDefinitionFilterByMapVersion(version);
    }

    @Override
    public NDefinitionFilter as(NFilter a) {
        if (a instanceof NDefinitionFilter) {
            return (NDefinitionFilter)a;
        }
        if (a instanceof NIdFilter) {
            return new NDefinitionFilterById((NIdFilter)a);
        }
        if (a instanceof NVersionFilter) {
            return new NDefinitionFilterByMapVersion((NVersionFilter)a);
        }
        return null;
    }

    @Override
    public NDefinitionFilter from(NFilter a) {
        if (a == null) {
            return null;
        }
        NDefinitionFilter t = this.as(a);
        NAssert.requireNonNull(t, "DefinitionFilter");
        return t;
    }

    @Override
    public NDefinitionFilter all(NFilter ... others) {
        List<NDefinitionFilter> all = this.convertList(others);
        for (int i = all.size() - 1; i >= 0; --i) {
            NDefinitionFilter c = (NDefinitionFilter)((NDefinitionFilter)all.get(i)).simplify();
            if (c != null) {
                if (c.equals(this.always())) {
                    if (all.size() <= 1) continue;
                    all.remove(i);
                    continue;
                }
                if (!c.equals(this.never())) continue;
                return this.never();
            }
            all.remove(i);
        }
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NDefinitionFilter)all.get(0);
        }
        return new NDefinitionFilterAnd(all.toArray(new NDefinitionFilter[0]));
    }

    @Override
    public NDefinitionFilter any(NFilter ... others) {
        List<NDefinitionFilter> all = this.convertList(others);
        for (int i = all.size() - 1; i >= 0; --i) {
            NDefinitionFilter c = (NDefinitionFilter)((NDefinitionFilter)all.get(i)).simplify();
            if (c != null) {
                if (c.equals(this.never())) {
                    if (all.size() <= 1) continue;
                    all.remove(i);
                    continue;
                }
                if (!c.equals(this.always())) continue;
                return this.always();
            }
            all.remove(i);
        }
        if (all.isEmpty()) {
            return this.always();
        }
        if (all.size() == 1) {
            return (NDefinitionFilter)all.get(0);
        }
        return new NDefinitionFilterOr(all.toArray(new NDefinitionFilter[0]));
    }

    @Override
    public NDefinitionFilter none(NFilter ... others) {
        List<NDefinitionFilter> all = this.convertList(others);
        if (all.isEmpty()) {
            return this.always();
        }
        return new NDefinitionFilterNone(all.toArray(new NDefinitionFilter[0]));
    }

    @Override
    public NDefinitionFilter parse(String expression) {
        return (NDefinitionFilter)new NDefinitionFilterParser(expression).parse();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NDefinitionFilter byPackaging(Collection<String> values) {
        return this.byPackaging(values.toArray(new String[0]));
    }

    @Override
    public NDefinitionFilter byArch(Collection<NArchFamily> values) {
        return this.byArch(values.toArray(new NArchFamily[0]));
    }

    @Override
    public NDefinitionFilter byOsFamily(Collection<NOsFamily> values) {
        return this.byOsFamily(values.toArray(new NOsFamily[0]));
    }

    @Override
    public NDefinitionFilter byOsDist(Collection<String> values) {
        return this.byOsDist(values.toArray(new String[0]));
    }

    @Override
    public NDefinitionFilter byPlatform(Collection<String> values) {
        return this.byPlatform(values.toArray(new String[0]));
    }

    @Override
    public NDefinitionFilter byDesktopEnvironment(Collection<String> values) {
        return this.byDesktopEnvironment(values.toArray(new String[0]));
    }

    @Override
    public NDefinitionFilter byFlag(Collection<NDescriptorFlag> flags) {
        return this.byFlag(flags.toArray(new NDescriptorFlag[0]));
    }

    @Override
    public NDefinitionFilter byFlag(NDescriptorFlag ... flags) {
        return new NDefinitionFlagsIdFilter(false, flags);
    }

    @Override
    public NDefinitionFilter byEffectiveFlag(Collection<NDescriptorFlag> flags) {
        return this.byEffectiveFlag(flags.toArray(new NDescriptorFlag[0]));
    }

    @Override
    public NDefinitionFilter byEffectiveFlag(NDescriptorFlag ... flags) {
        return new NDefinitionFlagsIdFilter(true, flags);
    }

    @Override
    public NDefinitionFilter byCurrentDesktopEnvironmentFamily() {
        return this.byDesktopEnvironmentFamily(NWorkspace.of().getDesktopEnvironmentFamilies().toArray(new NDesktopEnvironmentFamily[0]));
    }

    @Override
    public NDefinitionFilter byCurrentArch() {
        return this.byArch(NWorkspace.of().getArchFamily());
    }

    @Override
    public NDefinitionFilter byCurrentOsFamily() {
        return this.byOsFamily(NWorkspace.of().getOsFamily());
    }

    @Override
    public NDefinitionFilter byCurrentEnv() {
        return this.byCurrentOsFamily().and(this.byCurrentArch()).and(this.byCurrentDesktopEnvironmentFamily());
    }

    @Override
    public NDefinitionFilter byDefaultVersion(Boolean defaultVersion) {
        if (defaultVersion == null) {
            return this.always();
        }
        return new NDefaultVersionDefinitionFilter(defaultVersion);
    }

    @Override
    public NDefinitionFilter byName(String ... names) {
        if (names == null || names.length == 0) {
            return this.always();
        }
        NDefinitionFilter f = null;
        for (String wildcardId : names) {
            f = f == null ? new NPatternDefinitionFilter(NId.get(wildcardId).get()) : f.or(new NPatternDefinitionFilter(NId.get(wildcardId).get()));
        }
        if (f == null) {
            return this.always();
        }
        return f;
    }

    @Override
    public NDefinitionFilter byEnv(Map<String, String> faceMap) {
        return this.byArch(faceMap.get("arch")).and(this.byOs(faceMap.get("os"))).and(this.byOsDist(faceMap.get("osdist"))).and(this.byPlatform(faceMap.get("platform"))).and(this.byDesktopEnvironment(faceMap.get("desktop")));
    }

    @Override
    public NDefinitionFilter byInstalled(boolean value) {
        return NInstallStatusDefinitionFilter2.ofInstalled(value);
    }

    @Override
    public NDefinitionFilter byInstalledOrRequired(boolean value) {
        return NInstallStatusDefinitionFilter2.ofInstalledOrRequired(value);
    }

    @Override
    public NDefinitionFilter byRequired(boolean value) {
        return NInstallStatusDefinitionFilter2.ofRequired(value);
    }

    @Override
    public NDefinitionFilter byDefaultVersion(boolean value) {
        return NInstallStatusDefinitionFilter2.ofDefaultVersion(value);
    }

    @Override
    public NDefinitionFilter byObsolete(boolean value) {
        return NInstallStatusDefinitionFilter2.ofObsolete(value);
    }

    @Override
    public NDefinitionFilter byDeployed(boolean value) {
        return NInstallStatusDefinitionFilter2.ofDeployed(value);
    }
}

