/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.concurrent.NOnceValue;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionDelegate;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.spi.NRepositorySPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.UncheckedException;

public class NDefinitionHelper {
    public static NDefinition ofDefinition(NId id) {
        return new LazyLoadingNDefinition(id);
    }

    public static NDefinition ofIdOnlyFromRepo(NId id, NRepository repo, String callerName) {
        NRepositorySPI repoSPI = NWorkspaceUtils.of(repo.getWorkspace()).toRepositorySPI(repo);
        return NDefinitionHelper.ofIdAndLazyDescriptor(id, () -> repoSPI.fetchDescriptor().setId(id).getResult(), callerName);
    }

    public static NDefinition ofIdAndLazyDescriptor(NId id, Supplier<NDescriptor> descriptorSupplier, String callerName) {
        return new DefinitionForIdAndLazyDescriptor(id, descriptorSupplier, callerName);
    }

    public static NDefinition ofDescriptorOnly(NId id, NDescriptor descriptor) {
        return new DefinitionForIdAndDescriptor(id, descriptor);
    }

    public static NDefinition ofDescriptorOnly(NDescriptor descriptor) {
        return new DefinitionForIdAndDescriptor(descriptor.getId(), descriptor);
    }

    private static class LazyLoadingNDefinition
    extends NDefinitionDelegate {
        NLog LOG = NLog.of(NDefinitionHelper.class);
        NDefinition definition;
        private final NId id;
        boolean loaded;
        RuntimeException replayException;

        public LazyLoadingNDefinition(NId id) {
            this.id = id;
        }

        @Override
        public NId getId() {
            return this.id;
        }

        @Override
        protected NDefinition getBase() {
            if (!this.loaded) {
                if (this.LOG == null) {
                    this.LOG = NLog.of(LazyLoadingNDefinition.class);
                }
                this.loaded = true;
                try {
                    this.definition = NFetchCmd.of(this.id).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
                }
                catch (Exception ex2) {
                    UncheckedException ex2;
                    if (this.LOG.isLoggable(Level.FINER)) {
                        this.LOG.log(NMsg.ofC("unable to fetch descriptor for %s : %s", this.id, ex2).asFinestFail());
                    }
                    if (!(ex2 instanceof RuntimeException)) {
                        ex2 = new UncheckedException(ex2);
                    }
                    this.replayException = ex2;
                }
            }
            if (this.replayException != null) {
                throw this.replayException;
            }
            return this.definition;
        }
    }

    private static class DefinitionForIdAndLazyDescriptor
    extends NDefinitionDelegate {
        private final NId id;
        private final NOnceValue<NDescriptor> descriptor;
        private final String caller;

        public DefinitionForIdAndLazyDescriptor(NId id, Supplier<NDescriptor> descriptor, String caller) {
            this.id = id;
            this.caller = caller;
            this.descriptor = NOnceValue.ofSupplier(descriptor);
        }

        @Override
        public NDescriptor getDescriptor() {
            return this.descriptor.get();
        }

        @Override
        protected NDefinition getBase() {
            throw new IllegalStateException("You are not allowed to load definition");
        }

        @Override
        public NId getId() {
            return this.id;
        }
    }

    private static class DefinitionForIdAndDescriptor
    extends NDefinitionDelegate {
        private final NId id;
        private final NDescriptor descriptor;

        public DefinitionForIdAndDescriptor(NId id, NDescriptor descriptor) {
            this.id = id;
            this.descriptor = descriptor;
        }

        @Override
        protected NDefinition getBase() {
            throw new IllegalStateException("You are not allowed to load definition");
        }

        @Override
        public NId getId() {
            return this.id;
        }

        @Override
        public NDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public NOptional<NDescriptor> getEffectiveDescriptor() {
            return NOptional.of(this.getDescriptor());
        }

        @Override
        public NOptional<Set<NDescriptorFlag>> getEffectiveFlags() {
            return this.getEffectiveDescriptor().map(x -> x.getFlags());
        }
    }

    private static class DefinitionForIdOnly
    extends NDefinitionDelegate {
        private final NId id;
        private final String caller;

        public DefinitionForIdOnly(NId id, String caller) {
            this.id = id;
            this.caller = caller;
        }

        @Override
        protected NDefinition getBase() {
            throw new IllegalStateException("You are not allowed to load definition");
        }

        @Override
        public NId getId() {
            return this.id;
        }
    }
}

