/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.time.Instant;
import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.command.NInstallStatus;
import net.thevpc.nuts.io.NPath;

public class DefaultNInstallInfo
implements NInstallInformation {
    private NId id;
    private NInstallStatus installStatus;
    private boolean wasInstalled;
    private boolean wasRequired;
    private Instant lasModifiedDate;
    private Instant createdDate;
    private String installUser;
    private NPath installFolder;
    private String sourceRepositoryName;
    private String sourceRepositoryUUID;
    private boolean justInstalled;
    private boolean justRequired;

    public DefaultNInstallInfo(NId id, NInstallStatus installStatus, NPath installFolder, Instant createdDate, Instant lasModifiedDate, String installUser, String sourceRepositoryName, String sourceRepositoryUUID, boolean justInstalled, boolean justRequired) {
        this.id = id;
        this.installStatus = installStatus;
        this.installFolder = installFolder;
        this.createdDate = createdDate;
        this.lasModifiedDate = lasModifiedDate;
        this.installUser = installUser;
        this.sourceRepositoryName = sourceRepositoryName;
        this.sourceRepositoryUUID = sourceRepositoryUUID;
        this.justInstalled = justInstalled;
        this.justRequired = justRequired;
    }

    public DefaultNInstallInfo(NInstallInformation other) {
        this.id = other.getId();
        this.installStatus = other.getInstallStatus();
        this.installFolder = other.getInstallFolder();
        this.createdDate = other.getCreatedInstant();
        this.lasModifiedDate = other.getLastModifiedInstant();
        this.installUser = other.getInstallUser();
        this.sourceRepositoryName = other.getSourceRepositoryName();
        this.sourceRepositoryUUID = other.getSourceRepositoryUUID();
        this.justInstalled = other.isJustInstalled();
        this.justRequired = other.isJustRequired();
    }

    public static DefaultNInstallInfo notInstalled(NId id) {
        return new DefaultNInstallInfo(null, NInstallStatus.NONE, null, null, null, null, null, null, false, false);
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public Instant getCreatedInstant() {
        return this.createdDate;
    }

    @Override
    public Instant getLastModifiedInstant() {
        return this.lasModifiedDate;
    }

    @Override
    public boolean isDefaultVersion() {
        return this.getInstallStatus().isDefaultVersion();
    }

    @Override
    public NPath getInstallFolder() {
        return this.installFolder;
    }

    @Override
    public boolean isWasInstalled() {
        return this.wasInstalled;
    }

    public DefaultNInstallInfo setWasInstalled(boolean wasInstalled) {
        this.wasInstalled = wasInstalled;
        return this;
    }

    @Override
    public boolean isWasRequired() {
        return this.wasRequired;
    }

    @Override
    public String getInstallUser() {
        return this.installUser;
    }

    @Override
    public NInstallStatus getInstallStatus() {
        return this.installStatus;
    }

    @Override
    public boolean isInstalledOrRequired() {
        return this.installStatus.isRequired() || this.installStatus.isInstalled();
    }

    @Override
    public String getSourceRepositoryName() {
        return this.sourceRepositoryName;
    }

    @Override
    public String getSourceRepositoryUUID() {
        return this.sourceRepositoryUUID;
    }

    public DefaultNInstallInfo setSourceRepositoryUUID(String sourceRepositoryUUID) {
        this.sourceRepositoryUUID = sourceRepositoryUUID;
        return this;
    }

    public DefaultNInstallInfo setSourceRepositoryName(String sourceRepositoryName) {
        this.sourceRepositoryName = sourceRepositoryName;
        return this;
    }

    public DefaultNInstallInfo setInstallStatus(NInstallStatus installStatus) {
        this.installStatus = installStatus;
        return this;
    }

    public DefaultNInstallInfo setInstallUser(String installUser) {
        this.installUser = installUser;
        return this;
    }

    public DefaultNInstallInfo setWasRequired(boolean wasRequired) {
        this.wasRequired = wasRequired;
        return this;
    }

    public DefaultNInstallInfo setInstallFolder(NPath installFolder) {
        this.installFolder = installFolder;
        return this;
    }

    public DefaultNInstallInfo setCreatedDate(Instant createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public DefaultNInstallInfo setId(NId id) {
        this.id = id;
        return this;
    }

    @Override
    public boolean isJustReInstalled() {
        return this.isWasInstalled() && this.isJustInstalled();
    }

    @Override
    public boolean isJustInstalled() {
        return this.justInstalled;
    }

    @Override
    public boolean isJustReRequired() {
        return this.isWasRequired() && this.isJustRequired();
    }

    @Override
    public boolean isJustRequired() {
        return this.justRequired;
    }

    public DefaultNInstallInfo setLasModifiedDate(Instant lasModifiedDate) {
        this.lasModifiedDate = lasModifiedDate;
        return this;
    }

    public DefaultNInstallInfo setJustInstalled(boolean justInstalled) {
        this.justInstalled = justInstalled;
        return this;
    }

    public DefaultNInstallInfo setJustRequired(boolean justRequired) {
        this.justRequired = justRequired;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNInstallInfo that = (DefaultNInstallInfo)o;
        return this.wasInstalled == that.wasInstalled && this.wasRequired == that.wasRequired && this.justInstalled == that.justInstalled && this.justRequired == that.justRequired && Objects.equals(this.id, that.id) && Objects.equals(this.installStatus, that.installStatus) && Objects.equals(this.lasModifiedDate, that.lasModifiedDate) && Objects.equals(this.createdDate, that.createdDate) && Objects.equals(this.installUser, that.installUser) && Objects.equals(this.installFolder, that.installFolder) && Objects.equals(this.sourceRepositoryName, that.sourceRepositoryName) && Objects.equals(this.sourceRepositoryUUID, that.sourceRepositoryUUID);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.installStatus, this.wasInstalled, this.wasRequired, this.lasModifiedDate, this.createdDate, this.installUser, this.installFolder, this.sourceRepositoryName, this.sourceRepositoryUUID, this.justInstalled, this.justRequired);
    }
}

