/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.concurrent.NOnceValue;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinitionBuilder;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NImmutable;
import net.thevpc.nuts.util.NOptional;

public class DefaultNDefinitionWithSuppliers
implements NDefinition,
NImmutable {
    final NOnceValue<NId> id;
    final NOnceValue<String> repositoryUuid;
    final NOnceValue<String> repositoryName;
    final NOnceValue<NId> apiId;
    final NOnceValue<NDependency> dependency;
    final NOnceValue<NDescriptor> descriptor;
    final NOnceValue<NPath> content;
    final NOnceValue<NInstallInformation> installInformation;
    final NOnceValue<NDependencies> dependencies;
    final NOnceValue<NDescriptor> effectiveDescriptor;
    final NOnceValue<Set<NDescriptorFlag>> effectiveFlags;

    public DefaultNDefinitionWithSuppliers(Supplier<String> repoUuid, Supplier<String> repoName, Supplier<NId> id, Supplier<NDescriptor> descriptor, Supplier<NPath> content, Supplier<NInstallInformation> install, Supplier<NId> apiId, Supplier<NDescriptor> effectiveDescriptor, Supplier<NDependencies> dependencies, Supplier<NDependency> dependency, Supplier<Set<NDescriptorFlag>> effectiveFlags) {
        this.id = NOnceValue.ofSupplier(id);
        this.descriptor = NOnceValue.ofSupplier(descriptor);
        this.content = NOnceValue.ofSupplier(content);
        this.installInformation = NOnceValue.ofSupplier(install);
        this.repositoryUuid = NOnceValue.ofSupplier(repoUuid);
        this.repositoryName = NOnceValue.ofSupplier(repoName);
        this.apiId = NOnceValue.ofSupplier(apiId);
        this.effectiveDescriptor = NOnceValue.ofSupplier(effectiveDescriptor);
        this.dependencies = NOnceValue.ofSupplier(dependencies);
        this.dependency = NOnceValue.ofSupplier(dependency);
        this.effectiveFlags = NOnceValue.ofSupplier(effectiveFlags);
    }

    @Override
    public NDependency getDependency() {
        return this.dependency.get();
    }

    @Override
    public String getRepositoryUuid() {
        return this.repositoryUuid.get();
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName.get();
    }

    @Override
    public NDefinitionBuilder builder() {
        return new DefaultNDefinitionBuilder(this);
    }

    @Override
    public NId getId() {
        return this.id.get();
    }

    public boolean isTemporary() {
        NPath c = this.content.get();
        return c != null && c.isUserTemporary();
    }

    @Override
    public NDescriptor getDescriptor() {
        return this.descriptor.get();
    }

    public String toString() {
        return "Definition{ id=" + this.id + ", content=" + this.content + '}';
    }

    @Override
    public NOptional<NPath> getContent() {
        return NOptional.of(this.content.get(), () -> NMsg.ofC("content not found for id %s", this.getId()));
    }

    @Override
    public NOptional<NDescriptor> getEffectiveDescriptor() {
        return NOptional.of(this.effectiveDescriptor.get(), () -> NMsg.ofC("unable to get effectiveDescriptor for id %s. You need to call search.setEffective(...) first.", this.getId()));
    }

    @Override
    public NOptional<NInstallInformation> getInstallInformation() {
        return NOptional.of(this.installInformation.get(), () -> NMsg.ofC("unable to get install information for id %s.", this.getId()));
    }

    @Override
    public NOptional<NDependencies> getDependencies() {
        return NOptional.of(this.dependencies.get(), () -> NMsg.ofC("unable to get dependencies for id %s. You need to call search.setDependencies(...) first.", this.getId()));
    }

    @Override
    public NOptional<Set<NDescriptorFlag>> getEffectiveFlags() {
        return NOptional.of(this.effectiveFlags.get(), () -> NMsg.ofC("unable to get effectiveFlags for id %s.", this.getId()));
    }

    @Override
    public int compareTo(NDefinition n2) {
        if (n2 == null) {
            return 1;
        }
        if (!(n2 instanceof DefaultNDefinitionWithSuppliers)) {
            return -1;
        }
        NId o1 = this.getId();
        NId o2 = n2.getId();
        if (o1 == null || o2 == null) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            return 1;
        }
        return o1.compareTo(o2);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultNDefinitionWithSuppliers other = (DefaultNDefinitionWithSuppliers)obj;
        return Objects.equals(this.id, other.id);
    }

    @Override
    public NId getApiId() {
        return this.apiId.get();
    }
}

