/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.definition;

import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionBuilder;
import net.thevpc.nuts.artifact.NDependencies;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NInstallInformation;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.definition.DefaultNDefinition;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;

public class DefaultNDefinitionBuilder
implements NDefinitionBuilder {
    private NId id;
    private NDescriptor descriptor;
    private String repositoryUuid;
    private String repositoryName;
    private NPath content;
    private NInstallInformation installInformation;
    private NDependencies dependencies;
    private NDescriptor effectiveDescriptor;
    private NDependency dependency;
    private NId apiId = null;
    private Set<NDescriptorFlag> effectiveFlags;

    public DefaultNDefinitionBuilder() {
    }

    public DefaultNDefinitionBuilder(String repoUuid, String repoName, NId id, NDescriptor descriptor, NPath content, NInstallInformation install, NId apiId, NDependency dependency, Set<NDescriptorFlag> effectiveFlags) {
        this.descriptor = descriptor;
        this.content = content;
        this.id = id;
        if (!id.isLongId()) {
            throw new NIllegalArgumentException(NMsg.ofC("id should not have query defined in descriptors : %s", id));
        }
        this.installInformation = install;
        this.repositoryUuid = repoUuid;
        this.repositoryName = repoName;
        this.apiId = apiId;
        this.dependency = dependency;
        this.effectiveFlags = effectiveFlags;
    }

    public DefaultNDefinitionBuilder(NDefinition other) {
        if (other != null) {
            this.descriptor = other.getDescriptor();
            this.id = other.getId();
            this.repositoryUuid = other.getRepositoryUuid();
            this.repositoryName = other.getRepositoryName();
            this.content = other.getContent().orNull();
            this.installInformation = other.getInstallInformation().orNull();
            this.effectiveDescriptor = other.getEffectiveDescriptor().orNull();
            this.dependencies = other.getDependencies().orNull();
            this.apiId = other.getApiId();
            this.dependency = other.getDependency();
            this.effectiveFlags = other.getEffectiveFlags().orNull();
        }
    }

    public DefaultNDefinitionBuilder(DefaultNDefinitionBuilder other) {
        if (other != null) {
            this.descriptor = other.getDescriptor();
            this.id = other.getId();
            this.repositoryUuid = other.getRepositoryUuid();
            this.repositoryName = other.getRepositoryName();
            this.content = other.getContent().orNull();
            this.installInformation = other.getInstallInformation().orNull();
            this.effectiveDescriptor = other.getEffectiveDescriptor().orNull();
            this.dependencies = other.getDependencies().orNull();
            this.apiId = other.getApiId();
            this.dependency = other.getDependency();
            this.effectiveFlags = other.getEffectiveFlags().orNull();
        }
    }

    @Override
    public NDependency getDependency() {
        return this.dependency;
    }

    @Override
    public NDefinitionBuilder setDependency(NDependency dependency) {
        this.dependency = dependency;
        return this;
    }

    @Override
    public NDefinition build() {
        return new DefaultNDefinition(this.repositoryUuid, this.repositoryName, this.id, this.descriptor, this.content, this.installInformation, this.apiId, this.effectiveDescriptor, this.dependencies, this.dependency != null ? this.dependency : (this.id != null ? this.id.toDependency() : null), this.effectiveFlags);
    }

    @Override
    public String getRepositoryUuid() {
        return this.repositoryUuid;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public NDefinitionBuilder setId(NId id) {
        this.id = id;
        return this;
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public boolean isTemporary() {
        return this.content != null && this.content.isUserTemporary();
    }

    @Override
    public NDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "Definition{ id=" + this.id + ", content=" + this.content + '}';
    }

    @Override
    public NDefinitionBuilder copy() {
        return new DefaultNDefinitionBuilder(this);
    }

    @Override
    public NOptional<NPath> getContent() {
        return NOptional.of(this.content, () -> NMsg.ofC("content not found for id %s", this.getId()));
    }

    @Override
    public NOptional<NDescriptor> getEffectiveDescriptor() {
        return NOptional.of(this.effectiveDescriptor, () -> NMsg.ofC("unable to get effectiveDescriptor for id %s. You need to call search.setEffective(...) first.", this.getId()));
    }

    @Override
    public NOptional<NInstallInformation> getInstallInformation() {
        return NOptional.of(this.installInformation, () -> NMsg.ofC("unable to get install information for id %s.", this.getId()));
    }

    @Override
    public NOptional<NDependencies> getDependencies() {
        return NOptional.of(this.dependencies, () -> NMsg.ofC("unable to get dependencies for id %s. You need to call search.setDependencies(...) first.", this.getId()));
    }

    @Override
    public NDefinitionBuilder setContent(NPath content) {
        this.content = content;
        return this;
    }

    @Override
    public NDefinitionBuilder setDescriptor(NDescriptor descriptor) {
        this.descriptor = descriptor;
        return this;
    }

    @Override
    public int compareTo(NDefinitionBuilder n2) {
        if (n2 == null) {
            return 1;
        }
        if (!(n2 instanceof NDefinitionBuilder)) {
            return -1;
        }
        NId o1 = this.getId();
        NId o2 = n2.getId();
        if (o1 == null || o2 == null) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            return 1;
        }
        return o1.compareTo(o2);
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionBuilder other = (NDefinitionBuilder)obj;
        return Objects.equals(this.id, other.getId());
    }

    @Override
    public NDefinitionBuilder setEffectiveDescriptor(NDescriptor effectiveDescriptor) {
        this.effectiveDescriptor = effectiveDescriptor;
        return this;
    }

    @Override
    public NDefinitionBuilder setInstallInformation(NInstallInformation install) {
        this.installInformation = install;
        return this;
    }

    @Override
    public NDefinitionBuilder setDependencies(NDependencies dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    @Override
    public NDefinitionBuilder setApiId(NId apiId) {
        this.apiId = apiId;
        return this;
    }

    @Override
    public NId getApiId() {
        return this.apiId;
    }

    @Override
    public NDefinitionBuilder setRepositoryUuid(String repositoryUuid) {
        this.repositoryUuid = repositoryUuid;
        return this;
    }

    @Override
    public NDefinitionBuilder setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    @Override
    public NDefinitionBuilder setEffectiveFlags(Set<NDescriptorFlag> effectiveFlags) {
        this.effectiveFlags = effectiveFlags;
        return this;
    }

    @Override
    public NOptional<Set<NDescriptorFlag>> getEffectiveFlags() {
        return NOptional.of(this.effectiveFlags, () -> NMsg.ofC("unable to get effectiveFlags for id %s.", this.getId()));
    }
}

