/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NWorkBalancerModel;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyContext;
import net.thevpc.nuts.concurrent.NWorkBalancerWorker;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerLoad;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerWorkerImpl;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;

public class WorkBalancerStrategyContextImpl
implements NWorkBalancerStrategyContext {
    private final NWorkBalancerModel model;
    private final NWorkBalancerImpl<?> workBalancer;

    public WorkBalancerStrategyContextImpl(NWorkBalancerModel model, NWorkBalancerImpl<?> workBalancer) {
        this.model = NAssert.requireNonNull(model);
        this.workBalancer = workBalancer;
    }

    @Override
    public List<NWorkBalancerWorker> getWorkers() {
        if (this.model.getWorkers() == null) {
            return Collections.emptyList();
        }
        return this.model.getWorkers().stream().map(NWorkBalancerWorkerImpl::new).collect(Collectors.toList());
    }

    @Override
    public NOptional<NWorkBalancerWorkerLoad> getWorkerLoad(String workerName) {
        return this.workBalancer.getWorkerLoad(workerName);
    }

    @Override
    public Map<String, NWorkBalancerWorkerLoad> getWorkerLoads() {
        return this.workBalancer.getWorkerLoads();
    }

    @Override
    public NOptional<NElement> getOption(String name) {
        return this.workBalancer.getOption(name);
    }

    @Override
    public Map<String, NElement> getOptions() {
        return this.workBalancer.getOptions();
    }

    @Override
    public NOptional<NElement> getWorkerVar(String workerName, String name) {
        Map<String, Map<String, NElement>> v = this.model.getContext().getVariables();
        Map<String, NElement> workerVars = v.get(workerName);
        return NOptional.ofNamed(workerVars == null ? null : workerVars.get(name), name);
    }

    @Override
    public NOptional<NElement> getVar(String name) {
        if (this.model.getContext() != null && this.model.getContext().getVariables() != null) {
            Map globalVars = this.model.getContext().getVariables().getOrDefault("", Collections.emptyMap());
            return NOptional.ofNullable((NElement)globalVars.get(name));
        }
        return NOptional.ofEmpty();
    }

    @Override
    public NWorkBalancerStrategyContext setWorkerVar(String workerName, String name, NElement value) {
        this.model.getContext().getVariables().computeIfAbsent(workerName, k -> new HashMap()).put(name, value);
        return this;
    }

    @Override
    public NWorkBalancerStrategyContext setVar(String name, NElement value) {
        this.model.getContext().getVariables().computeIfAbsent("", k -> new HashMap()).put(name, value);
        return this;
    }
}

