/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.concurrent.NWorkBalancerHostLoadMetricProvider;
import net.thevpc.nuts.concurrent.NWorkBalancerHostLoadMetrics;
import net.thevpc.nuts.concurrent.NWorkBalancerRunningJob;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerLoad;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerModel;
import net.thevpc.nuts.time.NDuration;

class NWorkBalancerWorkerLoadImpl
implements NWorkBalancerWorkerLoad {
    final NWorkBalancerWorkerModel worker;
    final int workerIndex;
    public AtomicLong activeJobsCount = new AtomicLong(0L);
    public AtomicLong totalJobsCount = new AtomicLong(0L);
    public AtomicLong succeededJobCount = new AtomicLong(0L);
    public AtomicLong failedJobsCount = new AtomicLong(0L);
    public AtomicLong completedJobsTotalDurationNano = new AtomicLong(0L);
    private NCachedValue<NWorkBalancerHostLoadMetrics> loadMetricsNCachedValue;
    public final List<NWorkBalancerRunningJob> runningJobs = Collections.synchronizedList(new ArrayList());

    public NWorkBalancerWorkerLoadImpl(NWorkBalancerWorkerModel worker, int workerIndex) {
        this.worker = worker;
        this.workerIndex = workerIndex;
        this.loadMetricsNCachedValue = NCachedValue.of(() -> {
            NWorkBalancerHostLoadMetrics z;
            NWorkBalancerHostLoadMetricProvider p = worker.getHostLoadMetricsProvider();
            if (p != null && (z = p.resolveDefaultMetrics()) != null) {
                return z.copy();
            }
            return new NWorkBalancerHostLoadMetrics();
        });
    }

    public int getWorkerIndex() {
        return this.workerIndex;
    }

    @Override
    public NCachedValue<NWorkBalancerHostLoadMetrics> hostLoadMetrics() {
        return this.loadMetricsNCachedValue;
    }

    @Override
    public long activeJobsCount() {
        return this.activeJobsCount.get();
    }

    @Override
    public long totalJobsCount() {
        return this.totalJobsCount.get();
    }

    @Override
    public long succeededJobCount() {
        return this.succeededJobCount.get();
    }

    @Override
    public long failedJobsCount() {
        return this.failedJobsCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long activeJobsTotalDurationNano() {
        long now = System.nanoTime();
        long total = 0L;
        List<NWorkBalancerRunningJob> list = this.runningJobs;
        synchronized (list) {
            for (NWorkBalancerRunningJob job : this.runningJobs) {
                long start = job.getStartTimeNano();
                long end = job.isRunning() ? now : job.getEndTimeNano();
                total += end - start;
            }
        }
        return total;
    }

    @Override
    public long completedJobsTotalDurationNano() {
        return this.completedJobsTotalDurationNano.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        NWorkBalancerHostLoadMetrics metrics;
        long activeDuration;
        long totalDuration;
        long fCount;
        long sCount;
        long tCount;
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("worker:").append(this.worker.getName() != null ? this.worker.getName() : "\"null\"");
        long aCount = this.activeJobsCount.get();
        if (aCount > 0L) {
            sb.append(",activeJobsCount:").append(aCount);
        }
        if ((tCount = this.totalJobsCount.get()) > 0L) {
            sb.append(",totalJobsCount:").append(tCount);
        }
        if ((sCount = this.succeededJobCount.get()) > 0L) {
            sb.append(",succeededJobCount:").append(sCount);
        }
        if ((fCount = this.failedJobsCount.get()) > 0L) {
            sb.append(",failedJobsCount:").append(fCount);
        }
        if ((totalDuration = this.completedJobsTotalDurationNano.get()) > 0L) {
            sb.append(",completedJobsTotalDuration:").append(NDuration.ofNanos(totalDuration));
        }
        if ((activeDuration = this.activeJobsTotalDurationNano()) > 0L) {
            sb.append(",activeJobsTotalDuration:").append(NDuration.ofNanos(activeDuration));
        }
        if ((metrics = this.hostLoadMetrics().get()) != null) {
            sb.append(",hostLoadMetrics:").append(metrics.toString());
        }
        List<NWorkBalancerRunningJob> list = this.runningJobs;
        synchronized (list) {
            if (!this.runningJobs.isEmpty()) {
                sb.append(",runningJobs:[");
                boolean first = true;
                for (NWorkBalancerRunningJob job : this.runningJobs) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append("{jobId:").append(job.getJobId()).append(",jobName:").append(job.getJobName()).append(",workerName:").append(job.getWorkerName()).append(",duration:").append(job.getDuration()).append(",running:").append(job.isRunning()).append("}");
                    first = false;
                }
                sb.append("]");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

