/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.concurrent.NWorkBalancerJobContext;
import net.thevpc.nuts.concurrent.NWorkBalancerModel;
import net.thevpc.nuts.concurrent.NWorkBalancerWorker;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerWorkerImpl;
import net.thevpc.nuts.util.NOptional;

class NWorkBalancerJobContextImpl
implements NWorkBalancerJobContext {
    private final NWorkBalancerModel model;
    private final NWorkBalancerWorkerImpl worker;
    private final String jobName;
    private final String jobId;
    private final int workerIndex;

    public NWorkBalancerJobContextImpl(String jobId, String jobName, NWorkBalancerWorkerImpl worker, int workerIndex, NWorkBalancerModel model) {
        this.worker = worker;
        this.model = model;
        this.jobName = jobName;
        this.jobId = jobId;
        this.workerIndex = workerIndex;
    }

    @Override
    public int getWorkerIndex() {
        return this.workerIndex;
    }

    @Override
    public int getWorkersCount() {
        return this.model.getWorkers().size();
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getWorkerName() {
        return this.worker.getName();
    }

    @Override
    public NWorkBalancerWorker getWorker() {
        return this.worker;
    }

    @Override
    public Map<String, NElement> getOptions() {
        if (this.model.getOptions() == null) {
            return new HashMap<String, NElement>();
        }
        return Collections.unmodifiableMap(this.model.getOptions());
    }

    @Override
    public NOptional<NElement> getOption(String name) {
        if (this.model.getOptions() == null) {
            return NOptional.ofNamedEmpty(name);
        }
        return NOptional.ofNamed(this.model.getOptions().get(name), name);
    }
}

