/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.concurrent.NWorkBalancerBuilder;
import net.thevpc.nuts.concurrent.NWorkBalancerDefaultStrategy;
import net.thevpc.nuts.concurrent.NWorkBalancerFactory;
import net.thevpc.nuts.concurrent.NWorkBalancerStore;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategy;
import net.thevpc.nuts.runtime.standalone.concurrent.LeastLoad;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerBuilderImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.PowerOfTwoLoad;
import net.thevpc.nuts.runtime.standalone.concurrent.RoundRobin;

public class NWorkBalancerFactoryImpl
implements NWorkBalancerFactory {
    private NWorkBalancerStore store;
    private Map<String, NWorkBalancerStrategy> strategies = new HashMap<String, NWorkBalancerStrategy>();

    public NWorkBalancerFactoryImpl(NWorkBalancerStore store, Map<String, NWorkBalancerStrategy> strategies) {
        this.store = store;
        if (strategies != null) {
            for (Map.Entry<String, NWorkBalancerStrategy> e : strategies.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                strategies.put(e.getKey(), e.getValue());
            }
            this.strategies.putAll(strategies);
        }
    }

    @Override
    public NWorkBalancerFactory withStore(NWorkBalancerStore store) {
        if (store == this.store) {
            return this;
        }
        return new NWorkBalancerFactoryImpl(store, this.strategies);
    }

    @Override
    public NWorkBalancerStore getStore() {
        return this.store;
    }

    public NWorkBalancerStrategy createStrategy(String strategyId) {
        NWorkBalancerStrategy d = this.strategies.get(strategyId);
        if (d != null) {
            return d;
        }
        switch (NWorkBalancerDefaultStrategy.parse(strategyId).orElse(NWorkBalancerDefaultStrategy.ROUND_ROBIN)) {
            case ROUND_ROBIN: {
                return new RoundRobin();
            }
            case LEAST_LOAD: {
                return new LeastLoad();
            }
            case POWER_OF_TWO_CHOICES: {
                return new PowerOfTwoLoad();
            }
        }
        return new RoundRobin();
    }

    @Override
    public NWorkBalancerFactory defineStrategy(String name, NWorkBalancerStrategy definition) {
        HashMap<String, NWorkBalancerStrategy> strategies2 = new HashMap<String, NWorkBalancerStrategy>(this.strategies);
        if (definition == null) {
            strategies2.remove(name);
        } else {
            strategies2.put(name, definition);
        }
        return new NWorkBalancerFactoryImpl(this.store, strategies2);
    }

    @Override
    public <T> NWorkBalancerBuilder<T> ofBuilder(String id) {
        return new NWorkBalancerBuilderImpl(id, this);
    }
}

