/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.concurrent.NTaskResult;
import net.thevpc.nuts.concurrent.NTaskSet;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class NTaskSetImpl
implements NTaskSet {
    private final List<IdAndFuture> futures = new CopyOnWriteArrayList<IdAndFuture>();
    private ExecutorService executor;

    @Override
    public NTaskSet executorService(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public NTaskSet add(Future<?> future) {
        return this.add(null, future);
    }

    @Override
    public NTaskSet add(String taskId, Future<?> future) {
        if (future == null) {
            return this;
        }
        if (future instanceof CompletableFuture) {
            return this.add(taskId, (CompletableFuture)future);
        }
        return this.add(taskId, CompletableFuture.supplyAsync(() -> {
            try {
                return future.get();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, this.pickExecutor(this.executor)));
    }

    @Override
    public NTaskSet add(CompletableFuture<?> future) {
        return this.add((String)null, future);
    }

    @Override
    public NTaskSet add(String taskId, CompletableFuture<?> future) {
        if (future == null) {
            return this;
        }
        this.futures.add(new IdAndFuture(taskId, future));
        return this;
    }

    @Override
    public NTaskSet supply(Supplier<?> supplier) {
        return this.supply(null, supplier, this.executor);
    }

    @Override
    public NTaskSet supply(String taskId, Supplier<?> supplier) {
        return this.supply(taskId, supplier, this.executor);
    }

    @Override
    public NTaskSet supply(Supplier<?> supplier, ExecutorService exec) {
        return this.supply(null, supplier, exec);
    }

    @Override
    public NTaskSet supply(String taskId, Supplier<?> supplier, ExecutorService executor) {
        CompletableFuture<?> f = CompletableFuture.supplyAsync(supplier, this.pickExecutor(executor));
        return this.add(taskId, f);
    }

    @Override
    public NTaskSet run(Runnable task) {
        return this.run(null, task, this.executor);
    }

    @Override
    public NTaskSet run(String taskId, Runnable task) {
        return this.run(taskId, task, this.executor);
    }

    @Override
    public NTaskSet run(Runnable task, ExecutorService exec) {
        return this.run(null, task, exec);
    }

    @Override
    public NTaskSet run(String taskId, Runnable task, ExecutorService executor) {
        if (task == null) {
            return this;
        }
        CompletableFuture<Void> f = CompletableFuture.runAsync(task, this.pickExecutor(executor));
        return this.add(taskId, f);
    }

    @Override
    public NTaskSet call(Callable<?> task) {
        return this.call(null, task, this.executor);
    }

    @Override
    public NTaskSet call(String taskId, Callable<?> task) {
        return this.call(taskId, task, this.executor);
    }

    @Override
    public NTaskSet call(Callable<?> task, ExecutorService exec) {
        return this.call(null, task, exec);
    }

    @Override
    public NTaskSet call(String taskId, Callable<?> task, ExecutorService exec) {
        if (task == null) {
            return this;
        }
        CompletableFuture<Object> f = CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception ex) {
                throw new CompletionException(ex);
            }
        }, this.pickExecutor(exec));
        return this.add(taskId, f);
    }

    @Override
    public NTaskSet call(NCallable<?> task) {
        return this.call(task, this.executor);
    }

    @Override
    public NTaskSet call(NCallable<?> task, ExecutorService exec) {
        if (task == null) {
            return this;
        }
        return this.call(task::call, exec);
    }

    @Override
    public NTaskSet join() {
        CompletableFuture.allOf((CompletableFuture[])this.futures.stream().map(x -> x.future).toArray(CompletableFuture[]::new)).join();
        return this;
    }

    @Override
    public <T> T first() {
        return this.first(false);
    }

    @Override
    public <T> T first(boolean cancelOthers) {
        CompletableFuture<Object> any = CompletableFuture.anyOf((CompletableFuture[])this.futures.stream().map(x -> x.future).toArray(CompletableFuture[]::new));
        Object result = any.join();
        if (cancelOthers) {
            this.cancelAll(true);
        }
        return (T)result;
    }

    @Override
    public <T> T firstOnly() {
        return this.first(true);
    }

    @Override
    public <T> List<CompletableFuture<T>> futures(Class<T> type) {
        return this.futures.stream().map(f -> f.future).collect(Collectors.toList());
    }

    @Override
    public List<CompletableFuture<?>> futures() {
        return this.futures.stream().map(f -> f.future).collect(Collectors.toList());
    }

    @Override
    public <T> List<NTaskResult<T>> results() {
        return this.futures.stream().map(f -> f.get()).collect(Collectors.toList());
    }

    @Override
    public <T> List<NTaskResult<T>> results(Class<T> type) {
        return this.futures.stream().map(f -> f.get()).collect(Collectors.toList());
    }

    @Override
    public List<Throwable> errors() {
        return this.results().stream().filter(x -> x.isError()).map(x -> x.getError()).collect(Collectors.toList());
    }

    @Override
    public boolean isDone() {
        return this.futures.stream().allMatch(x -> x.future.isDone());
    }

    @Override
    public boolean hasError() {
        return !this.errors().isEmpty();
    }

    @Override
    public NTaskSet cancelAll(boolean mayInterrupt) {
        this.futures.forEach(f -> f.future.cancel(mayInterrupt));
        return this;
    }

    private ExecutorService pickExecutor(ExecutorService exec) {
        if (exec != null) {
            return exec;
        }
        if (this.executor != null) {
            return this.executor;
        }
        return NConcurrent.of().executorService();
    }

    @Override
    public NTaskSet clear() {
        this.futures.clear();
        return this;
    }

    @Override
    public NTaskSet requireAll() {
        this.join();
        List<Throwable> errors = this.errors();
        if (!errors.isEmpty()) {
            Throwable first = errors.get(0);
            if (first instanceof RuntimeException) {
                throw (RuntimeException)first;
            }
            throw new CompletionException(first);
        }
        return this;
    }

    @Override
    public <T> NOptional<NTaskResult<T>> firstMatch(Predicate<NTaskResult<T>> predicate, boolean cancelOthers) {
        Objects.requireNonNull(predicate);
        CompletableFuture resultFuture = new CompletableFuture();
        AtomicInteger remaining = new AtomicInteger(this.futures.size());
        for (IdAndFuture cf : this.futures) {
            CompletableFuture<?> typed = cf.future;
            typed.whenComplete((r, ex) -> {
                if (!resultFuture.isDone()) {
                    NTaskResult<Object> tr = ex == null ? NTaskResult.ofSuccess(cf.id, r) : NTaskResult.ofError(cf.id, ex instanceof CompletionException && ((CompletionException)ex).getCause() != null ? ((CompletionException)ex).getCause() : ex);
                    boolean match = false;
                    try {
                        match = predicate.test(tr);
                    }
                    catch (Exception e) {
                        resultFuture.complete(NTaskResult.ofError(cf.id, e));
                        if (cancelOthers) {
                            this.cancelAll(true);
                        }
                        return;
                    }
                    if (match) {
                        resultFuture.complete(tr);
                        if (cancelOthers) {
                            this.cancelAll(true);
                        }
                        return;
                    }
                    if (remaining.decrementAndGet() == 0) {
                        resultFuture.complete(null);
                    }
                }
            });
        }
        try {
            NTaskResult res = (NTaskResult)resultFuture.get();
            return res == null ? NOptional.ofEmpty() : NOptional.of(res);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return NOptional.ofEmpty();
        }
        catch (ExecutionException e) {
            return NOptional.of(NTaskResult.ofError(null, e.getCause()));
        }
    }

    @Override
    public <T> CompletableFuture<NOptional<NTaskResult<T>>> firstMatchAsync(Predicate<NTaskResult<T>> predicate, boolean cancelOthers) {
        Objects.requireNonNull(predicate);
        CompletableFuture resultFuture = new CompletableFuture();
        AtomicInteger remaining = new AtomicInteger(this.futures.size());
        for (IdAndFuture cf : this.futures) {
            CompletableFuture<?> typed = cf.future;
            typed.whenComplete((r, ex) -> {
                if (!resultFuture.isDone()) {
                    NTaskResult<Object> tr = ex == null ? NTaskResult.ofSuccess(cf.id, r) : NTaskResult.ofError(cf.id, ex);
                    boolean match = false;
                    try {
                        match = predicate.test(tr);
                    }
                    catch (Exception e) {
                        resultFuture.completeExceptionally(e);
                        if (cancelOthers) {
                            this.cancelAll(true);
                        }
                        return;
                    }
                    if (match) {
                        resultFuture.complete(tr);
                        if (cancelOthers) {
                            this.cancelAll(true);
                        }
                        return;
                    }
                    if (remaining.decrementAndGet() == 0) {
                        resultFuture.complete(null);
                    }
                }
            });
        }
        return resultFuture.thenApply(res -> res == null ? NOptional.ofEmpty() : NOptional.of(res));
    }

    private static class IdAndFuture {
        String id;
        CompletableFuture<?> future;

        public IdAndFuture(String id, CompletableFuture<?> future) {
            this.id = NBlankable.isBlank(id) ? UUID.randomUUID().toString() : id;
            this.future = future;
        }

        public <T> NTaskResult<T> get() {
            try {
                return NTaskResult.ofSuccess(this.id, this.future.get());
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    return NTaskResult.ofError(this.id, e.getCause());
                }
                return NTaskResult.ofError(this.id, e);
            }
            catch (Exception e) {
                return NTaskResult.ofError(this.id, e);
            }
        }
    }
}

