/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.function.Consumer;
import java.util.function.Function;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NRateLimitExceededException;
import net.thevpc.nuts.concurrent.NRateLimitValueResult;
import net.thevpc.nuts.text.NMsg;

class NRateLimitValueResultImpl
implements NRateLimitValueResult {
    private boolean success;
    private boolean processed;
    private NMsg errorMessage;
    private Object result;

    public NRateLimitValueResultImpl(boolean success, Object result, NMsg errorMessage) {
        this.success = success;
        this.errorMessage = errorMessage;
        this.result = result;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public NRateLimitValueResult orElseError() {
        if (this.processed) {
            return this;
        }
        if (!this.success) {
            this.processed = true;
            throw new NRateLimitExceededException(this.errorMessage);
        }
        return this;
    }

    @Override
    public NRateLimitValueResult orElseThrow(Function<NMsg, RuntimeException> other) {
        if (this.processed) {
            return this;
        }
        if (!this.success) {
            RuntimeException e;
            this.processed = true;
            if (other != null && (e = other.apply(this.errorMessage)) != null) {
                throw e;
            }
        }
        return this.orElseError();
    }

    @Override
    public NRateLimitValueResult onSuccess(Runnable r) {
        if (this.processed) {
            return this;
        }
        if (this.success) {
            this.processed = true;
            r.run();
        }
        return this;
    }

    @Override
    public <T> NRateLimitValueResult onSuccessCall(NCallable<T> r) {
        if (this.processed) {
            return this;
        }
        if (this.success) {
            this.processed = true;
            this.result = r.call();
        }
        return this;
    }

    @Override
    public NRateLimitValueResult orElse(Consumer<NMsg> r) {
        if (this.processed) {
            return this;
        }
        if (!this.success) {
            this.processed = true;
            r.accept(this.errorMessage);
        }
        return this;
    }

    @Override
    public <T> NRateLimitValueResult orElseCall(Function<NMsg, T> r) {
        if (this.processed) {
            return this;
        }
        if (!this.success) {
            this.processed = true;
            this.result = r.apply(this.errorMessage);
        }
        return this;
    }

    @Override
    public <T> T get() {
        return (T)this.result;
    }
}

