/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.concurrent.NRateLimitRule;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;
import net.thevpc.nuts.concurrent.NRateLimitStrategy;
import net.thevpc.nuts.concurrent.NRateLimitValueBuilder;
import net.thevpc.nuts.concurrent.NRateLimitValueFactory;
import net.thevpc.nuts.concurrent.NRateLimitValueModel;
import net.thevpc.nuts.concurrent.NRateLimitValueStore;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitBucketRule;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitFixedWindowRule;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitLeakyBucketRule;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitSlidingWindowRule;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueBuilderImpl;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NStringUtils;

public class NRateLimitValueFactoryImpl
implements NRateLimitValueFactory {
    private NRateLimitValueStore store;
    private Map<String, NRateLimitStrategy> strategies = new HashMap<String, NRateLimitStrategy>();

    public NRateLimitValueFactoryImpl(NRateLimitValueStore store, Map<String, NRateLimitStrategy> strategies) {
        this.store = store;
        if (strategies != null) {
            for (Map.Entry<String, NRateLimitStrategy> e : strategies.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                strategies.put(e.getKey(), e.getValue());
            }
            this.strategies.putAll(strategies);
        }
    }

    @Override
    public NRateLimitValueFactory withStore(NRateLimitValueStore store) {
        if (store == this.store) {
            return this;
        }
        return new NRateLimitValueFactoryImpl(store, this.strategies);
    }

    @Override
    public NRateLimitValueStore getStore() {
        return this.store;
    }

    public NRateLimitRule createRule(NRateLimitRuleModel model) {
        NRateLimitRule s;
        String strategyId = model.getId();
        NRateLimitStrategy d = this.strategies.get(strategyId);
        if (d != null && (s = d.fromModel(model)) != null) {
            return s;
        }
        switch (NNameFormat.LOWER_KEBAB_CASE.format(NStringUtils.trim(strategyId))) {
            case "bucket": {
                return new NRateLimitBucketRule(model);
            }
            case "sliding-window": {
                return new NRateLimitSlidingWindowRule(model);
            }
            case "lecky-bucket": {
                return new NRateLimitLeakyBucketRule(model);
            }
            case "fixed-window": {
                return new NRateLimitFixedWindowRule(model);
            }
        }
        return new NRateLimitBucketRule(model);
    }

    @Override
    public NRateLimitValueFactory defineStrategy(String name, NRateLimitStrategy definition) {
        HashMap<String, NRateLimitStrategy> strategies2 = new HashMap<String, NRateLimitStrategy>(this.strategies);
        if (definition == null) {
            strategies2.remove(name);
        } else {
            strategies2.put(name, definition);
        }
        return new NRateLimitValueFactoryImpl(this.store, strategies2);
    }

    @Override
    public NRateLimitValueBuilder ofBuilder(String id) {
        return new NRateLimitValueBuilderImpl(id, this);
    }

    public NRateLimitValueModel load(String id) {
        return this.store.load(id);
    }

    public void save(NRateLimitValueModel rateLimitValue) {
        this.store.save(rateLimitValue);
    }
}

