/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Duration;
import java.time.Instant;
import net.thevpc.nuts.concurrent.NRateLimitDefaultStrategy;
import net.thevpc.nuts.concurrent.NRateLimitRule;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;

public class NRateLimitLeakyBucketRule
implements NRateLimitRule {
    private final String id;
    private final Duration duration;
    private final int capacity;
    private final long leakIntervalMillis;
    private double available;
    private Instant lastRefill;

    public NRateLimitLeakyBucketRule(NRateLimitRuleModel model) {
        this.id = model.getId();
        this.capacity = model.getCapacity();
        this.leakIntervalMillis = model.getDuration() / (long)this.capacity;
        this.available = model.getAvailable();
        this.duration = model.getDuration() == 0L ? null : Duration.ofMillis(model.getDuration());
        this.lastRefill = model.getLastRefill() == 0L ? null : Instant.ofEpochMilli(model.getLastRefill());
    }

    @Override
    public synchronized boolean tryConsume(int count) {
        this.refill();
        if (this.available >= (double)count) {
            this.available -= (double)count;
            return true;
        }
        return false;
    }

    @Override
    public long nextAvailableMillis(int count) {
        this.refill();
        if (this.available >= (double)count) {
            return 0L;
        }
        return (long)Math.ceil(((double)count - this.available) * (double)this.leakIntervalMillis);
    }

    private void refill() {
        Instant now = Instant.now();
        long elapsed = Duration.between(this.lastRefill, now).toMillis();
        double newTokens = (double)elapsed / (double)this.leakIntervalMillis;
        this.available = Math.min((double)this.capacity, this.available + newTokens);
        this.lastRefill = now;
    }

    @Override
    public synchronized NRateLimitRuleModel toModel() {
        return new NRateLimitRuleModel(this.id, NRateLimitDefaultStrategy.LEAKY_BUCKET.id(), this.capacity, this.duration == null ? 0L : this.duration.toMillis(), this.available, this.lastRefill == null ? 0L : this.lastRefill.toEpochMilli(), new byte[0]);
    }

    public String toString() {
        return "LeakyBuket{id='" + this.id + '\'' + ", capacity=" + this.capacity + ", duration=" + this.duration + '}';
    }
}

