/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NOnceValue;
import net.thevpc.nuts.concurrent.NOnceValueModel;
import net.thevpc.nuts.concurrent.NOnceValueStore;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.reflect.NBeanContainer;
import net.thevpc.nuts.util.NAssert;

public final class NOnceValueImpl<T>
implements NOnceValue<T> {
    private final NOnceValueStore store;
    private NOnceValueModel model;

    NOnceValueImpl(String id, Supplier<T> supplier, NOnceValueStore store) {
        NAssert.requireNonNull(supplier, "supplier");
        this.store = store;
        this.model = new NOnceValueModel(NAssert.requireNonNull(id, "id"), supplier);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        NOnceValueImpl nOnceValueImpl = this;
        synchronized (nOnceValueImpl) {
            String id = this.model.getId();
            NBeanContainer.scopedStack().runWith(NBeanContainer.current(), () -> {
                NOnceValueModel m = this.store.load(id);
                if (m == null) {
                    m = new NOnceValueModel(id, this.model.getSupplier());
                    this._save(m);
                } else if (this.model.getSupplier() != null) {
                    m.setSupplier(this.model.getSupplier());
                    this.store.save(m);
                }
                this.model = m;
            });
        }
    }

    private void _save(NOnceValueModel model) {
        this.model = model;
        NBeanContainer.scopedStack().runWith(NBeanContainer.current(), () -> this.store.save(model));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Boolean errorState = this.model.getErrorState();
        if (errorState != null) {
            if (errorState.booleanValue()) {
                Throwable e = this.model.getThrowable();
                NOnceValueImpl.sneakyThrow(e);
            }
            return (T)this.model.getValue();
        }
        NOnceValueImpl nOnceValueImpl = this;
        synchronized (nOnceValueImpl) {
            errorState = this.model.getErrorState();
            if (errorState != null) {
                if (errorState.booleanValue()) {
                    Throwable e = this.model.getThrowable();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw (Error)e;
                }
                return (T)this.model.getValue();
            }
            return (T)this.doSet(this.model.getSupplier());
        }
    }

    private T doSet(Supplier<T> supplier) {
        try {
            T value = supplier.get();
            this.model.setValue(value);
            this.model.setThrowable(null);
            this.model.setErrorState(false);
            return value;
        }
        catch (Throwable ex) {
            this.model.setValue(null);
            this.model.setThrowable(ex);
            this.model.setErrorState(false);
            NOnceValueImpl.sneakyThrow(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySupply(Supplier<T> supplier) {
        NOnceValueImpl nOnceValueImpl = this;
        synchronized (nOnceValueImpl) {
            Boolean errorState = this.model.getErrorState();
            if (errorState != null) {
                this.doSet(supplier);
                return true;
            }
        }
        return false;
    }

    @Override
    public T orElseSet(Supplier<T> value) {
        this.trySupply(value);
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T orElse(T value) {
        NOnceValueImpl nOnceValueImpl = this;
        synchronized (nOnceValueImpl) {
            Boolean errorState = this.model.getErrorState();
            if (errorState != null && !errorState.booleanValue()) {
                return value;
            }
            return this.get();
        }
    }

    @Override
    public boolean trySet(T value) {
        return this.trySupply(() -> value);
    }

    @Override
    public boolean isValid() {
        Boolean errorState = this.model.getErrorState();
        if (errorState != null) {
            return errorState == false;
        }
        return false;
    }

    @Override
    public boolean isError() {
        Boolean errorState = this.model.getErrorState();
        if (errorState != null) {
            return errorState;
        }
        return false;
    }

    @Override
    public boolean isEvaluated() {
        Boolean errorState = this.model.getErrorState();
        return errorState != null;
    }

    private static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    @Override
    public NElement describe() {
        Boolean errorState = this.model.getErrorState();
        NUpletElementBuilder u = NElement.ofUpletBuilder("StableValue").add("evaluated", errorState != null);
        if (errorState != null) {
            u.add("success", errorState == false);
            if (errorState.booleanValue()) {
                u.add("error", NElementDescribables.describeResolveOrDestruct(this.model.getValue()));
            } else {
                u.add("value", NElementDescribables.describeResolveOrDestruct(this.model.getThrowable()));
            }
        }
        return u.build();
    }
}

