/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.UUID;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NOnceValue;
import net.thevpc.nuts.concurrent.NOnceValueFactory;
import net.thevpc.nuts.concurrent.NOnceValueModel;
import net.thevpc.nuts.concurrent.NOnceValueStore;
import net.thevpc.nuts.runtime.standalone.concurrent.NOnceValueImpl;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;

public class NOnceValueFactoryImpl
implements NOnceValueFactory {
    private final NOnceValueStore store;

    public NOnceValueFactoryImpl(NOnceValueStore store) {
        this.store = store;
    }

    @Override
    public NOnceValueFactory withStore(NOnceValueStore store) {
        if (store == this.store) {
            return this;
        }
        return new NOnceValueFactoryImpl(store);
    }

    @Override
    public NOnceValueStore getStore() {
        return this.store;
    }

    @Override
    public <T> NOnceValue<T> of(Supplier<T> supplier) {
        return this.of(UUID.randomUUID().toString(), supplier);
    }

    @Override
    public <T> NOnceValue<T> of(String id, Supplier<T> supplier) {
        String nid = NBlankable.isBlank(id) ? UUID.randomUUID().toString() : id;
        return new NOnceValueImpl<T>(nid, NAssert.requireNonNull(supplier, "supplier"), this.store);
    }

    public NOnceValueModel load(String id) {
        return this.store.load(id);
    }

    public void save(NOnceValueModel rateLimitValue) {
        this.store.save(rateLimitValue);
    }
}

