/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NBulkheadCallFactory;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.concurrent.NCachedValueFactory;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NCircuitBreakerCall;
import net.thevpc.nuts.concurrent.NCircuitBreakerCallFactory;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.concurrent.NInterruptedException;
import net.thevpc.nuts.concurrent.NOnceValue;
import net.thevpc.nuts.concurrent.NOnceValueFactory;
import net.thevpc.nuts.concurrent.NRateLimitValueFactory;
import net.thevpc.nuts.concurrent.NRetryCall;
import net.thevpc.nuts.concurrent.NRetryCallFactory;
import net.thevpc.nuts.concurrent.NSagaCallableBuilder;
import net.thevpc.nuts.concurrent.NSagaCallableFactory;
import net.thevpc.nuts.concurrent.NTaskSet;
import net.thevpc.nuts.concurrent.NWorkBalancerFactory;
import net.thevpc.nuts.runtime.standalone.concurrent.NBulkheadCallBackendAsSemaphore;
import net.thevpc.nuts.runtime.standalone.concurrent.NBulkheadCallFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NBulkheadCallStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NCachedValueFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NCachedValueStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NCircuitBreakerCallFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NCircuitBreakerCallStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NOnceValueFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NOnceValueStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NRateLimitValueStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NRetryCallFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NRetryCallStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NSagaCallableFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NSagaStoreMemory;
import net.thevpc.nuts.runtime.standalone.concurrent.NTaskSetImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerFactoryImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerStoreMemory;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class NConcurrentImpl
implements NConcurrent {
    private final NRateLimitValueFactory memoryRateLimitValueFactory = new NRateLimitValueFactoryImpl(new NRateLimitValueStoreMemory(), null);
    private NRateLimitValueFactory rateLimitValueFactory;
    private final NSagaCallableFactory memorySagaFactory = new NSagaCallableFactoryImpl(new NSagaStoreMemory());
    private NSagaCallableFactory sagaFactory;
    private final NCachedValueFactory memoryCachedValueFactory = new NCachedValueFactoryImpl(new NCachedValueStoreMemory());
    private NCachedValueFactory cachedValueFactory;
    private final NOnceValueFactory memoryStableValueFactory = new NOnceValueFactoryImpl(new NOnceValueStoreMemory());
    private NOnceValueFactory stableValueFactory;
    private final NRetryCallFactory memoryRetryValueFactory = new NRetryCallFactoryImpl(new NRetryCallStoreMemory());
    private NRetryCallFactory retryValueFactory;
    private final NCircuitBreakerCallFactory memoryCircuitBreakerCallFactory = new NCircuitBreakerCallFactoryImpl(new NCircuitBreakerCallStoreMemory(), null);
    private NCircuitBreakerCallFactory circuitBreakerCallFactory;
    private final NWorkBalancerFactory memoryWorkBalancerCallFactory = new NWorkBalancerFactoryImpl(new NWorkBalancerStoreMemory(), null);
    private NWorkBalancerFactory workBalancerCallFactory;
    private final NBulkheadCallFactory memoryBulkheadCallFactory = new NBulkheadCallFactoryImpl(new NBulkheadCallBackendAsSemaphore(), new NBulkheadCallStoreMemory());
    private NBulkheadCallFactory bulkheadCallFactory;

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NConcurrent setCachedValueFactory(NCachedValueFactory cachedValueFactory) {
        this.cachedValueFactory = cachedValueFactory;
        return this;
    }

    @Override
    public NCachedValueFactory memoryCachedValueFactory() {
        return this.memoryCachedValueFactory;
    }

    @Override
    public NCachedValueFactory defaultCachedValueFactory() {
        return this.memoryCachedValueFactory();
    }

    @Override
    public NCachedValueFactory cachedValueFactory() {
        return this.cachedValueFactory == null ? this.defaultCachedValueFactory() : this.cachedValueFactory;
    }

    @Override
    public NConcurrent setRetryCallFactory(NRetryCallFactory retryCallFactory) {
        this.retryValueFactory = retryCallFactory;
        return this;
    }

    @Override
    public NRetryCallFactory memoryRetryCallFactory() {
        return this.memoryRetryValueFactory;
    }

    @Override
    public NRetryCallFactory defaultRetryCallFactory() {
        return this.memoryRetryCallFactory();
    }

    @Override
    public NRetryCallFactory retryCallFactory() {
        return this.retryValueFactory == null ? this.defaultRetryCallFactory() : this.retryValueFactory;
    }

    @Override
    public NConcurrent setStableValueFactory(NOnceValueFactory stableValueFactory) {
        this.stableValueFactory = stableValueFactory;
        return this;
    }

    @Override
    public NOnceValueFactory memoryStableValueFactory() {
        return this.memoryStableValueFactory;
    }

    @Override
    public NOnceValueFactory defaultStableValueFactory() {
        return this.memoryStableValueFactory();
    }

    @Override
    public NOnceValueFactory stableValueFactory() {
        return this.stableValueFactory == null ? this.defaultStableValueFactory() : this.stableValueFactory;
    }

    @Override
    public NRateLimitValueFactory defaultRateLimitValueFactory() {
        return this.memoryRateLimitValueFactory;
    }

    @Override
    public NSagaCallableFactory defaultSagaFactory() {
        return this.memorySagaFactory;
    }

    @Override
    public NSagaCallableFactory memorySagaFactory() {
        return this.memorySagaFactory;
    }

    @Override
    public NRateLimitValueFactory memoryRateLimitValueFactory() {
        return this.memoryRateLimitValueFactory;
    }

    @Override
    public NConcurrent setRateLimitValueFactory(NRateLimitValueFactory factory) {
        this.rateLimitValueFactory = factory;
        return this;
    }

    @Override
    public NRateLimitValueFactory rateLimitValueFactory() {
        return this.rateLimitValueFactory == null ? this.defaultRateLimitValueFactory() : this.rateLimitValueFactory;
    }

    @Override
    public NSagaCallableFactory sagaFactory() {
        return this.sagaFactory == null ? this.defaultSagaFactory() : this.sagaFactory;
    }

    @Override
    public <T> NCachedValue<T> cachedValue(Supplier<T> supplier) {
        return this.cachedValueFactory().of(supplier);
    }

    @Override
    public <T> NOnceValue<T> stableValue(Supplier<T> supplier) {
        return this.stableValueFactory().of(supplier);
    }

    @Override
    public <T> NCachedValue<T> cachedValue(String id, Supplier<T> supplier) {
        return this.cachedValueFactory().of(id, supplier);
    }

    @Override
    public <T> NOnceValue<T> stableValue(String id, Supplier<T> supplier) {
        return this.stableValueFactory().of(id, supplier);
    }

    @Override
    public <T> NRetryCall<T> retryCall(String id, NCallable<T> callable) {
        return this.retryCallFactory().of(id, callable);
    }

    @Override
    public <T> NRetryCall<T> retryCall(NCallable<T> callable) {
        return this.retryCallFactory().of(callable);
    }

    @Override
    public <T> NCircuitBreakerCall<T> circuitBreakerCall(NCallable<T> callable) {
        return this.circuitBreakerCallFactory().of(callable);
    }

    @Override
    public <T> NCircuitBreakerCall<T> circuitBreakerCall(String id, NCallable<T> callable) {
        return this.circuitBreakerCallFactory().of(id, callable);
    }

    @Override
    public NConcurrent setCircuitBreakerCallFactory(NCircuitBreakerCallFactory circuitBreakerCallFactory) {
        this.circuitBreakerCallFactory = circuitBreakerCallFactory;
        return this;
    }

    @Override
    public NCircuitBreakerCallFactory memoryCircuitBreakerCallFactory() {
        return this.memoryCircuitBreakerCallFactory;
    }

    @Override
    public NCircuitBreakerCallFactory defaultCircuitBreakerCallFactory() {
        return this.memoryCircuitBreakerCallFactory;
    }

    @Override
    public NCircuitBreakerCallFactory circuitBreakerCallFactory() {
        return this.circuitBreakerCallFactory == null ? this.defaultCircuitBreakerCallFactory() : this.circuitBreakerCallFactory;
    }

    @Override
    public ExecutorService executorService() {
        return NWorkspaceExt.of().getModel().configModel.executorService();
    }

    @Override
    public NSagaCallableBuilder sagaCallBuilder() {
        return this.sagaFactory().ofBuilder();
    }

    @Override
    public NWorkBalancerFactory defaultWorkBalancerFactory() {
        return this.memoryWorkBalancerCallFactory;
    }

    @Override
    public NWorkBalancerFactory memoryWorkBalancerFactory() {
        return this.memoryWorkBalancerCallFactory;
    }

    @Override
    public NWorkBalancerFactory workBalancerFactory() {
        return this.workBalancerCallFactory == null ? this.defaultWorkBalancerFactory() : this.workBalancerCallFactory;
    }

    @Override
    public NConcurrent setWorkBalancerCallFactory(NWorkBalancerFactory workBalancerCallFactory) {
        this.workBalancerCallFactory = workBalancerCallFactory;
        return this;
    }

    @Override
    public NConcurrent sleep(NDuration durationMillis) throws NInterruptedException {
        return this.sleep(durationMillis == null ? 0L : durationMillis.toMillis());
    }

    @Override
    public NConcurrent sleep(Duration durationMillis) throws NInterruptedException {
        return this.sleep(durationMillis == null ? 0L : durationMillis.toMillis());
    }

    @Override
    public NConcurrent sleep(long durationMillis) throws NInterruptedException {
        if (durationMillis > 0L) {
            try {
                Thread.sleep(durationMillis);
            }
            catch (InterruptedException e) {
                throw new NInterruptedException(e);
            }
        }
        return this;
    }

    @Override
    public NTaskSet taskSet() {
        return new NTaskSetImpl();
    }

    @Override
    public IntFunction<NDuration> retryFixedPeriod(NDuration period) {
        return this.retryFixedPeriods(period);
    }

    @Override
    public IntFunction<NDuration> retryFixedPeriods(NDuration ... periods) {
        final ArrayList<NDuration> all = new ArrayList<NDuration>();
        if (periods == null) {
            all.add(NDuration.ofMillis(0L));
        } else {
            for (NDuration period : periods) {
                if (period != null) {
                    all.add(period);
                    continue;
                }
                all.add(NDuration.ofMillis(0L));
            }
        }
        return new IntFunction<NDuration>(){

            @Override
            public NDuration apply(int i) {
                if (i < all.size()) {
                    return (NDuration)all.get(i);
                }
                return (NDuration)all.get(all.size() - 1);
            }
        };
    }

    @Override
    public IntFunction<NDuration> retryMultipliedPeriod(final NDuration base, final double multiplier) {
        if (base == null || base.isZero() || multiplier <= 0.0) {
            return this.retryFixedPeriod(NDuration.ofMillis(0L));
        }
        return new IntFunction<NDuration>(){

            @Override
            public NDuration apply(int i) {
                return base.mul(multiplier * (double)i);
            }
        };
    }

    @Override
    public NBulkheadCallFactory defaultBulkheadCallFactory() {
        return this.memoryBulkheadCallFactory;
    }

    @Override
    public NBulkheadCallFactory memoryBulkheadCallFactory() {
        return this.memoryBulkheadCallFactory;
    }

    @Override
    public NBulkheadCallFactory bulkheadCallFactory() {
        return this.bulkheadCallFactory == null ? this.defaultBulkheadCallFactory() : this.bulkheadCallFactory;
    }

    @Override
    public NConcurrent setBulkheadCallFactory(NBulkheadCallFactory bulkheadCallFactory) {
        this.bulkheadCallFactory = bulkheadCallFactory;
        return this;
    }
}

