/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.function.IntFunction;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NCircuitBreakerCall;
import net.thevpc.nuts.concurrent.NCircuitBreakerCallModel;
import net.thevpc.nuts.concurrent.NCircuitBreakerCallStore;
import net.thevpc.nuts.reflect.NBeanContainer;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NAssert;

public class NCircuitBreakerCallImpl<T>
implements NCircuitBreakerCall<T> {
    private NBeanContainer beanContainer;
    private NCircuitBreakerCallStore store;
    private NCircuitBreakerCallModel model;

    public NCircuitBreakerCallImpl(String id, NCallable<T> callable, NBeanContainer beanContainer, NCircuitBreakerCallStore store) {
        this.beanContainer = beanContainer;
        this.store = store;
        this.model = new NCircuitBreakerCallModel(id);
        this.model.setCaller(callable);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        NCircuitBreakerCallImpl nCircuitBreakerCallImpl = this;
        synchronized (nCircuitBreakerCallImpl) {
            String oldId = this.model.getId();
            NCallable<?> oldCaller = this.model.getCaller();
            NCallable<NCircuitBreakerCallModel> cc = () -> {
                NCircuitBreakerCallModel m = this.store.load(oldId);
                if (m == null) {
                    NAssert.requireNonNull(oldCaller, "caller");
                    m = new NCircuitBreakerCallModel(oldId);
                    m.setCaller(oldCaller);
                    this.store.save(m);
                } else if (oldCaller != null) {
                    m.setCaller(oldCaller);
                    this.store.save(m);
                }
                return m;
            };
            this.model = NBeanContainer.scopedStack().callWith(this.beanContainer, cc);
        }
    }

    @Override
    public NCircuitBreakerCall<T> setFailureThreshold(int failureThreshold) {
        this.model.setFailureThreshold(failureThreshold);
        this.store.save(this.model);
        return this;
    }

    @Override
    public NCircuitBreakerCall<T> setSuccessThreshold(int successThreshold) {
        this.model.setSuccessThreshold(successThreshold);
        this.store.save(this.model);
        return this;
    }

    @Override
    public NCircuitBreakerCall<T> setSuccessRetryPeriod(IntFunction<NDuration> retryPeriod) {
        this.model.setSuccessRetryPeriod(retryPeriod);
        this.store.save(this.model);
        return this;
    }

    @Override
    public NCircuitBreakerCall<T> setFailureRetryPeriod(IntFunction<NDuration> retryPeriod) {
        this.model.setFailureRetryPeriod(retryPeriod);
        this.store.save(this.model);
        return this;
    }

    @Override
    public T callOrElse(NCallable<T> recover) {
        try {
            return this.call();
        }
        catch (Exception ex) {
            if (recover != null) {
                return recover.call();
            }
            return null;
        }
    }

    @Override
    public T call() {
        return this.call(false);
    }

    @Override
    public T callOrLast() {
        return this.call(true);
    }

    public T call(boolean useFallback) {
        NCircuitBreakerCallImpl nCircuitBreakerCallImpl = this;
        synchronized (nCircuitBreakerCallImpl) {
            long now = System.currentTimeMillis();
            switch (this.model.getStatus()) {
                case OPEN: {
                    long openDelay;
                    long l = openDelay = this.model.getFailureRetryPeriod() != null ? this.model.getFailureRetryPeriod().apply(this.model.getFailureCount()).toMillis() : 5000L;
                    if (now - this.model.getOpenTimestamp() >= openDelay) {
                        this.model.setStatus(NCircuitBreakerCall.Status.HALF_OPEN);
                        this.model.setSuccessCount(0);
                        break;
                    }
                    if (useFallback && this.model.getLastValidResult() != null) {
                        return (T)this.model.getLastValidResult();
                    }
                    throw new IllegalStateException("Circuit is OPEN, wait " + (openDelay - (now - this.model.getOpenTimestamp())) + "ms");
                }
                case HALF_OPEN: {
                    long successDelay;
                    long l = successDelay = this.model.getSuccessRetryPeriod() != null ? this.model.getSuccessRetryPeriod().apply(this.model.getSuccessCount()).toMillis() : 0L;
                    if (successDelay <= 0L) break;
                    try {
                        Thread.sleep(successDelay);
                        break;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            }
            try {
                Object result = this.model.getCaller().call();
                this.onSuccess(result);
                return (T)result;
            }
            catch (Exception ex) {
                this.onFailure(ex);
                if (useFallback && this.model.getLastValidResult() != null) {
                    return (T)this.model.getLastValidResult();
                }
                throw ex;
            }
        }
    }

    private void onSuccess(Object result) {
        switch (this.model.getStatus()) {
            case HALF_OPEN: {
                this.model.setSuccessCount(this.model.getSuccessCount() + 1);
                if (this.model.getSuccessCount() < this.model.getSuccessThreshold()) break;
                this.model.setStatus(NCircuitBreakerCall.Status.CLOSED);
                this.model.setFailureCount(0);
                break;
            }
            case CLOSED: {
                this.model.setFailureCount(0);
            }
        }
        this.model.setLastValidResult(result);
    }

    private void onFailure(Throwable ex) {
        this.model.setThrowable(ex);
        switch (this.model.getStatus()) {
            case HALF_OPEN: 
            case CLOSED: {
                this.model.setFailureCount(this.model.getFailureCount() + 1);
                if (this.model.getFailureCount() < this.model.getFailureThreshold()) break;
                this.model.setStatus(NCircuitBreakerCall.Status.OPEN);
                this.model.setOpenTimestamp(System.currentTimeMillis());
                break;
            }
        }
    }
}

