/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.concurrent.NCachedValueModel;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.concurrent.NCachedValueFactoryImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NIllegalStateException;

public final class NCachedValueImpl<T>
implements NCachedValue<T> {
    private final NCachedValueFactoryImpl factory;
    private final Supplier<T> supplier;
    private NCachedValueModel model;

    NCachedValueImpl(String id, Supplier<T> supplier, NCachedValueFactoryImpl factory) {
        this.supplier = NAssert.requireNonNull(supplier);
        this.factory = NAssert.requireNonNull(factory);
        this.model = new NCachedValueModel(NAssert.requireNonNull(id, "id"));
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            NCachedValueModel m = this.factory.load(this.model.getId());
            if (m == null) {
                m = new NCachedValueModel(this.model.getId());
                m.setExpiry(NDuration.ofMillis(Long.MAX_VALUE));
                m.setRetryPeriod(NDuration.ZERO);
                this.factory.save(m);
            }
            this.model = m;
        }
    }

    @Override
    public NCachedValue<T> setExpiryMillis(long expiry) {
        return this.setExpiry(NDuration.ofMillis(expiry));
    }

    @Override
    public NCachedValueImpl<T> setExpiry(NDuration expiry) {
        this.model.setExpiry(NAssert.requireNonNull(expiry));
        this.factory.save(this.model);
        return this;
    }

    @Override
    public NCachedValueImpl<T> setMaxRetries(int maxRetries) {
        if (maxRetries < 0) {
            throw new IllegalArgumentException("maxRetries >= 0");
        }
        this.model.setMaxRetries(maxRetries);
        this.factory.save(this.model);
        return this;
    }

    @Override
    public NCachedValueImpl<T> setRetryPeriod(NDuration retryPeriod) {
        this.model.setRetryPeriod(retryPeriod);
        this.factory.save(this.model);
        return this;
    }

    @Override
    public NCachedValueImpl<T> setRetry(int maxRetries, NDuration retryPeriod) {
        return ((NCachedValueImpl)this.setMaxRetries(maxRetries)).setRetryPeriod(retryPeriod);
    }

    @Override
    public NCachedValueImpl<T> retainLastOnFailure(boolean retain) {
        this.model.setRetainLastOnFailure(retain);
        this.factory.save(this.model);
        return this;
    }

    @Override
    public NCachedValue<T> invalidate() {
        this.model.setErrorState(false);
        this.model.setValue(null);
        this.model.setInvalidated(true);
        this.factory.save(this.model);
        return this;
    }

    @Override
    public boolean isValid() {
        if (this.model.isInvalidated()) {
            return false;
        }
        Boolean lastAttemptError = this.model.getErrorState();
        if (lastAttemptError != null && lastAttemptError.booleanValue()) {
            return false;
        }
        if (this.model.getExpiry() == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        return now - this.model.getLastEvalTimestamp() <= this.model.getExpiry().toMillis();
    }

    @Override
    public boolean isError() {
        Boolean lastAttemptError = this.model.getErrorState();
        return lastAttemptError != null && lastAttemptError != false;
    }

    @Override
    public boolean isEvaluated() {
        Boolean lastAttemptError = this.model.getErrorState();
        return lastAttemptError != null;
    }

    @Override
    public boolean isExpired() {
        if (this.model.isInvalidated()) {
            return true;
        }
        if (this.model.getExpiry() == null) {
            return false;
        }
        return System.currentTimeMillis() - this.model.getLastEvalTimestamp() >= this.model.getExpiry().toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        boolean canRetry;
        long now = System.currentTimeMillis();
        Boolean evb = this.model.getErrorState();
        boolean expired = evb == null || this.model.isInvalidated() || this.model.getExpiry() != null && now - this.model.getLastEvalTimestamp() >= this.model.getExpiry().toMillis();
        long effectiveRetryPeriod = this.model.getRetryPeriod() != null ? this.model.getRetryPeriod().toMillis() : 0L;
        boolean bl = canRetry = evb == null || evb == false || this.model.getFailedAttempts() < this.model.getMaxRetries() && now - this.model.getLastEvalTimestamp() >= effectiveRetryPeriod;
        if (!(expired || evb != null && evb.booleanValue())) {
            return (T)this.model.getValue();
        }
        if (!canRetry) {
            if (this.model.isRetainLastOnFailure() && this.model.getLastValidValue() != null) {
                return (T)this.model.getLastValidValue();
            }
            NCachedValueImpl.throwAsRuntime(this.model.getValue());
        }
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            evb = this.model.getErrorState();
            now = System.currentTimeMillis();
            expired = evb == null || this.model.isInvalidated() || this.model.getExpiry() != null && now - this.model.getLastEvalTimestamp() >= this.model.getExpiry().toMillis();
            boolean bl2 = canRetry = evb == null || evb == false || this.model.getFailedAttempts() < this.model.getMaxRetries() && now - this.model.getLastEvalTimestamp() >= effectiveRetryPeriod;
            if (!expired && evb != null && !evb.booleanValue()) {
                return (T)this.model.getValue();
            }
            if (!canRetry) {
                if (this.model.isRetainLastOnFailure() && this.model.getLastValidValue() != null) {
                    return (T)this.model.getLastValidValue();
                }
                NCachedValueImpl.throwAsRuntime(this.model.getThrowable());
            }
            return this._computeAndSet0(now, this.supplier);
        }
    }

    private T _computeAndSet0(long now, Supplier<T> supplier) {
        this.model.setInvalidated(false);
        try {
            T value = supplier.get();
            this.model.setLastValidValue(value);
            this.model.setLastEvalTimestamp(now);
            this.model.setFailedAttempts(0);
            this.model.setValue(value);
            this.model.setThrowable(null);
            this.model.setErrorState(false);
            this.factory.save(this.model);
            return value;
        }
        catch (Throwable ex) {
            this.model.setFailedAttempts(Math.max(0, this.model.getFailedAttempts() + 1));
            this.model.setLastEvalTimestamp(now);
            this.model.setValue(null);
            this.model.setThrowable(ex);
            this.model.setErrorState(true);
            this.factory.save(this.model);
            if (this.model.isRetainLastOnFailure() && this.model.getLastValidValue() != null) {
                return (T)this.model.getLastValidValue();
            }
            NCachedValueImpl.throwAsRuntime(ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NCachedValue<T> update(Supplier<T> supplier) {
        long now = System.currentTimeMillis();
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            this._computeAndSet0(now, supplier == null ? this.supplier : supplier);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NCachedValue<T> update() {
        long now = System.currentTimeMillis();
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            this._computeAndSet0(now, this.supplier);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NCachedValue<T> setValue(T value) {
        long now = System.currentTimeMillis();
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            this.model.setLastValidValue(value);
            this.model.setLastEvalTimestamp(now);
            this.model.setFailedAttempts(0);
            this.model.setValue(value);
            this.model.setThrowable(null);
            this.model.setErrorState(false);
            this.factory.save(this.model);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean computeAndSetIfInvalid(Supplier<T> supplier) {
        long now = System.currentTimeMillis();
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            if (!this.isValid()) {
                this._computeAndSet0(now, supplier == null ? this.supplier : supplier);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValueIfInvalid(T value) {
        long now = System.currentTimeMillis();
        NCachedValueImpl nCachedValueImpl = this;
        synchronized (nCachedValueImpl) {
            if (!this.isValid()) {
                this.model.setLastValidValue(value);
                this.model.setLastEvalTimestamp(now);
                this.model.setFailedAttempts(0);
                this.model.setValue(value);
                this.model.setThrowable(null);
                this.model.setErrorState(false);
                this.factory.save(this.model);
                return true;
            }
            return false;
        }
    }

    private static void throwAsRuntime(Object ex) {
        if (ex instanceof Throwable) {
            throw NExceptions.ofUncheckedException((Throwable)ex);
        }
        throw new NIllegalStateException(NMsg.ofC("unexpected exception : %s", ex));
    }

    @Override
    public NElement describe() {
        NUpletElementBuilder b = NElement.ofUpletBuilder("CachedValue").add("supplier", NElementDescribables.describeResolveOrDestruct(this.supplier));
        if (this.model.getExpiry() != null) {
            b.add("expiry", NElementDescribables.describeResolveOrDestruct(this.model.getExpiry().toMillis()));
        }
        if (this.model.getRetryPeriod() != null) {
            b.add("retryPeriod", NElementDescribables.describeResolveOrDestruct(this.model.getRetryPeriod().toMillis()));
        }
        b.add("maxRetries", NElementDescribables.describeResolveOrDestruct(this.model.getMaxRetries()));
        Boolean ev = this.model.getErrorState();
        b.add("evaluated", ev != null);
        if (ev != null) {
            b.add("success", ev == false);
            if (!ev.booleanValue()) {
                b.add("value", NElementDescribables.describeResolveOrDestruct(this.model.getValue()));
            } else {
                b.add("error", NElementDescribables.describeResolveOrDestruct(this.model.getThrowable()));
            }
        }
        return b.build();
    }
}

