/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.Objects;
import net.thevpc.nuts.concurrent.NBulkheadCall;
import net.thevpc.nuts.concurrent.NBulkheadCallBackend;
import net.thevpc.nuts.concurrent.NBulkheadCallModel;
import net.thevpc.nuts.concurrent.NBulkheadCallStore;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NConcurrencyLimitException;
import net.thevpc.nuts.concurrent.NInterruptedException;
import net.thevpc.nuts.concurrent.NTimeoutException;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;

public class NBulkheadCallImpl<T>
implements NBulkheadCall<T> {
    private NBulkheadCallModel model;
    private NBulkheadCallBackend backend;
    private NBulkheadCallStore store;

    public NBulkheadCallImpl(String id, NCallable<T> callable, NBulkheadCallStore store, NBulkheadCallBackend backend) {
        this.model = new NBulkheadCallModel(id);
        this.store = store;
        this.backend = backend;
        this.model.setCaller(callable);
        this.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        NBulkheadCallImpl nBulkheadCallImpl = this;
        synchronized (nBulkheadCallImpl) {
            String oldId = this.model.getId();
            NCallable<?> oldCaller = this.model.getCaller();
            NBulkheadCallModel m = this.store.load(oldId);
            if (m == null) {
                NAssert.requireNonNull(oldCaller, "caller");
                m = new NBulkheadCallModel(oldId);
                m.setMaxConcurrent(1);
                m.setCaller(oldCaller);
                this.store.save(m);
            } else if (oldCaller != null) {
                m.setCaller(oldCaller);
                if (m.getMaxConcurrent() <= 0) {
                    m.setMaxConcurrent(1);
                }
                this.store.save(m);
            } else if (m.getMaxConcurrent() <= 0) {
                m.setMaxConcurrent(1);
                this.store.save(m);
            }
            this.model = m;
        }
    }

    @Override
    public NBulkheadCall<T> setMaxConcurrent(int maxConcurrent) {
        maxConcurrent = Math.max(1, maxConcurrent);
        int old = this.model.getMaxConcurrent();
        if (old != maxConcurrent) {
            this.model.setMaxConcurrent(maxConcurrent);
            this.store.save(this.model);
        }
        return this;
    }

    @Override
    public NBulkheadCall<T> setPermitExpiry(NDuration expiry) {
        NDuration old = this.model.getPermitExpiry();
        if (Objects.equals(old, expiry)) {
            this.model.setPermitExpiry(expiry);
            this.store.save(this.model);
        }
        return this;
    }

    @Override
    public int getMaxConcurrent() {
        return this.model.getMaxConcurrent();
    }

    @Override
    public int getActiveCalls() {
        return this.backend.getMetrics(this.model.getId()).getActiveCalls();
    }

    @Override
    public int getAvailableSlots() {
        return this.backend.getMetrics(this.model.getId()).getAvailableSlots();
    }

    @Override
    public boolean isFull() {
        return this.backend.getMetrics(this.model.getId()).isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NOptional<T> tryCall() {
        NOptional<NBulkheadCallBackend.NBulkheadPermit> permitOpt = this.backend.tryAcquire(this.model.getId(), Math.max(1, this.model.getMaxConcurrent()));
        if (permitOpt.isEmpty()) {
            return NOptional.ofEmpty();
        }
        NBulkheadCallBackend.NBulkheadPermit permit = permitOpt.get();
        try {
            Object result = this.model.getCaller().call();
            NOptional<?> nOptional = NOptional.of(result);
            return nOptional;
        }
        finally {
            this.backend.release(permit);
        }
    }

    @Override
    public T tryCallOrElse(NCallable<T> fallback) {
        NOptional<T> result = this.tryCall();
        if (result.isPresent()) {
            return result.get();
        }
        return fallback.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T callBlocking() throws NInterruptedException {
        NOptional<NBulkheadCallBackend.NBulkheadPermit> permitOpt = this.backend.tryAcquire(this.model.getId(), this.model.getMaxConcurrent(), null);
        if (permitOpt.isEmpty()) {
            throw new NInterruptedException(NMsg.ofC("Failed to acquire bulkhead permit"));
        }
        NBulkheadCallBackend.NBulkheadPermit permit = permitOpt.get();
        try {
            Object obj = this.model.getCaller().call();
            return (T)obj;
        }
        finally {
            this.backend.release(permit);
        }
    }

    @Override
    public T call() {
        return this.tryCall().orElseThrow(() -> new NConcurrencyLimitException(NMsg.ofC("Bulkhead is full")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T callBlocking(NDuration timeout) throws NInterruptedException {
        NOptional<NBulkheadCallBackend.NBulkheadPermit> permitOpt = this.backend.tryAcquire(this.model.getId(), this.model.getMaxConcurrent(), timeout);
        if (permitOpt.isEmpty()) {
            throw new NTimeoutException(NMsg.ofC("Timeout waiting for bulkhead permit after %s", timeout));
        }
        NBulkheadCallBackend.NBulkheadPermit permit = permitOpt.get();
        try {
            Object obj = this.model.getCaller().call();
            return (T)obj;
        }
        finally {
            this.backend.release(permit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T callOrElse(NDuration timeout, NCallable<T> fallback) throws NInterruptedException {
        NOptional<NBulkheadCallBackend.NBulkheadPermit> permitOpt = this.backend.tryAcquire(this.model.getId(), this.model.getMaxConcurrent(), timeout);
        if (permitOpt.isEmpty()) {
            return fallback.call();
        }
        NBulkheadCallBackend.NBulkheadPermit permit = permitOpt.get();
        try {
            Object obj = this.model.getCaller().call();
            return (T)obj;
        }
        finally {
            this.backend.release(permit);
        }
    }

    @Override
    public NElement describe() {
        return NElement.ofObjectBuilder().set("type", "NBulkheadCall").set("id", this.model.getId()).set("maxConcurrent", this.model.getMaxConcurrent()).set("backend", this.backend.getClass().getSimpleName()).set("metrics", this.backend.getMetrics(this.model.getId()).describe()).build();
    }
}

