/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategy;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyContext;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyEvent;
import net.thevpc.nuts.concurrent.NWorkBalancerWorker;
import net.thevpc.nuts.concurrent.NWorkBalancerWorkerLoad;

class LeastLoad
implements NWorkBalancerStrategy {
    private final AtomicInteger rrCounter = new AtomicInteger(0);

    LeastLoad() {
    }

    @Override
    public void onStartCall(NWorkBalancerStrategyEvent event) {
    }

    @Override
    public void onEndCall(NWorkBalancerStrategyEvent event) {
    }

    @Override
    public String selectWorker(NWorkBalancerStrategyContext context) {
        List<NWorkBalancerWorker> workers = context.getWorkers();
        if (workers.isEmpty()) {
            throw new IllegalStateException("No workers available");
        }
        double bestLoad = Double.MAX_VALUE;
        ArrayList<NWorkBalancerWorker> bestWorkers = new ArrayList<NWorkBalancerWorker>();
        for (NWorkBalancerWorker w : workers) {
            float weight = w.getWeight();
            if (weight <= 0.0f) continue;
            double load = this.resolveWorkerLoad(w.getName(), context);
            double effectiveLoad = load / (double)weight;
            if (effectiveLoad < bestLoad) {
                bestLoad = effectiveLoad;
                bestWorkers.clear();
                bestWorkers.add(w);
                continue;
            }
            if (Double.compare(effectiveLoad, bestLoad) != 0) continue;
            bestWorkers.add(w);
        }
        if (bestWorkers.isEmpty()) {
            throw new IllegalStateException("No eligible workers found (all weights <= 0?)");
        }
        int idx = Math.floorMod(this.rrCounter.getAndIncrement(), bestWorkers.size());
        return ((NWorkBalancerWorker)bestWorkers.get(idx)).getName();
    }

    private double resolveWorkerLoad(String workerId, NWorkBalancerStrategyContext context) {
        float hostLoad;
        NWorkBalancerWorkerLoad load = context.getWorkerLoad(workerId).orNull();
        if (load != null && !Float.isNaN(hostLoad = load.hostLoadMetrics().get().getHostLoadFactor())) {
            return hostLoad;
        }
        return 0.0;
    }
}

