/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import net.thevpc.nuts.concurrent.NLockAcquireException;
import net.thevpc.nuts.concurrent.NLockBarrierException;
import net.thevpc.nuts.concurrent.NLockReleaseException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.AbstractNLock;
import net.thevpc.nuts.runtime.standalone.util.TimePeriod;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NLiteral;

public class DefaultMemLock
extends AbstractNLock {
    private static TimePeriod FIVE_MINUTES = new TimePeriod(5L, TimeUnit.MINUTES);
    private Object lockedObject;
    private ReentrantLock lock = new ReentrantLock();

    public DefaultMemLock(Object lockedObject) {
        this.lockedObject = lockedObject;
    }

    public TimePeriod getDefaultTimePeriod() {
        return TimePeriod.parse((String)NWorkspace.of().getConfigProperty("nuts.file-lock.timeout").flatMap(NLiteral::asString).get(), TimeUnit.SECONDS).orElse(FIVE_MINUTES);
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        TimePeriod tp = this.getDefaultTimePeriod();
        if (!this.tryLockInterruptibly(tp.getCount(), tp.getUnit())) {
            throw new NLockAcquireException(null, this.lockedObject, this, null);
        }
    }

    @Override
    public synchronized void lock() {
        this.lock.lock();
    }

    public void checkFree() {
        if (!this.isFree()) {
            throw new NLockBarrierException(null, this.lockedObject, this);
        }
    }

    public synchronized boolean isFree() {
        if (this.lock.tryLock()) {
            this.lock.unlock();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void unlock() {
        try {
            this.lock.unlock();
        }
        catch (Exception ex) {
            throw new NLockReleaseException(null, this.lockedObject, this, ex);
        }
    }

    @Override
    public boolean tryLock() {
        return this.tryLockImmediately();
    }

    public boolean tryLock(TimePeriod p) {
        return this.tryLock(p.getCount(), p.getUnit());
    }

    private PollTime preferredPollTime(long time, TimeUnit unit) {
        long timeMs = 0L;
        if (time <= 0L) {
            timeMs = Long.MAX_VALUE;
        } else {
            switch (unit) {
                case NANOSECONDS: {
                    timeMs = time / 1000000L;
                    if (timeMs > 0L) break;
                    timeMs = 1L;
                    break;
                }
                case MICROSECONDS: {
                    timeMs = time / 1000L;
                    if (timeMs > 0L) break;
                    timeMs = 1L;
                    break;
                }
                case MILLISECONDS: {
                    timeMs = time;
                    break;
                }
                case SECONDS: {
                    timeMs = time * 1000L;
                    break;
                }
                case MINUTES: {
                    timeMs = time * 1000L * 60L;
                    break;
                }
                case HOURS: {
                    timeMs = time * 1000L * 3600L;
                    break;
                }
                case DAYS: {
                    timeMs = time * 1000L * 3600L * 24L;
                }
            }
        }
        long minTimeToSleep = timeMs / 10L;
        if (timeMs < 200L) {
            timeMs = 200L;
        }
        return new PollTime(timeMs, minTimeToSleep);
    }

    @Override
    public synchronized boolean tryLock(long time, TimeUnit unit) {
        NAssert.requireNonNull(unit, "unit");
        try {
            this.lock.tryLock(time, unit);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public synchronized boolean tryLockInterruptibly(long time, TimeUnit unit) throws InterruptedException {
        NAssert.requireNonNull(unit, "unit");
        long now = System.currentTimeMillis();
        PollTime ptime = this.preferredPollTime(time, unit);
        while (true) {
            if (this.tryLockImmediatelyInterruptibly()) {
                return true;
            }
            if (System.currentTimeMillis() - now > ptime.timeMs) break;
            NWorkspaceProfilerImpl.sleep(ptime.minTimeToSleep, "DefaultMemLock::tryLockInterruptibly");
        }
        return false;
    }

    public boolean tryLockImmediatelyInterruptibly() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryLockImmediately();
    }

    @Override
    public boolean isLocked() {
        return this.lock.isLocked();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public boolean tryLockImmediately() {
        try {
            this.lock.tryLock();
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }

    @Override
    protected void reunlock() {
        this.lock.unlock();
    }

    @Override
    protected void relock() {
        this.lock.lock();
    }

    @Override
    public NElement describe() {
        NUpletElementBuilder b = NElement.ofUpletBuilder("MemLock");
        return b.build();
    }

    private class PollTime {
        long timeMs;
        long minTimeToSleep;

        public PollTime(long timeMs, long minTimeToSleep) {
            this.timeMs = timeMs;
            this.minTimeToSleep = minTimeToSleep;
        }
    }
}

