/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import net.thevpc.nuts.concurrent.NLockAcquireException;
import net.thevpc.nuts.concurrent.NLockBarrierException;
import net.thevpc.nuts.concurrent.NLockReleaseException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.AbstractNLock;
import net.thevpc.nuts.runtime.standalone.util.TimePeriod;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public class DefaultFileNLock
extends AbstractNLock {
    private static TimePeriod FIVE_MINUTES = new TimePeriod(5L, TimeUnit.MINUTES);
    private Path path;
    private Object lockedObject;
    private Thread ownerThread;

    public DefaultFileNLock(Path path, Object lockedObject) {
        this.path = path;
        this.lockedObject = lockedObject;
    }

    public TimePeriod getDefaultTimePeriod() {
        return TimePeriod.parse((String)NWorkspace.of().getConfigProperty("nuts.file-lock.timeout").flatMap(NLiteral::asString).get(), TimeUnit.SECONDS).orElse(FIVE_MINUTES);
    }

    @Override
    public boolean isLocked() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.isLocked() && Thread.currentThread() == this.ownerThread;
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        TimePeriod tp = this.getDefaultTimePeriod();
        if (!this.tryLockInterruptibly(tp.getCount(), tp.getUnit())) {
            throw new NLockAcquireException(null, this.lockedObject, this, null);
        }
    }

    @Override
    public synchronized void lock() {
        long now = System.currentTimeMillis();
        long maxWaitingTime = 30000L;
        PollTime ptime = this.preferredPollTime(maxWaitingTime, TimeUnit.MILLISECONDS);
        long lastLog = System.currentTimeMillis();
        while (true) {
            long now2;
            if ((now2 = System.currentTimeMillis()) - lastLog > maxWaitingTime) {
                NLog.of(DefaultFileNLock.class).warn(NMsg.ofC("Lock file duration is excessive. waiting for %s for %s", NDuration.ofMillis(now2 - now), this.path));
                lastLog = now2;
            }
            if (this.tryLockImmediately()) {
                return;
            }
            NWorkspaceProfilerImpl.sleep(ptime.minTimeToSleep, "DefaultFileNLock::lock");
        }
    }

    public void checkFree() {
        if (!this.isFree()) {
            throw new NLockBarrierException(null, this.lockedObject, this);
        }
    }

    public synchronized boolean isFree() {
        return !Files.exists(this.path, new LinkOption[0]);
    }

    @Override
    public synchronized void unlock() {
        try {
            Files.delete(this.path);
        }
        catch (IOException ex) {
            throw new NLockReleaseException(null, this.lockedObject, this, ex);
        }
        finally {
            this.ownerThread = null;
        }
    }

    @Override
    public boolean tryLock() {
        return this.tryLockImmediately();
    }

    public boolean tryLock(TimePeriod p) {
        return this.tryLock(p.getCount(), p.getUnit());
    }

    private PollTime preferredPollTime(long time, TimeUnit unit) {
        long timeMs = 0L;
        if (time <= 0L) {
            timeMs = Long.MAX_VALUE;
        } else {
            switch (unit) {
                case NANOSECONDS: {
                    timeMs = time / 1000000L;
                    if (timeMs > 0L) break;
                    timeMs = 1L;
                    break;
                }
                case MICROSECONDS: {
                    timeMs = time / 1000L;
                    if (timeMs > 0L) break;
                    timeMs = 1L;
                    break;
                }
                case MILLISECONDS: {
                    timeMs = time;
                    break;
                }
                case SECONDS: {
                    timeMs = time * 1000L;
                    break;
                }
                case MINUTES: {
                    timeMs = time * 1000L * 60L;
                    break;
                }
                case HOURS: {
                    timeMs = time * 1000L * 3600L;
                    break;
                }
                case DAYS: {
                    timeMs = time * 1000L * 3600L * 24L;
                }
            }
        }
        long minTimeToSleep = timeMs / 10L;
        if (timeMs > 500L) {
            timeMs = 500L;
        } else if (timeMs < 100L) {
            timeMs = 100L;
        }
        return new PollTime(timeMs, minTimeToSleep);
    }

    @Override
    public synchronized boolean tryLock(long time, TimeUnit unit) {
        NAssert.requireNonNull(unit, "unit");
        long now = System.currentTimeMillis();
        PollTime ptime = this.preferredPollTime(time, unit);
        while (true) {
            if (this.tryLockImmediately()) {
                return true;
            }
            if (System.currentTimeMillis() - now > ptime.timeMs) break;
            NWorkspaceProfilerImpl.sleep(ptime.minTimeToSleep, "DefaultFileNLock::tryLock");
        }
        return false;
    }

    public synchronized boolean tryLockInterruptibly(long time, TimeUnit unit) throws InterruptedException {
        NAssert.requireNonNull(unit, "unit");
        long now = System.currentTimeMillis();
        PollTime ptime = this.preferredPollTime(time, unit);
        while (true) {
            if (this.tryLockImmediatelyInterruptibly()) {
                return true;
            }
            if (System.currentTimeMillis() - now > ptime.timeMs) break;
            NWorkspaceProfilerImpl.sleep(ptime.minTimeToSleep, "DefaultFileNLock::tryLockInterruptibly");
        }
        return false;
    }

    public boolean tryLockImmediatelyInterruptibly() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.tryLockImmediately();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLockImmediately() {
        try {
            Class<DefaultFileNLock> clazz = DefaultFileNLock.class;
            synchronized (DefaultFileNLock.class) {
                if (!Files.exists(this.path, new LinkOption[0])) {
                    this.writeLock();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                LockInfo li = new LockInfo();
                try {
                    byte[] bytes = Files.readAllBytes(this.path);
                    li.deserialize(new String(bytes));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (li.isValid() && Instant.now().compareTo(li.maxValidInstant) <= 0) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                this.writeLock();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void writeLock() {
        try {
            NPath p = NPath.of(this.path);
            p.mkParentDirs();
            Files.createFile(this.path, new FileAttribute[0]);
            LockInfo li = new LockInfo();
            NWorkspace ws = NWorkspace.of();
            li.hostname = ws.getHostName();
            li.instant = Instant.now();
            li.maxValidInstant = li.instant.plusSeconds(43200L);
            li.pid = ws.getPid();
            Files.write(this.path, li.serialize().getBytes(), new OpenOption[0]);
            this.ownerThread = Thread.currentThread();
        }
        catch (IOException ex) {
            throw new NLockAcquireException(NMsg.ofC("unable to acquire lock"), this.lockedObject, this, ex);
        }
    }

    @Override
    public Condition newCondition() {
        throw new NUnsupportedOperationException(NMsg.ofPlain("unsupported Lock.newCondition"));
    }

    @Override
    protected void reunlock() {
    }

    @Override
    protected void relock() {
    }

    @Override
    public NElement describe() {
        NUpletElementBuilder b = NElement.ofUpletBuilder("FileLock");
        if (this.path != null) {
            b.add("path", this.path.toString());
        }
        return b.build();
    }

    protected class PollTime {
        long timeMs;
        long minTimeToSleep;

        public PollTime(long timeMs, long minTimeToSleep) {
            this.timeMs = timeMs;
            this.minTimeToSleep = minTimeToSleep;
        }
    }

    public static class LockInfo {
        String hostname;
        String pid;
        Instant instant;
        Instant maxValidInstant;

        public boolean isValid() {
            return this.instant != null && this.maxValidInstant != null;
        }

        public void deserialize(String value) {
            NStringBuilder sb = new NStringBuilder(value);
            for (String line : sb.lines()) {
                if ((line = line.trim()).startsWith("hostname=")) {
                    this.hostname = line.substring("hostname=".length()).trim();
                    continue;
                }
                if (line.startsWith("pid=")) {
                    this.pid = line.substring("pid=".length()).trim();
                    continue;
                }
                if (line.startsWith("instant=")) {
                    this.instant = Instant.parse(line.substring("instant=".length()).trim());
                    continue;
                }
                if (!line.startsWith("maxValidInstant=")) continue;
                this.maxValidInstant = Instant.parse(line.substring("maxValidInstant=".length()).trim());
            }
        }

        public String serialize() {
            NStringBuilder sb = new NStringBuilder();
            sb.println("hostname=" + NStringUtils.trim(this.hostname));
            sb.println("pid=" + NStringUtils.trim(this.pid));
            sb.println("instant=" + this.instant);
            sb.println("maxValidInstant=" + this.maxValidInstant);
            return sb.toString();
        }

        public String toString() {
            return "LockInfo{hostname='" + this.hostname + '\'' + ", pid='" + this.pid + '\'' + ", instant='" + this.instant + "', maxValidInstant='" + this.maxValidInstant + "'" + '}';
        }
    }
}

