/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.util.Collection;
import java.util.List;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.boot.NBootWorkspaceFactory;
import net.thevpc.nuts.boot.NBootWorkspaceImpl;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.DefaultNBootOptionsBuilder;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.text.NMsg;

public class DefaultNBootWorkspaceFactory
implements NBootWorkspaceFactory {
    @Override
    public int getBootScore(NBootOptionsInfo options) {
        return 10;
    }

    @Override
    public NWorkspace createWorkspace(NBootOptionsInfo bOptions) {
        NBootOptions info2;
        String workspaceLocation;
        if (bOptions == null) {
            bOptions = new NBootOptionsInfo();
        }
        if ((workspaceLocation = (info2 = new DefaultNBootOptionsBuilder(bOptions).build()).getWorkspace().orNull()) != null && workspaceLocation.matches("[a-z-]+://.*")) {
            String protocol;
            switch (protocol = workspaceLocation.substring(0, workspaceLocation.indexOf("://"))) {
                case "local": {
                    return null;
                }
            }
            return null;
        }
        return new DefaultNWorkspace(bOptions, info2);
    }

    @Override
    public NWorkspace runWorkspace(NBootOptionsInfo options) {
        NWorkspace workspace = this.createWorkspace(options);
        if (workspace == null) {
            return null;
        }
        workspace.runWith(() -> {
            NBootOptions info2 = new DefaultNBootOptionsBuilder(options).build();
            NApp.of().setId(workspace.getApiId());
            NLog.of(NBootWorkspaceImpl.class).log(NMsg.ofC("running workspace in %s mode", this.getRunModeString(info2)).asConfig().withIntent(NMsgIntent.SUCCESS));
            NExecCmd execCmd = NExecCmd.of().setExecutionType(info2.getExecutionType().orNull()).setRunAs(info2.getRunAs().orNull()).failFast();
            List<String> executorOptions = info2.getExecutorOptions().orNull();
            if (executorOptions != null) {
                execCmd.configure(true, executorOptions.toArray(new String[0]));
            }
            NCmdLine executorOptionsCmdLine = NCmdLine.of(executorOptions).setExpandSimpleOptions(false);
            while (executorOptionsCmdLine.hasNext()) {
                execCmd.configureLast(executorOptionsCmdLine);
            }
            if (info2.getApplicationArguments().get().isEmpty()) {
                if (info2.getSkipWelcome().orElse(false).booleanValue()) {
                    return;
                }
                execCmd.addCommand("welcome");
            } else {
                execCmd.addCommand((Collection<String>)info2.getApplicationArguments().get());
            }
            execCmd.run();
        });
        return workspace;
    }

    private String getRunModeString(NBootOptions options) {
        if (options.getReset().orElse(false).booleanValue()) {
            return "reset";
        }
        if (options.getRecover().orElse(false).booleanValue()) {
            return "recover";
        }
        return "exec";
    }

    public String toString() {
        return "NBootWorkspaceFactory";
    }
}

