/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLineFormatStrategy;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NCmdLineShellOptions;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;
import net.thevpc.nuts.text.NCmdLineFormat;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNCmdLineFormat
extends DefaultFormatBase<NCmdLineFormat>
implements NCmdLineFormat {
    private NCmdLine value;
    private NShellFamily formatFamily = NShellFamily.getCurrent();
    private NCmdLineFormatStrategy formatStrategy = NCmdLineFormatStrategy.DEFAULT;

    public DefaultNCmdLineFormat(NWorkspace workspace) {
        super("commandLine");
    }

    @Override
    public NCmdLineFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    @Override
    public NCmdLineFormat setValue(NCmdLine value) {
        this.value = value;
        return this;
    }

    @Override
    public NCmdLineFormat setValue(String[] args) {
        return this.setValue(args == null ? null : NCmdLine.of(args));
    }

    @Override
    public NCmdLineFormat setValue(String args) {
        return this.setValue(args == null ? null : NCmdLines.of().parseCmdLine(args).get());
    }

    @Override
    public NShellFamily getShellFamily() {
        return this.formatFamily;
    }

    @Override
    public NCmdLineFormat setShellFamily(NShellFamily family) {
        this.formatFamily = family == null ? NShellFamily.getCurrent() : family;
        return this;
    }

    @Override
    public NCmdLineFormatStrategy getFormatStrategy() {
        return this.formatStrategy;
    }

    @Override
    public void setFormatStrategy(NCmdLineFormatStrategy formatStrategy) {
        this.formatStrategy = formatStrategy == null ? NCmdLineFormatStrategy.DEFAULT : formatStrategy;
    }

    @Override
    public NCmdLine getValue() {
        return this.value;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }

    @Override
    public void print(NPrintStream out) {
        if (this.value != null) {
            String cmd = NShellHelper.of(this.getShellFamily()).escapeArguments(this.value.toStringArray(), new NCmdLineShellOptions().setFormatStrategy(this.getFormatStrategy()).setExpectEnv(true));
            if (this.isNtf()) {
                out.print(NText.ofCode("system", cmd));
            } else {
                out.print(cmd);
            }
        }
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

