/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.InputStream;
import java.io.PrintStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NOpenMode;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspaceCmdLineParser;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.core.NWorkspaceOptionsBuilder;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.DefaultNWorkspaceOptions;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NSupportMode;

public class DefaultNWorkspaceOptionsBuilder
implements NWorkspaceOptionsBuilder {
    private static final long serialVersionUID = 1L;
    private List<String> outputFormatOptions;
    private List<String> customOptions;
    private NVersion apiVersion;
    private NId runtimeId;
    private String javaCommand;
    private String javaOptions;
    private String workspace;
    private String outLinePrefix;
    private String errLinePrefix;
    private String name;
    private Boolean installCompanions;
    private Boolean skipWelcome;
    private Boolean skipBoot;
    private Boolean system;
    private Boolean gui;
    private List<String> excludedExtensions;
    private List<String> repositories;
    private String userName;
    private Boolean sharedInstance;
    private char[] credentials;
    private NTerminalMode terminalMode;
    private Boolean readOnly;
    private Boolean trace;
    private String progressOptions;
    private String dependencySolver;
    private NLogConfig logConfig;
    private NConfirmationMode confirm;
    private NContentType outputFormat;
    private List<String> applicationArguments;
    private NOpenMode openMode;
    private Instant creationTime;
    private Boolean dry;
    private Boolean showStacktrace;
    private Supplier<ClassLoader> classLoaderSupplier;
    private List<String> executorOptions;
    private Boolean recover;
    private Boolean reset;
    private Boolean resetHard;
    private Boolean commandVersion;
    private Boolean commandHelp;
    private String debug;
    private Boolean inherited;
    private NExecutionType executionType;
    private NRunAs runAs;
    private String archetype;
    private Boolean switchWorkspace;
    private Map<NStoreType, String> storeLocations;
    private Map<NHomeLocation, String> homeLocations;
    private NOsFamily storeLayout;
    private NStoreStrategy storeStrategy;
    private NStoreStrategy repositoryStoreStrategy;
    private List<String> bootRepositories;
    private NFetchStrategy fetchStrategy;
    private Boolean cached;
    private Boolean indexed;
    private Boolean transitive;
    private Boolean bot;
    private Boolean previewRepo;
    private InputStream stdin;
    private PrintStream stdout;
    private PrintStream stderr;
    private ExecutorService executorService;
    private Instant expireTime;
    private List<NMsg> errors;
    private Boolean skipErrors;
    private String locale;
    private String theme;
    private Boolean initLaunchers;
    private Boolean initScripts;
    private Boolean initPlatforms;
    private Boolean initJava;
    private NIsolationLevel isolationLevel;
    private NSupportMode desktopLauncher;
    private NSupportMode menuLauncher;
    private NSupportMode userLauncher;

    @Override
    public NWorkspaceOptionsBuilder resetOptions() {
        this.outputFormatOptions = null;
        this.customOptions = null;
        this.apiVersion = null;
        this.runtimeId = null;
        this.javaCommand = null;
        this.javaOptions = null;
        this.workspace = null;
        this.outLinePrefix = null;
        this.errLinePrefix = null;
        this.name = null;
        this.installCompanions = null;
        this.skipWelcome = null;
        this.skipBoot = null;
        this.system = null;
        this.gui = null;
        this.excludedExtensions = null;
        this.repositories = null;
        this.userName = null;
        this.sharedInstance = null;
        this.credentials = null;
        this.terminalMode = null;
        this.readOnly = null;
        this.trace = null;
        this.progressOptions = null;
        this.dependencySolver = null;
        this.logConfig = null;
        this.confirm = null;
        this.outputFormat = null;
        this.applicationArguments = null;
        this.openMode = null;
        this.creationTime = null;
        this.dry = null;
        this.showStacktrace = null;
        this.classLoaderSupplier = null;
        this.executorOptions = null;
        this.recover = null;
        this.reset = null;
        this.resetHard = null;
        this.commandHelp = null;
        this.debug = null;
        this.inherited = null;
        this.executionType = null;
        this.runAs = null;
        this.archetype = null;
        this.switchWorkspace = null;
        this.storeLocations = null;
        this.homeLocations = null;
        this.storeLayout = null;
        this.storeStrategy = null;
        this.repositoryStoreStrategy = null;
        this.bootRepositories = null;
        this.fetchStrategy = null;
        this.cached = null;
        this.indexed = null;
        this.transitive = null;
        this.bot = null;
        this.previewRepo = null;
        this.stdin = null;
        this.stdout = null;
        this.stderr = null;
        this.executorService = null;
        this.expireTime = null;
        this.skipErrors = null;
        this.locale = null;
        this.theme = null;
        this.initLaunchers = null;
        this.initScripts = null;
        this.initPlatforms = null;
        this.initJava = null;
        this.isolationLevel = null;
        this.desktopLauncher = null;
        this.menuLauncher = null;
        this.userLauncher = null;
        return this;
    }

    @Override
    public NOptional<NSupportMode> getDesktopLauncher() {
        return NOptional.ofNamed(this.desktopLauncher, "desktopLauncher");
    }

    @Override
    public NOptional<NSupportMode> getMenuLauncher() {
        return NOptional.ofNamed(this.menuLauncher, "menuLauncher");
    }

    @Override
    public NOptional<NSupportMode> getUserLauncher() {
        return NOptional.ofNamed(this.userLauncher, "userLauncher");
    }

    @Override
    public NWorkspaceOptionsBuilder setInitLaunchers(Boolean initLaunchers) {
        this.initLaunchers = initLaunchers;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setInitScripts(Boolean initScripts) {
        this.initScripts = initScripts;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setInitPlatforms(Boolean initPlatforms) {
        this.initPlatforms = initPlatforms;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setInitJava(Boolean initJava) {
        this.initJava = initJava;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setIsolationLevel(NIsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setDesktopLauncher(NSupportMode desktopLauncher) {
        this.desktopLauncher = desktopLauncher;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setMenuLauncher(NSupportMode menuLauncher) {
        this.menuLauncher = menuLauncher;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setUserLauncher(NSupportMode userLauncher) {
        this.userLauncher = userLauncher;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder copy() {
        return new DefaultNWorkspaceOptionsBuilder().copyFrom(this);
    }

    @Override
    public NOptional<NVersion> getApiVersion() {
        return NOptional.ofNamed(this.apiVersion, "apiVersion");
    }

    @Override
    public NWorkspaceOptionsBuilder setApiVersion(NVersion apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    public NOptional<List<String>> getApplicationArguments() {
        return NOptional.ofNamed(this.applicationArguments, "applicationArguments");
    }

    @Override
    public NWorkspaceOptionsBuilder setApplicationArguments(List<String> applicationArguments) {
        this.applicationArguments = applicationArguments;
        return this;
    }

    @Override
    public NOptional<String> getArchetype() {
        return NOptional.ofNamed(this.archetype, "archetype");
    }

    @Override
    public NWorkspaceOptionsBuilder setArchetype(String archetype) {
        this.archetype = archetype;
        return this;
    }

    @Override
    public NOptional<Supplier<ClassLoader>> getClassLoaderSupplier() {
        return NOptional.ofNamed(this.classLoaderSupplier, "classLoaderSupplier");
    }

    @Override
    public NWorkspaceOptionsBuilder setClassLoaderSupplier(Supplier<ClassLoader> provider) {
        this.classLoaderSupplier = provider;
        return this;
    }

    @Override
    public NOptional<NConfirmationMode> getConfirm() {
        return NOptional.ofNamed(this.confirm, "confirm");
    }

    @Override
    public NWorkspaceOptionsBuilder setConfirm(NConfirmationMode confirm) {
        this.confirm = confirm;
        return this;
    }

    @Override
    public NOptional<Boolean> getDry() {
        return NOptional.ofNamed(this.dry, "dry");
    }

    @Override
    public NOptional<Boolean> getShowStacktrace() {
        return NOptional.ofNamed(this.showStacktrace, "showStacktrace");
    }

    @Override
    public NWorkspaceOptionsBuilder setDry(Boolean dry) {
        this.dry = dry;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setShowStacktrace(Boolean showStacktrace) {
        this.showStacktrace = showStacktrace;
        return this;
    }

    @Override
    public NOptional<Instant> getCreationTime() {
        return NOptional.ofNamed(this.creationTime, "creationTime");
    }

    @Override
    public NWorkspaceOptionsBuilder setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Override
    public NOptional<List<String>> getExcludedExtensions() {
        return NOptional.ofNamed(this.excludedExtensions, "excludedExtensions");
    }

    @Override
    public NWorkspaceOptionsBuilder setExcludedExtensions(List<String> excludedExtensions) {
        this.excludedExtensions = excludedExtensions;
        return this;
    }

    @Override
    public NOptional<NExecutionType> getExecutionType() {
        return NOptional.ofNamed(this.executionType, "executionType");
    }

    @Override
    public NWorkspaceOptionsBuilder setExecutionType(NExecutionType executionType) {
        this.executionType = executionType;
        return this;
    }

    @Override
    public NOptional<NRunAs> getRunAs() {
        return NOptional.ofNamed(this.runAs, "runAs");
    }

    @Override
    public NWorkspaceOptionsBuilder setRunAs(NRunAs runAs) {
        this.runAs = runAs;
        return this;
    }

    @Override
    public NOptional<List<String>> getExecutorOptions() {
        return NOptional.ofNamed(this.executorOptions, "executorOptions");
    }

    @Override
    public NWorkspaceOptionsBuilder setExecutorOptions(List<String> executorOptions) {
        this.executorOptions = executorOptions;
        return this;
    }

    @Override
    public NOptional<String> getHomeLocation(NHomeLocation location) {
        return NOptional.ofNamed(this.homeLocations == null ? null : this.homeLocations.get(location), "homeLocations[" + location + "]");
    }

    @Override
    public NOptional<Map<NHomeLocation, String>> getHomeLocations() {
        return NOptional.ofNamed(this.homeLocations, "homeLocations");
    }

    @Override
    public NWorkspaceOptionsBuilder setHomeLocations(Map<NHomeLocation, String> homeLocations) {
        if (homeLocations != null) {
            if (this.homeLocations == null) {
                this.homeLocations = new HashMap<NHomeLocation, String>();
            }
            this.homeLocations.putAll(homeLocations);
        } else {
            this.homeLocations = null;
        }
        return this;
    }

    @Override
    public NOptional<String> getJavaCommand() {
        return NOptional.ofNamed(this.javaCommand, "javaCommand");
    }

    @Override
    public NWorkspaceOptionsBuilder setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    @Override
    public NOptional<String> getJavaOptions() {
        return NOptional.ofNamed(this.javaOptions, "javaOptions");
    }

    @Override
    public NWorkspaceOptionsBuilder setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    @Override
    public NOptional<NLogConfig> getLogConfig() {
        return NOptional.ofNamed(this.logConfig, "logConfig");
    }

    @Override
    public NWorkspaceOptionsBuilder setLogConfig(NLogConfig logConfig) {
        this.logConfig = logConfig == null ? null : logConfig.copy();
        return this;
    }

    @Override
    public NOptional<String> getName() {
        return NOptional.ofNamed(this.name, "name");
    }

    @Override
    public NWorkspaceOptionsBuilder setName(String workspaceName) {
        this.name = workspaceName;
        return this;
    }

    @Override
    public NOptional<NOpenMode> getOpenMode() {
        return NOptional.ofNamed(this.openMode, "openMode");
    }

    @Override
    public NWorkspaceOptionsBuilder setOpenMode(NOpenMode openMode) {
        this.openMode = openMode;
        return this;
    }

    @Override
    public NOptional<NContentType> getOutputFormat() {
        return NOptional.ofNamed(this.outputFormat, "outputFormat");
    }

    @Override
    public NWorkspaceOptionsBuilder setOutputFormat(NContentType outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    @Override
    public NOptional<List<String>> getOutputFormatOptions() {
        return NOptional.ofNamed(this.outputFormatOptions, "outputFormatOptions");
    }

    @Override
    public NWorkspaceOptionsBuilder setOutputFormatOptions(List<String> options) {
        if (options != null) {
            if (this.outputFormatOptions == null) {
                this.outputFormatOptions = new ArrayList<String>();
            }
            this.outputFormatOptions.clear();
            return this.addOutputFormatOptions(NReservedLangUtils.nonNullList(options).toArray(new String[0]));
        }
        this.outputFormatOptions = null;
        return this;
    }

    public NWorkspaceOptionsBuilder setOutputFormatOptions(String ... options) {
        if (this.outputFormatOptions == null) {
            this.outputFormatOptions = new ArrayList<String>();
        }
        this.outputFormatOptions.clear();
        return this.addOutputFormatOptions(options);
    }

    @Override
    public NOptional<char[]> getCredentials() {
        return NOptional.ofNamed(this.credentials, "credentials");
    }

    @Override
    public NWorkspaceOptionsBuilder setCredentials(char[] credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public NOptional<NStoreStrategy> getRepositoryStoreStrategy() {
        return NOptional.ofNamed(this.repositoryStoreStrategy, "repositoryStoreStrategy");
    }

    @Override
    public NWorkspaceOptionsBuilder setRepositoryStoreStrategy(NStoreStrategy repositoryStoreStrategy) {
        this.repositoryStoreStrategy = repositoryStoreStrategy;
        return this;
    }

    @Override
    public NOptional<NId> getRuntimeId() {
        return NOptional.ofNamed(this.runtimeId, "runtimeId");
    }

    @Override
    public NWorkspaceOptionsBuilder setRuntimeId(NId runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    @Override
    public NOptional<String> getStoreType(NStoreType folder) {
        return NOptional.ofNamed(this.storeLocations == null ? null : this.storeLocations.get(folder), "storeLocations[" + folder + "]");
    }

    @Override
    public NOptional<NOsFamily> getStoreLayout() {
        return NOptional.ofNamed(this.storeLayout, "storeLayout");
    }

    @Override
    public NWorkspaceOptionsBuilder setStoreLayout(NOsFamily storeLayout) {
        this.storeLayout = storeLayout;
        return this;
    }

    @Override
    public NOptional<NStoreStrategy> getStoreStrategy() {
        return NOptional.ofNamed(this.storeStrategy, "storeStrategy");
    }

    @Override
    public NWorkspaceOptionsBuilder setStoreStrategy(NStoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    @Override
    public NOptional<Map<NStoreType, String>> getStoreLocations() {
        return NOptional.ofNamed(this.storeLocations, "storeLocations");
    }

    @Override
    public NWorkspaceOptionsBuilder setStoreLocations(Map<NStoreType, String> storeLocations) {
        if (storeLocations != null) {
            if (this.storeLocations == null) {
                this.storeLocations = new HashMap<NStoreType, String>();
            }
            this.storeLocations.clear();
            this.storeLocations.putAll(NReservedLangUtils.nonNullMap(storeLocations));
        } else {
            this.storeLocations = null;
        }
        return this;
    }

    @Override
    public NOptional<NTerminalMode> getTerminalMode() {
        return NOptional.ofNamed(this.terminalMode, "terminalMode");
    }

    @Override
    public NWorkspaceOptionsBuilder setTerminalMode(NTerminalMode terminalMode) {
        this.terminalMode = terminalMode;
        return this;
    }

    @Override
    public NOptional<List<String>> getRepositories() {
        return NOptional.ofNamed(this.repositories, "repositories");
    }

    @Override
    public NOptional<List<String>> getBootRepositories() {
        return NOptional.ofNamed(this.bootRepositories, "bootRepositories");
    }

    @Override
    public NWorkspaceOptionsBuilder setRepositories(List<String> repositories) {
        this.repositories = repositories;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setBootRepositories(List<String> repositories) {
        this.bootRepositories = repositories;
        return this;
    }

    @Override
    public NOptional<String> getUserName() {
        return NOptional.ofNamed(this.userName, "userName");
    }

    @Override
    public NOptional<String> getWorkspace() {
        return NOptional.ofNamed(this.workspace, "workspace");
    }

    @Override
    public NWorkspaceOptionsBuilder setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    @Override
    public NOptional<String> getDebug() {
        return NOptional.ofNamed(this.debug, "debug");
    }

    @Override
    public NWorkspaceOptionsBuilder setDebug(String debug) {
        this.debug = debug;
        return this;
    }

    @Override
    public NOptional<Boolean> getSystem() {
        return NOptional.ofNamed(this.system, "system");
    }

    @Override
    public NWorkspaceOptionsBuilder setSystem(Boolean system) {
        this.system = system;
        return this;
    }

    @Override
    public NOptional<Boolean> getGui() {
        return NOptional.ofNamed(this.gui, "gui");
    }

    @Override
    public NWorkspaceOptionsBuilder setGui(Boolean gui) {
        this.gui = gui;
        return this;
    }

    @Override
    public NOptional<Boolean> getInherited() {
        return NOptional.ofNamed(this.inherited, "inherited");
    }

    @Override
    public NWorkspaceOptionsBuilder setInherited(Boolean inherited) {
        this.inherited = inherited;
        return this;
    }

    @Override
    public NOptional<Boolean> getReadOnly() {
        return NOptional.ofNamed(this.readOnly, "readOnly");
    }

    @Override
    public NWorkspaceOptionsBuilder setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public NOptional<Boolean> getRecover() {
        return NOptional.ofNamed(this.recover, "recover");
    }

    @Override
    public NWorkspaceOptionsBuilder setRecover(Boolean recover) {
        this.recover = recover;
        return this;
    }

    @Override
    public NOptional<Boolean> getReset() {
        return NOptional.ofNamed(this.reset, "reset");
    }

    @Override
    public NWorkspaceOptionsBuilder setReset(Boolean reset) {
        this.reset = reset;
        return this;
    }

    @Override
    public NOptional<Boolean> getResetHard() {
        return NOptional.ofNamed(this.resetHard, "resetHard");
    }

    @Override
    public NWorkspaceOptionsBuilder setResetHard(Boolean resetHard) {
        this.resetHard = resetHard;
        return this;
    }

    @Override
    public NOptional<Boolean> getCommandVersion() {
        return NOptional.ofNamed(this.commandVersion, "commandVersion");
    }

    @Override
    public NWorkspaceOptionsBuilder setCommandVersion(Boolean version) {
        this.commandVersion = version;
        return this;
    }

    @Override
    public NOptional<Boolean> getCommandHelp() {
        return NOptional.ofNamed(this.commandHelp, "commandHelp");
    }

    @Override
    public NWorkspaceOptionsBuilder setCommandHelp(Boolean help) {
        this.commandHelp = help;
        return this;
    }

    @Override
    public NOptional<Boolean> getInstallCompanions() {
        return NOptional.ofNamed(this.installCompanions, "installCompanions");
    }

    @Override
    public NWorkspaceOptionsBuilder setInstallCompanions(Boolean skipInstallCompanions) {
        this.installCompanions = skipInstallCompanions;
        return this;
    }

    @Override
    public NOptional<Boolean> getSkipWelcome() {
        return NOptional.ofNamed(this.skipWelcome, "skipWelcome");
    }

    @Override
    public NWorkspaceOptionsBuilder setSkipWelcome(Boolean skipWelcome) {
        this.skipWelcome = skipWelcome;
        return this;
    }

    @Override
    public NOptional<String> getOutLinePrefix() {
        return NOptional.ofNamed(this.outLinePrefix, "outLinePrefix");
    }

    @Override
    public NWorkspaceOptionsBuilder setOutLinePrefix(String outLinePrefix) {
        this.outLinePrefix = outLinePrefix;
        return this;
    }

    @Override
    public NOptional<String> getErrLinePrefix() {
        return NOptional.ofNamed(this.errLinePrefix, "errLinePrefix");
    }

    @Override
    public NWorkspaceOptionsBuilder setErrLinePrefix(String errLinePrefix) {
        this.errLinePrefix = errLinePrefix;
        return this;
    }

    @Override
    public NOptional<Boolean> getSkipBoot() {
        return NOptional.ofNamed(this.skipBoot, "skipBoot");
    }

    @Override
    public NWorkspaceOptionsBuilder setSkipBoot(Boolean skipBoot) {
        this.skipBoot = skipBoot;
        return this;
    }

    @Override
    public NOptional<Boolean> getTrace() {
        return NOptional.ofNamed(this.trace, "trace");
    }

    @Override
    public NWorkspaceOptionsBuilder setTrace(Boolean trace) {
        this.trace = trace;
        return this;
    }

    @Override
    public NOptional<String> getProgressOptions() {
        return NOptional.ofNamed(this.progressOptions, "progressOptions");
    }

    @Override
    public NWorkspaceOptionsBuilder setProgressOptions(String progressOptions) {
        this.progressOptions = progressOptions;
        return this;
    }

    @Override
    public NOptional<Boolean> getCached() {
        return NOptional.ofNamed(this.cached, "cached");
    }

    @Override
    public NWorkspaceOptionsBuilder setCached(Boolean cached) {
        this.cached = cached;
        return this;
    }

    @Override
    public NOptional<Boolean> getIndexed() {
        return NOptional.ofNamed(this.indexed, "indexed");
    }

    @Override
    public NWorkspaceOptionsBuilder setIndexed(Boolean indexed) {
        this.indexed = indexed;
        return this;
    }

    @Override
    public NOptional<Boolean> getTransitive() {
        return NOptional.ofNamed(this.transitive, "transitive");
    }

    @Override
    public NWorkspaceOptionsBuilder setTransitive(Boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    @Override
    public NOptional<Boolean> getBot() {
        return NOptional.ofNamed(this.bot, "bot");
    }

    @Override
    public NWorkspaceOptionsBuilder setBot(Boolean bot) {
        this.bot = bot;
        return this;
    }

    @Override
    public NOptional<Boolean> getPreviewRepo() {
        return NOptional.ofNamed(this.previewRepo, "previewRepo");
    }

    @Override
    public NWorkspaceOptionsBuilder setPreviewRepo(Boolean bot) {
        this.previewRepo = bot;
        return this;
    }

    @Override
    public NOptional<NFetchStrategy> getFetchStrategy() {
        return NOptional.ofNamed(this.fetchStrategy, "fetchStrategy");
    }

    @Override
    public NWorkspaceOptionsBuilder setFetchStrategy(NFetchStrategy fetchStrategy) {
        this.fetchStrategy = fetchStrategy;
        return this;
    }

    @Override
    public NOptional<InputStream> getStdin() {
        return NOptional.ofNamed(this.stdin, "stdin");
    }

    @Override
    public NWorkspaceOptionsBuilder setStdin(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    @Override
    public NOptional<PrintStream> getStdout() {
        return NOptional.ofNamed(this.stdout, "stdout");
    }

    @Override
    public NWorkspaceOptionsBuilder setStdout(PrintStream stdout) {
        this.stdout = stdout;
        return this;
    }

    @Override
    public NOptional<PrintStream> getStderr() {
        return NOptional.ofNamed(this.stderr, "stderr");
    }

    @Override
    public NWorkspaceOptionsBuilder setStderr(PrintStream stderr) {
        this.stderr = stderr;
        return this;
    }

    @Override
    public NOptional<ExecutorService> getExecutorService() {
        return NOptional.ofNamed(this.executorService, "executorService");
    }

    @Override
    public NWorkspaceOptionsBuilder setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    @Override
    public NOptional<Instant> getExpireTime() {
        return NOptional.ofNamed(this.expireTime, "expireTime");
    }

    @Override
    public NWorkspaceOptionsBuilder setExpireTime(Instant expireTime) {
        this.expireTime = expireTime;
        return this;
    }

    @Override
    public NOptional<Boolean> getSkipErrors() {
        return NOptional.ofNamed(this.skipErrors, "skipErrors");
    }

    @Override
    public NWorkspaceOptionsBuilder setSkipErrors(Boolean value) {
        this.skipErrors = value;
        return this;
    }

    @Override
    public NOptional<Boolean> getSwitchWorkspace() {
        return NOptional.ofNamed(this.switchWorkspace, "switchWorkspace");
    }

    @Override
    public NWorkspaceOptionsBuilder setSwitchWorkspace(Boolean switchWorkspace) {
        this.switchWorkspace = switchWorkspace;
        return this;
    }

    @Override
    public NOptional<List<NMsg>> getErrors() {
        return NOptional.ofNamed(this.errors, "errors");
    }

    @Override
    public NWorkspaceOptionsBuilder setErrors(List<NMsg> errors) {
        this.errors = errors;
        return this;
    }

    @Override
    public NOptional<List<String>> getCustomOptions() {
        return NOptional.ofNamed(this.customOptions, "customOptions");
    }

    @Override
    public NWorkspaceOptionsBuilder setCustomOptions(List<String> properties) {
        this.customOptions = properties;
        return this;
    }

    @Override
    public NOptional<String> getLocale() {
        return NOptional.ofNamed(this.locale, "locale");
    }

    @Override
    public NWorkspaceOptionsBuilder setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public NOptional<String> getTheme() {
        return NOptional.ofNamed(this.theme, "theme");
    }

    @Override
    public NWorkspaceOptionsBuilder setTheme(String theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder copyFrom(NWorkspaceOptions other) {
        if (other == null) {
            return this;
        }
        this.setApiVersion(other.getApiVersion().orNull());
        this.setRuntimeId(other.getRuntimeId().orNull());
        this.setJavaCommand(other.getJavaCommand().orNull());
        this.setJavaOptions(other.getJavaOptions().orNull());
        this.setWorkspace(other.getWorkspace().orNull());
        this.setName(other.getName().orNull());
        this.setInstallCompanions(other.getInstallCompanions().orNull());
        this.setSkipWelcome(other.getSkipWelcome().orNull());
        this.setSkipBoot(other.getSkipBoot().orNull());
        this.setSystem(other.getSystem().orNull());
        this.setGui(other.getGui().orNull());
        this.setUserName(other.getUserName().orNull());
        this.setCredentials(other.getCredentials().orNull());
        this.setTerminalMode(other.getTerminalMode().orNull());
        this.setReadOnly(other.getReadOnly().orNull());
        this.setTrace(other.getTrace().orNull());
        this.setProgressOptions(other.getProgressOptions().orNull());
        this.setLogConfig(other.getLogConfig().orNull());
        this.setConfirm(other.getConfirm().orNull());
        this.setConfirm(other.getConfirm().orNull());
        this.setOutputFormat(other.getOutputFormat().orNull());
        this.setOutputFormatOptions(other.getOutputFormatOptions().orNull());
        this.setOpenMode(other.getOpenMode().orNull());
        this.setCreationTime(other.getCreationTime().orNull());
        this.setDry(other.getDry().orNull());
        this.setShowStacktrace(other.getShowStacktrace().orNull());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier().orNull());
        this.setExecutorOptions(other.getExecutorOptions().orNull());
        this.setRecover(other.getRecover().orNull());
        this.setReset(other.getReset().orNull());
        this.setResetHard(other.getResetHard().orNull());
        this.setCommandVersion(other.getCommandVersion().orNull());
        this.setCommandHelp(other.getCommandHelp().orNull());
        this.setDebug(other.getDebug().orNull());
        this.setInherited(other.getInherited().orNull());
        this.setExecutionType(other.getExecutionType().orNull());
        this.setRunAs(other.getRunAs().orNull());
        this.setArchetype(other.getArchetype().orNull());
        this.setStoreStrategy(other.getStoreStrategy().orNull());
        this.setHomeLocations(other.getHomeLocations().orNull());
        this.setStoreLocations(other.getStoreLocations().orNull());
        this.setStoreLayout(other.getStoreLayout().orNull());
        this.setStoreStrategy(other.getStoreStrategy().orNull());
        this.setRepositoryStoreStrategy(other.getRepositoryStoreStrategy().orNull());
        this.setFetchStrategy(other.getFetchStrategy().orNull());
        this.setCached(other.getCached().orNull());
        this.setIndexed(other.getIndexed().orNull());
        this.setTransitive(other.getTransitive().orNull());
        this.setBot(other.getBot().orNull());
        this.setStdin(other.getStdin().orNull());
        this.setStdout(other.getStdout().orNull());
        this.setStderr(other.getStderr().orNull());
        this.setExecutorService(other.getExecutorService().orNull());
        this.setExcludedExtensions(other.getExcludedExtensions().orNull());
        this.setRepositories(other.getRepositories().orNull());
        this.setApplicationArguments(other.getApplicationArguments().orNull());
        this.setCustomOptions(other.getCustomOptions().orNull());
        this.setExpireTime(other.getExpireTime().orNull());
        this.setErrors(other.getErrors().orNull());
        this.setSkipErrors(other.getSkipErrors().orNull());
        this.setSwitchWorkspace(other.getSwitchWorkspace().orNull());
        this.setLocale(other.getLocale().orNull());
        this.setTheme(other.getTheme().orNull());
        this.setDependencySolver(other.getDependencySolver().orNull());
        this.setIsolationLevel(other.getIsolationLevel().orNull());
        this.setInitLaunchers(other.getInitLaunchers().orNull());
        this.setInitJava(other.getInitJava().orNull());
        this.setInitScripts(other.getInitScripts().orNull());
        this.setInitPlatforms(other.getInitPlatforms().orNull());
        this.setDesktopLauncher(other.getDesktopLauncher().orNull());
        this.setMenuLauncher(other.getMenuLauncher().orNull());
        this.setUserLauncher(other.getUserLauncher().orNull());
        this.setSharedInstance(other.getSharedInstance().orNull());
        this.setPreviewRepo(other.getPreviewRepo().orNull());
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder copyFrom(NWorkspaceOptionsBuilder other) {
        if (other == null) {
            return this;
        }
        this.setApiVersion(other.getApiVersion().orNull());
        this.setRuntimeId(other.getRuntimeId().orNull());
        this.setJavaCommand(other.getJavaCommand().orNull());
        this.setJavaOptions(other.getJavaOptions().orNull());
        this.setWorkspace(other.getWorkspace().orNull());
        this.setName(other.getName().orNull());
        this.setInstallCompanions(other.getInstallCompanions().orNull());
        this.setSkipWelcome(other.getSkipWelcome().orNull());
        this.setSkipBoot(other.getSkipBoot().orNull());
        this.setSystem(other.getSystem().orNull());
        this.setGui(other.getGui().orNull());
        this.setUserName(other.getUserName().orNull());
        this.setCredentials(other.getCredentials().orNull());
        this.setTerminalMode(other.getTerminalMode().orNull());
        this.setReadOnly(other.getReadOnly().orNull());
        this.setTrace(other.getTrace().orNull());
        this.setProgressOptions(other.getProgressOptions().orNull());
        this.setLogConfig(other.getLogConfig().orNull());
        this.setConfirm(other.getConfirm().orNull());
        this.setConfirm(other.getConfirm().orNull());
        this.setOutputFormat(other.getOutputFormat().orNull());
        this.setOutputFormatOptions(other.getOutputFormatOptions().orNull());
        this.setOpenMode(other.getOpenMode().orNull());
        this.setCreationTime(other.getCreationTime().orNull());
        this.setDry(other.getDry().orNull());
        this.setShowStacktrace(other.getShowStacktrace().orNull());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier().orNull());
        this.setExecutorOptions(other.getExecutorOptions().orNull());
        this.setRecover(other.getRecover().orNull());
        this.setReset(other.getReset().orNull());
        this.setResetHard(other.getResetHard().orNull());
        this.setCommandVersion(other.getCommandVersion().orNull());
        this.setCommandHelp(other.getCommandHelp().orNull());
        this.setDebug(other.getDebug().orNull());
        this.setInherited(other.getInherited().orNull());
        this.setExecutionType(other.getExecutionType().orNull());
        this.setRunAs(other.getRunAs().orNull());
        this.setArchetype(other.getArchetype().orNull());
        this.setStoreStrategy(other.getStoreStrategy().orNull());
        this.setHomeLocations(other.getHomeLocations().orNull());
        this.setStoreLocations(other.getStoreLocations().orNull());
        this.setStoreLayout(other.getStoreLayout().orNull());
        this.setStoreStrategy(other.getStoreStrategy().orNull());
        this.setRepositoryStoreStrategy(other.getRepositoryStoreStrategy().orNull());
        this.setFetchStrategy(other.getFetchStrategy().orNull());
        this.setCached(other.getCached().orNull());
        this.setIndexed(other.getIndexed().orNull());
        this.setTransitive(other.getTransitive().orNull());
        this.setBot(other.getBot().orNull());
        this.setStdin(other.getStdin().orNull());
        this.setStdout(other.getStdout().orNull());
        this.setStderr(other.getStderr().orNull());
        this.setExecutorService(other.getExecutorService().orNull());
        this.setExcludedExtensions(other.getExcludedExtensions().orNull());
        this.setRepositories(other.getRepositories().orNull());
        this.setApplicationArguments(other.getApplicationArguments().orNull());
        this.setCustomOptions(other.getCustomOptions().orNull());
        this.setExpireTime(other.getExpireTime().orNull());
        this.setErrors(other.getErrors().orNull());
        this.setSkipErrors(other.getSkipErrors().orNull());
        this.setSwitchWorkspace(other.getSwitchWorkspace().orNull());
        this.setLocale(other.getLocale().orNull());
        this.setTheme(other.getTheme().orNull());
        this.setDependencySolver(other.getDependencySolver().orNull());
        this.setIsolationLevel(other.getIsolationLevel().orNull());
        this.setInitLaunchers(other.getInitLaunchers().orNull());
        this.setInitJava(other.getInitJava().orNull());
        this.setInitScripts(other.getInitScripts().orNull());
        this.setInitPlatforms(other.getInitPlatforms().orNull());
        this.setDesktopLauncher(other.getDesktopLauncher().orNull());
        this.setMenuLauncher(other.getMenuLauncher().orNull());
        this.setUserLauncher(other.getUserLauncher().orNull());
        this.setSharedInstance(other.getSharedInstance().orNull());
        this.setPreviewRepo(other.getPreviewRepo().orNull());
        return this;
    }

    @Override
    public NBootOptionsInfo toBootOptionsInfo() {
        return this.build().toBootOptionsInfo();
    }

    public NWorkspaceOptionsBuilder copyFrom(NBootOptionsInfo other) {
        this.setApiVersion(other.getApiVersion() == null ? null : NVersion.get(other.getApiVersion()).orNull());
        this.setRuntimeId(other.getRuntimeId() == null ? null : (other.getRuntimeId().contains("#") ? NId.get(other.getRuntimeId()).orNull() : NId.getRuntime(other.getRuntimeId()).orNull()));
        this.setJavaCommand(other.getJavaCommand());
        this.setJavaOptions(other.getJavaOptions());
        this.setWorkspace(other.getWorkspace());
        this.setName(other.getName());
        this.setInstallCompanions(other.getInstallCompanions());
        this.setSkipWelcome(other.getSkipWelcome());
        this.setSkipBoot(other.getSkipBoot());
        this.setSystem(other.getSystem());
        this.setGui(other.getGui());
        this.setUserName(other.getUserName());
        this.setCredentials(other.getCredentials());
        this.setTerminalMode(NTerminalMode.parse(other.getTerminalMode()).orNull());
        this.setReadOnly(other.getReadOnly());
        this.setTrace(other.getTrace());
        this.setProgressOptions(other.getProgressOptions());
        Map<String, String> c = other.getLogConfig();
        Cloneable v = null;
        if (c != null) {
            v = new NLogConfig();
            ((NLogConfig)v).setLogFileBase(((NBootLogConfig)((Object)c)).getLogFileBase());
            ((NLogConfig)v).setLogFileLevel(((NBootLogConfig)((Object)c)).getLogFileLevel());
            ((NLogConfig)v).setLogTermLevel(((NBootLogConfig)((Object)c)).getLogTermLevel());
            ((NLogConfig)v).setLogFileSize(((NBootLogConfig)((Object)c)).getLogFileSize());
            ((NLogConfig)v).setLogFileCount(((NBootLogConfig)((Object)c)).getLogFileCount());
            ((NLogConfig)v).setLogFileName(((NBootLogConfig)((Object)c)).getLogFileName());
            ((NLogConfig)v).setLogFileBase(((NBootLogConfig)((Object)c)).getLogFileBase());
        }
        this.setLogConfig((NLogConfig)v);
        this.setConfirm(NConfirmationMode.parse(other.getConfirm()).orNull());
        this.setConfirm(NConfirmationMode.parse(other.getConfirm()).orNull());
        this.setOutputFormat(NContentType.parse(other.getOutputFormat()).orNull());
        this.setOutputFormatOptions(other.getOutputFormatOptions());
        this.setOpenMode(NOpenMode.parse(other.getOpenMode()).orNull());
        this.setCreationTime(other.getCreationTime());
        this.setDry(other.getDry());
        this.setShowStacktrace(other.getShowStacktrace());
        this.setClassLoaderSupplier(other.getClassLoaderSupplier());
        this.setExecutorOptions(other.getExecutorOptions());
        this.setRecover(other.getRecover());
        this.setReset(other.getReset());
        this.setResetHard(other.getResetHard());
        this.setCommandVersion(other.getCommandVersion());
        this.setCommandHelp(other.getCommandHelp());
        this.setDebug(other.getDebug());
        this.setInherited(other.getInherited());
        this.setExecutionType(NExecutionType.parse(other.getExecutionType()).orNull());
        this.setRunAs(NRunAs.parse(other.getRunAs()).orNull());
        this.setArchetype(other.getArchetype());
        this.setStoreStrategy(NStoreStrategy.parse(other.getStoreStrategy()).orNull());
        c = other.getHomeLocations();
        v = null;
        if (c != null) {
            v = new HashMap();
            for (Map.Entry entry : c.entrySet()) {
                v.put(NHomeLocation.of(NOsFamily.parse(((NBootHomeLocation)entry.getKey()).getOsFamily()).get(), NStoreType.parse(((NBootHomeLocation)entry.getKey()).getStoreLocation()).get()), (String)entry.getValue());
            }
        }
        this.setHomeLocations((Map<NHomeLocation, String>)((Object)v));
        c = other.getStoreLocations();
        v = null;
        if (c != null) {
            v = new HashMap();
            for (Map.Entry<Object, Object> entry : c.entrySet()) {
                v.put(NStoreType.parse((String)entry.getKey()).get(), (String)entry.getValue());
            }
        }
        this.setStoreLocations((Map<NStoreType, String>)((Object)v));
        this.setStoreLayout(NOsFamily.parse(other.getStoreLayout()).orNull());
        this.setStoreStrategy(NStoreStrategy.parse(other.getStoreStrategy()).orNull());
        this.setRepositoryStoreStrategy(NStoreStrategy.parse(other.getRepositoryStoreStrategy()).orNull());
        this.setFetchStrategy(NFetchStrategy.parse(other.getFetchStrategy()).orNull());
        this.setCached(other.getCached());
        this.setIndexed(other.getIndexed());
        this.setTransitive(other.getTransitive());
        this.setBot(other.getBot());
        this.setStdin(other.getStdin());
        this.setStdout(other.getStdout());
        this.setStderr(other.getStderr());
        this.setExecutorService(other.getExecutorService());
        this.setExcludedExtensions(other.getExcludedExtensions());
        this.setRepositories(other.getRepositories());
        this.setBootRepositories(other.getBootRepositories());
        this.setApplicationArguments(other.getApplicationArguments());
        this.setCustomOptions(other.getCustomOptions());
        this.setExpireTime(other.getExpireTime());
        this.setErrors(other.getErrors() == null ? new ArrayList<NMsg>() : other.getErrors().stream().map(x -> NMsg.ofPlain(x)).collect(Collectors.toList()));
        this.setSkipErrors(other.getSkipErrors());
        this.setSwitchWorkspace(other.getSwitchWorkspace());
        this.setLocale(other.getLocale());
        this.setTheme(other.getTheme());
        this.setDependencySolver(other.getDependencySolver());
        this.setIsolationLevel(NIsolationLevel.parse(other.getIsolationLevel()).orNull());
        this.setInitLaunchers(other.getInitLaunchers());
        this.setInitJava(other.getInitJava());
        this.setInitScripts(other.getInitScripts());
        this.setInitPlatforms(other.getInitPlatforms());
        this.setDesktopLauncher(NSupportMode.parse(other.getDesktopLauncher()).orNull());
        this.setMenuLauncher(NSupportMode.parse(other.getMenuLauncher()).orNull());
        this.setUserLauncher(NSupportMode.parse(other.getUserLauncher()).orNull());
        this.setSharedInstance(other.getSharedInstance());
        this.setPreviewRepo(other.getPreviewRepo());
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder copyFrom(NWorkspaceOptions other, NMapStrategy strategy) {
        if (other != null) {
            if (strategy == null) {
                strategy = NMapStrategy.ANY;
            }
            strategy.applyOptional(this::getApiVersion, other::getApiVersion, this::setApiVersion);
            strategy.applyOptional(this::getRuntimeId, other::getRuntimeId, this::setRuntimeId);
            strategy.applyOptional(this::getJavaOptions, other::getJavaOptions, this::setJavaOptions);
            strategy.applyOptional(this::getJavaCommand, other::getJavaCommand, this::setJavaCommand);
            strategy.applyOptional(this::getWorkspace, other::getWorkspace, this::setWorkspace);
            strategy.applyOptional(this::getName, other::getName, this::setName);
            strategy.applyOptional(this::getInstallCompanions, other::getInstallCompanions, this::setInstallCompanions);
            strategy.applyOptional(this::getSkipWelcome, other::getSkipWelcome, this::setSkipWelcome);
            strategy.applyOptional(this::getSkipBoot, other::getSkipBoot, this::setSkipBoot);
            strategy.applyOptional(this::getSystem, other::getSystem, this::setSystem);
            strategy.applyOptional(this::getGui, other::getGui, this::setGui);
            strategy.applyOptional(this::getUserName, other::getUserName, this::setUserName);
            strategy.applyOptional(this::getCredentials, other::getCredentials, this::setCredentials);
            strategy.applyOptional(this::getTerminalMode, other::getTerminalMode, this::setTerminalMode);
            strategy.applyOptional(this::getReadOnly, other::getReadOnly, this::setReadOnly);
            strategy.applyOptional(this::getTrace, other::getTrace, this::setTrace);
            strategy.applyOptional(this::getProgressOptions, other::getProgressOptions, this::setProgressOptions);
            strategy.applyOptional(this::getLogConfig, other::getLogConfig, this::setLogConfig);
            strategy.applyOptional(this::getConfirm, other::getConfirm, this::setConfirm);
            strategy.applyOptional(this::getConfirm, other::getConfirm, this::setConfirm);
            strategy.applyOptional(this::getOutputFormat, other::getOutputFormat, this::setOutputFormat);
            strategy.applyOptional(this::getOutputFormatOptions, other::getOutputFormatOptions, this::setOutputFormatOptions);
            strategy.applyOptional(this::getOpenMode, other::getOpenMode, this::setOpenMode);
            strategy.applyOptional(this::getCreationTime, other::getCreationTime, this::setCreationTime);
            strategy.applyOptional(this::getDry, other::getDry, this::setDry);
            strategy.applyOptional(this::getShowStacktrace, other::getShowStacktrace, this::setShowStacktrace);
            strategy.applyOptional(this::getClassLoaderSupplier, other::getClassLoaderSupplier, this::setClassLoaderSupplier);
            strategy.applyOptional(this::getExecutorOptions, other::getExecutorOptions, this::setExecutorOptions);
            strategy.applyOptional(this::getRecover, other::getRecover, this::setRecover);
            strategy.applyOptional(this::getReset, other::getReset, this::setReset);
            strategy.applyOptional(this::getResetHard, other::getResetHard, this::setResetHard);
            strategy.applyOptional(this::getCommandVersion, other::getCommandVersion, this::setCommandVersion);
            strategy.applyOptional(this::getCommandHelp, other::getCommandHelp, this::setCommandHelp);
            strategy.applyOptional(this::getDebug, other::getDebug, this::setDebug);
            strategy.applyOptional(this::getInherited, other::getInherited, this::setInherited);
            strategy.applyOptional(this::getExecutionType, other::getExecutionType, this::setExecutionType);
            strategy.applyOptional(this::getRunAs, other::getRunAs, this::setRunAs);
            strategy.applyOptional(this::getArchetype, other::getArchetype, this::setArchetype);
            strategy.applyOptional(this::getStoreStrategy, other::getStoreStrategy, this::setStoreStrategy);
            strategy.applyOptional(this::getHomeLocations, other::getHomeLocations, this::setHomeLocations);
            strategy.applyOptional(this::getStoreLocations, other::getStoreLocations, this::setStoreLocations);
            strategy.applyOptional(this::getStoreLayout, other::getStoreLayout, this::setStoreLayout);
            strategy.applyOptional(this::getStoreStrategy, other::getStoreStrategy, this::setStoreStrategy);
            strategy.applyOptional(this::getRepositoryStoreStrategy, other::getRepositoryStoreStrategy, this::setRepositoryStoreStrategy);
            strategy.applyOptional(this::getFetchStrategy, other::getFetchStrategy, this::setFetchStrategy);
            strategy.applyOptional(this::getCached, other::getCached, this::setCached);
            strategy.applyOptional(this::getIndexed, other::getIndexed, this::setIndexed);
            strategy.applyOptional(this::getTransitive, other::getTransitive, this::setTransitive);
            strategy.applyOptional(this::getBot, other::getBot, this::setBot);
            strategy.applyOptional(this::getStdin, other::getStdin, this::setStdin);
            strategy.applyOptional(this::getStdout, other::getStdout, this::setStdout);
            strategy.applyOptional(this::getStderr, other::getStderr, this::setStderr);
            strategy.applyOptional(this::getExecutorService, other::getExecutorService, this::setExecutorService);
            strategy.applyOptional(this::getExcludedExtensions, other::getExcludedExtensions, this::setExcludedExtensions);
            strategy.applyOptional(this::getRepositories, other::getRepositories, this::setRepositories);
            strategy.applyOptional(this::getBootRepositories, other::getBootRepositories, this::setBootRepositories);
            strategy.applyOptional(this::getApplicationArguments, other::getApplicationArguments, this::setApplicationArguments);
            strategy.applyOptional(this::getCustomOptions, other::getCustomOptions, this::setCustomOptions);
            strategy.applyOptional(this::getExpireTime, other::getExpireTime, this::setExpireTime);
            strategy.applyOptional(this::getErrors, other::getErrors, this::setErrors);
            strategy.applyOptional(this::getSkipErrors, other::getSkipErrors, this::setSkipErrors);
            strategy.applyOptional(this::getSwitchWorkspace, other::getSwitchWorkspace, this::setSwitchWorkspace);
            strategy.applyOptional(this::getLocale, other::getLocale, this::setLocale);
            strategy.applyOptional(this::getTheme, other::getTheme, this::setTheme);
            strategy.applyOptional(this::getDependencySolver, other::getDependencySolver, this::setDependencySolver);
            strategy.applyOptional(this::getIsolationLevel, other::getIsolationLevel, this::setIsolationLevel);
            strategy.applyOptional(this::getInitLaunchers, other::getInitLaunchers, this::setInitLaunchers);
            strategy.applyOptional(this::getInitJava, other::getInitJava, this::setInitJava);
            strategy.applyOptional(this::getInitScripts, other::getInitScripts, this::setInitScripts);
            strategy.applyOptional(this::getInitLaunchers, other::getInitLaunchers, this::setInitLaunchers);
            strategy.applyOptional(this::getDesktopLauncher, other::getDesktopLauncher, this::setDesktopLauncher);
            strategy.applyOptional(this::getMenuLauncher, other::getMenuLauncher, this::setMenuLauncher);
            strategy.applyOptional(this::getUserLauncher, other::getUserLauncher, this::setUserLauncher);
            strategy.applyOptional(this::getPreviewRepo, other::getPreviewRepo, this::setPreviewRepo);
            strategy.applyOptional(this::getSharedInstance, other::getSharedInstance, this::setSharedInstance);
        }
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setCmdLine(String cmdLine) {
        this.setCmdLine(NCmdLine.parseDefault(cmdLine).get().toStringArray());
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setCmdLine(String[] args) {
        NWorkspaceCmdLineParser.parseNutsArguments(args, this);
        return this;
    }

    @Override
    public NOptional<Boolean> getSharedInstance() {
        return NOptional.ofNamed(this.sharedInstance, "sharedInstance");
    }

    @Override
    public NWorkspaceOptionsBuilder setSharedInstance(Boolean sharedInstance) {
        this.sharedInstance = sharedInstance;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setUserName(String username) {
        this.userName = username;
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setStoreLocation(NStoreType location, String value) {
        if (NBlankable.isBlank(value)) {
            if (this.storeLocations != null) {
                this.storeLocations.remove(location);
            }
        } else {
            if (this.storeLocations == null) {
                this.storeLocations = new HashMap<NStoreType, String>();
            }
            this.storeLocations.put(location, value);
        }
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder setHomeLocation(NHomeLocation location, String value) {
        if (NBlankable.isBlank(value)) {
            if (this.homeLocations != null) {
                this.homeLocations.remove(location);
            }
        } else {
            if (this.homeLocations == null) {
                this.homeLocations = new HashMap<NHomeLocation, String>();
            }
            this.homeLocations.put(location, value);
        }
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder addOutputFormatOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                if (option == null || (option = NStringUtils.trim(option)).isEmpty()) continue;
                if (this.outputFormatOptions == null) {
                    this.outputFormatOptions = new ArrayList<String>();
                }
                this.outputFormatOptions.add(option);
            }
        }
        return this;
    }

    @Override
    public NOptional<String> getDependencySolver() {
        return NOptional.ofNamed(this.dependencySolver, "dependencySolver");
    }

    @Override
    public NWorkspaceOptionsBuilder setDependencySolver(String dependencySolver) {
        this.dependencySolver = dependencySolver;
        return this;
    }

    public String toString() {
        return this.toCmdLine().toString();
    }

    @Override
    public NWorkspaceOptions build() {
        return new DefaultNWorkspaceOptions(this.getApiVersion().orNull(), this.getRuntimeId().orNull(), this.getWorkspace().orNull(), this.getName().orNull(), this.getJavaCommand().orNull(), this.getJavaOptions().orNull(), this.getOutLinePrefix().orNull(), this.getErrLinePrefix().orNull(), this.getUserName().orNull(), this.getCredentials().orNull(), this.getProgressOptions().orNull(), this.getDependencySolver().orNull(), this.getDebug().orNull(), this.getArchetype().orNull(), this.getLocale().orNull(), this.getTheme().orNull(), this.getLogConfig().orNull(), this.getConfirm().orNull(), this.getOutputFormat().orNull(), this.getOpenMode().orNull(), this.getExecutionType().orNull(), this.getStoreStrategy().orNull(), this.getRepositoryStoreStrategy().orNull(), this.getStoreLayout().orNull(), this.getTerminalMode().orNull(), this.getFetchStrategy().orNull(), this.getRunAs().orNull(), this.getCreationTime().orNull(), this.getExpireTime().orNull(), this.getInstallCompanions().orNull(), this.getSkipWelcome().orNull(), this.getSkipBoot().orNull(), this.getSystem().orNull(), this.getGui().orNull(), this.getReadOnly().orNull(), this.getTrace().orNull(), this.getDry().orNull(), this.getShowStacktrace().orNull(), this.getRecover().orNull(), this.getReset().orNull(), this.getResetHard().orNull(), this.getCommandVersion().orNull(), this.getCommandHelp().orNull(), this.getCommandHelp().orNull(), this.getSwitchWorkspace().orNull(), this.getCached().orNull(), this.getIndexed().orNull(), this.getTransitive().orNull(), this.getBot().orNull(), this.getSkipErrors().orNull(), this.getIsolationLevel().orNull(), this.getInitLaunchers().orNull(), this.getInitScripts().orNull(), this.getInitPlatforms().orNull(), this.getInitJava().orNull(), this.getStdin().orNull(), this.getStdout().orNull(), this.getStdout().orNull(), this.getExecutorService().orNull(), this.getClassLoaderSupplier().orNull(), this.getApplicationArguments().orNull(), this.getOutputFormatOptions().orNull(), this.getCustomOptions().orNull(), this.getExcludedExtensions().orNull(), this.getRepositories().orNull(), this.getBootRepositories().orNull(), this.getExecutorOptions().orNull(), this.getErrors().orNull(), this.getStoreLocations().orNull(), this.getHomeLocations().orNull(), this.getDesktopLauncher().orNull(), this.getMenuLauncher().orNull(), this.getUserLauncher().orNull(), this.getPreviewRepo().orNull(), this.getSharedInstance().orNull());
    }

    @Override
    public NWorkspaceOptionsBuilder builder() {
        return new DefaultNWorkspaceOptionsBuilder().copyFrom(this);
    }

    @Override
    public NCmdLine toCmdLine() {
        return this.build().toCmdLine();
    }

    @Override
    public NCmdLine toCmdLine(NWorkspaceOptionsConfig config) {
        return this.build().toCmdLine(config);
    }

    @Override
    public NOptional<NIsolationLevel> getIsolationLevel() {
        return NOptional.ofNamed(this.isolationLevel, "isolationLevel");
    }

    @Override
    public NOptional<Boolean> getInitLaunchers() {
        return NOptional.ofNamed(this.initLaunchers, "initLaunchers");
    }

    @Override
    public NOptional<Boolean> getInitScripts() {
        return NOptional.ofNamed(this.initScripts, "initScripts");
    }

    @Override
    public NOptional<Boolean> getInitPlatforms() {
        return NOptional.ofNamed(this.initPlatforms, "initPlatforms");
    }

    @Override
    public NOptional<Boolean> getInitJava() {
        return NOptional.ofNamed(this.initJava, "initJava");
    }

    @Override
    public NWorkspaceOptionsBuilder unsetRuntimeOptions() {
        this.setCommandHelp(null);
        this.setCommandVersion(null);
        this.setOpenMode(null);
        this.setExecutionType(null);
        this.setRunAs(null);
        this.setReset(null);
        this.setRecover(null);
        this.setDry(null);
        this.setShowStacktrace(null);
        this.setExecutorOptions(null);
        this.setApplicationArguments(null);
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder unsetCreationOptions() {
        this.setName(null);
        this.setArchetype(null);
        this.setStoreLayout(null);
        this.setStoreStrategy(null);
        this.setRepositoryStoreStrategy(null);
        this.setStoreLocations(null);
        this.setHomeLocations(null);
        this.setSwitchWorkspace(null);
        this.setBootRepositories(null);
        return this;
    }

    @Override
    public NWorkspaceOptionsBuilder unsetExportedOptions() {
        this.setJavaCommand(null);
        this.setJavaOptions(null);
        this.setWorkspace(null);
        this.setUserName(null);
        this.setCredentials(null);
        this.setApiVersion(null);
        this.setRuntimeId(null);
        this.setTerminalMode(null);
        this.setLogConfig(null);
        this.setExcludedExtensions(null);
        this.setRepositories(null);
        this.setSystem(null);
        this.setGui(null);
        this.setReadOnly(null);
        this.setTrace(null);
        this.setProgressOptions(null);
        this.setDependencySolver(null);
        this.setDebug(null);
        this.setInstallCompanions(null);
        this.setSkipWelcome(null);
        this.setSkipBoot(null);
        this.setOutLinePrefix(null);
        this.setErrLinePrefix(null);
        this.setCached(null);
        this.setIndexed(null);
        this.setTransitive(null);
        this.setBot(null);
        this.setFetchStrategy(null);
        this.setConfirm(null);
        this.setOutputFormat(null);
        this.setOutputFormatOptions((List<String>)null);
        this.setExpireTime(null);
        this.setTheme(null);
        this.setLocale(null);
        this.setInitLaunchers(null);
        this.setInitPlatforms(null);
        this.setInitScripts(null);
        this.setInitJava(null);
        this.setDesktopLauncher(null);
        this.setMenuLauncher(null);
        this.setUserLauncher(null);
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

