/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.NBootHomeLocation;
import net.thevpc.nuts.boot.NBootLogConfig;
import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionType;
import net.thevpc.nuts.command.NFetchStrategy;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NOpenMode;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.core.NWorkspaceOptionsBuilder;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedWorkspaceOptionsToCmdLineBuilder;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NSupportMode;

public class DefaultNWorkspaceOptions
implements Serializable,
NWorkspaceOptions {
    public static NWorkspaceOptions BLANK = new DefaultNWorkspaceOptions(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    private static final long serialVersionUID = 1L;
    private final List<String> outputFormatOptions;
    private final List<String> customOptions;
    private final NVersion apiVersion;
    private final NId runtimeId;
    private final String javaCommand;
    private final String javaOptions;
    private final String workspace;
    private final String outLinePrefix;
    private final String errLinePrefix;
    private final String name;
    private final Boolean installCompanions;
    private final Boolean skipWelcome;
    private final Boolean skipBoot;
    private final Boolean system;
    private final Boolean gui;
    private final List<String> excludedExtensions;
    private final List<String> repositories;
    private final List<String> bootRepositories;
    private final String userName;
    private final char[] credentials;
    private final NTerminalMode terminalMode;
    private final Boolean readOnly;
    private final Boolean trace;
    private final String progressOptions;
    private final String dependencySolver;
    private final NLogConfig logConfig;
    private final NConfirmationMode confirm;
    private final NContentType outputFormat;
    private final List<String> applicationArguments;
    private final NOpenMode openMode;
    private final Instant creationTime;
    private final Boolean dry;
    private final Boolean showStacktrace;
    private final Supplier<ClassLoader> classLoaderSupplier;
    private final List<String> executorOptions;
    private final Boolean recover;
    private final Boolean reset;
    private final Boolean resetHard;
    private final Boolean commandVersion;
    private final Boolean commandHelp;
    private final String debug;
    private final Boolean inherited;
    private final NExecutionType executionType;
    private final NRunAs runAs;
    private final String archetype;
    private final Boolean switchWorkspace;
    private final Map<NStoreType, String> storeLocations;
    private final Map<NHomeLocation, String> homeLocations;
    private final NOsFamily storeLayout;
    private final NStoreStrategy storeStrategy;
    private final NStoreStrategy repositoryStoreStrategy;
    private final NFetchStrategy fetchStrategy;
    private final Boolean cached;
    private final Boolean indexed;
    private final Boolean transitive;
    private final Boolean bot;
    private final Boolean previewRepo;
    private final InputStream stdin;
    private final PrintStream stdout;
    private final PrintStream stderr;
    private final ExecutorService executorService;
    private final Instant expireTime;
    private final List<NMsg> errors;
    private final Boolean skipErrors;
    private final String locale;
    private final String theme;
    private final Boolean initLaunchers;
    private final Boolean initScripts;
    private final Boolean initPlatforms;
    private final Boolean initJava;
    private final Boolean sharedInstance;
    private final NIsolationLevel isolationLevel;
    private final NSupportMode desktopLauncher;
    private final NSupportMode menuLauncher;
    private final NSupportMode userLauncher;

    public DefaultNWorkspaceOptions(NVersion apiVersion, NId runtimeId, String workspace, String name, String javaCommand, String javaOptions, String outLinePrefix, String errLinePrefix, String userName, char[] credentials, String progressOptions, String dependencySolver, String debug, String archetype, String locale, String theme, NLogConfig logConfig, NConfirmationMode confirm, NContentType outputFormat, NOpenMode openMode, NExecutionType executionType, NStoreStrategy storeStrategy, NStoreStrategy repositoryStoreStrategy, NOsFamily storeLayout, NTerminalMode terminalMode, NFetchStrategy fetchStrategy, NRunAs runAs, Instant creationTime, Instant expireTime, Boolean installCompanions, Boolean skipWelcome, Boolean skipBoot, Boolean system, Boolean gui, Boolean readOnly, Boolean trace, Boolean dry, Boolean showStacktrace, Boolean recover, Boolean reset, Boolean resetHard, Boolean commandVersion, Boolean commandHelp, Boolean inherited, Boolean switchWorkspace, Boolean cached, Boolean indexed, Boolean transitive, Boolean bot, Boolean skipErrors, NIsolationLevel isolationLevel, Boolean initLaunchers, Boolean initScripts, Boolean initPlatforms, Boolean initJava, InputStream stdin, PrintStream stdout, PrintStream stderr, ExecutorService executorService, Supplier<ClassLoader> classLoaderSupplier, List<String> applicationArguments, List<String> outputFormatOptions, List<String> customOptions, List<String> excludedExtensions, List<String> repositories, List<String> bootRepositories, List<String> executorOptions, List<NMsg> errors, Map<NStoreType, String> storeLocations, Map<NHomeLocation, String> homeLocations, NSupportMode desktopLauncher, NSupportMode menuLauncher, NSupportMode userLauncher, Boolean previewRepo, Boolean sharedInstance) {
        this.outputFormatOptions = NReservedLangUtils.unmodifiableOrNullList(outputFormatOptions);
        this.customOptions = NReservedLangUtils.unmodifiableOrNullList(customOptions);
        this.excludedExtensions = NReservedLangUtils.unmodifiableOrNullList(excludedExtensions);
        this.repositories = NReservedLangUtils.unmodifiableOrNullList(repositories);
        this.bootRepositories = NReservedLangUtils.unmodifiableOrNullList(bootRepositories);
        this.applicationArguments = NReservedLangUtils.unmodifiableOrNullList(applicationArguments);
        this.errors = NReservedLangUtils.unmodifiableOrNullList(errors);
        this.executorOptions = NReservedLangUtils.unmodifiableOrNullList(executorOptions);
        this.storeLocations = NReservedLangUtils.unmodifiableOrNullMap(storeLocations);
        this.homeLocations = NReservedLangUtils.unmodifiableOrNullMap(homeLocations);
        this.apiVersion = apiVersion;
        this.runtimeId = runtimeId;
        this.javaCommand = javaCommand;
        this.javaOptions = javaOptions;
        this.workspace = workspace;
        this.outLinePrefix = outLinePrefix;
        this.errLinePrefix = errLinePrefix;
        this.name = name;
        this.installCompanions = installCompanions;
        this.skipWelcome = skipWelcome;
        this.skipBoot = skipBoot;
        this.system = system;
        this.gui = gui;
        this.userName = userName;
        this.credentials = credentials == null ? null : Arrays.copyOf(credentials, credentials.length);
        this.terminalMode = terminalMode;
        this.readOnly = readOnly;
        this.trace = trace;
        this.progressOptions = progressOptions;
        this.dependencySolver = dependencySolver;
        this.logConfig = logConfig == null ? null : logConfig.readOnly();
        this.confirm = confirm;
        this.outputFormat = outputFormat;
        this.openMode = openMode;
        this.creationTime = creationTime;
        this.dry = dry;
        this.showStacktrace = showStacktrace;
        this.classLoaderSupplier = classLoaderSupplier;
        this.recover = recover;
        this.reset = reset;
        this.resetHard = resetHard;
        this.commandVersion = commandVersion;
        this.commandHelp = commandHelp;
        this.debug = debug;
        this.inherited = inherited;
        this.executionType = executionType;
        this.runAs = runAs;
        this.archetype = archetype;
        this.switchWorkspace = switchWorkspace;
        this.storeLayout = storeLayout;
        this.storeStrategy = storeStrategy;
        this.repositoryStoreStrategy = repositoryStoreStrategy;
        this.fetchStrategy = fetchStrategy;
        this.cached = cached;
        this.indexed = indexed;
        this.transitive = transitive;
        this.bot = bot;
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        this.executorService = executorService;
        this.expireTime = expireTime;
        this.skipErrors = skipErrors;
        this.locale = locale;
        this.theme = theme;
        this.isolationLevel = isolationLevel;
        this.initLaunchers = initLaunchers;
        this.initScripts = initScripts;
        this.initPlatforms = initPlatforms;
        this.initJava = initJava;
        this.desktopLauncher = desktopLauncher;
        this.menuLauncher = menuLauncher;
        this.userLauncher = userLauncher;
        this.previewRepo = previewRepo;
        this.sharedInstance = sharedInstance;
    }

    @Override
    public NBootOptionsInfo toBootOptionsInfo() {
        NBootOptionsInfo r = new NBootOptionsInfo();
        r.setApiVersion(this.getApiVersion().map(x -> x.toString()).orNull());
        r.setRuntimeId(this.getRuntimeId().map(x -> x.toString()).orNull());
        r.setJavaCommand(this.getJavaCommand().orNull());
        r.setJavaOptions(this.getJavaOptions().orNull());
        r.setWorkspace(this.getWorkspace().orNull());
        r.setName(this.getName().orNull());
        r.setInstallCompanions(this.getInstallCompanions().orNull());
        r.setSkipWelcome(this.getSkipWelcome().orNull());
        r.setSkipBoot(this.getSkipBoot().orNull());
        r.setSystem(this.getSystem().orNull());
        r.setGui(this.getGui().orNull());
        r.setUserName(this.getUserName().orNull());
        r.setCredentials(this.getCredentials().orNull());
        r.setTerminalMode(this.getTerminalMode().map(x -> x.id()).orNull());
        r.setReadOnly(this.getReadOnly().orNull());
        r.setTrace(this.getTrace().orNull());
        r.setProgressOptions(this.getProgressOptions().orNull());
        Map<NStoreType, String> c = this.getLogConfig().orNull();
        Cloneable v = null;
        if (c != null) {
            v = new NBootLogConfig();
            ((NBootLogConfig)v).setLogFileBase(((NLogConfig)((Object)c)).getLogFileBase());
            ((NBootLogConfig)v).setLogFileLevel(((NLogConfig)((Object)c)).getLogFileLevel());
            ((NBootLogConfig)v).setLogTermLevel(((NLogConfig)((Object)c)).getLogTermLevel());
            ((NBootLogConfig)v).setLogFileSize(((NLogConfig)((Object)c)).getLogFileSize());
            ((NBootLogConfig)v).setLogFileCount(((NLogConfig)((Object)c)).getLogFileCount());
            ((NBootLogConfig)v).setLogFileName(((NLogConfig)((Object)c)).getLogFileName());
            ((NBootLogConfig)v).setLogFileBase(((NLogConfig)((Object)c)).getLogFileBase());
        }
        r.setLogConfig((NBootLogConfig)v);
        r.setConfirm(this.getConfirm().map(x -> x.id()).orNull());
        r.setConfirm(this.getConfirm().map(x -> x.id()).orNull());
        r.setOutputFormat(this.getOutputFormat().map(x -> x.id()).orNull());
        r.setOutputFormatOptions(this.getOutputFormatOptions().orNull());
        r.setOpenMode(this.getOpenMode().map(x -> x.id()).orNull());
        r.setCreationTime(this.getCreationTime().orNull());
        r.setDry(this.getDry().orNull());
        r.setShowStacktrace(this.getShowStacktrace().orNull());
        r.setClassLoaderSupplier(this.getClassLoaderSupplier().orNull());
        r.setExecutorOptions(this.getExecutorOptions().orNull());
        r.setRecover(this.getRecover().orNull());
        r.setReset(this.getReset().orNull());
        r.setResetHard(this.getResetHard().orNull());
        r.setCommandVersion(this.getCommandVersion().orNull());
        r.setCommandHelp(this.getCommandHelp().orNull());
        r.setDebug(this.getDebug().orNull());
        r.setInherited(this.getInherited().orNull());
        r.setExecutionType(this.getExecutionType().map(x -> x.id()).orNull());
        r.setRunAs(this.getRunAs().map(x -> x.toString()).orNull());
        r.setArchetype(this.getArchetype().orNull());
        r.setStoreStrategy(this.getStoreStrategy().map(x -> x.id()).orNull());
        c = this.getHomeLocations().orNull();
        v = null;
        if (c != null) {
            v = new HashMap();
            for (Map.Entry entry : c.entrySet()) {
                v.put(NBootHomeLocation.of(((NHomeLocation)entry.getKey()).getOsFamily().id(), ((NHomeLocation)entry.getKey()).getStoreLocation().id()), (String)entry.getValue());
            }
        }
        r.setHomeLocations((Map<NBootHomeLocation, String>)((Object)v));
        c = this.getStoreLocations().orNull();
        v = null;
        if (c != null) {
            v = new HashMap();
            for (Map.Entry<Object, Object> entry : c.entrySet()) {
                v.put(((NStoreType)entry.getKey()).id(), (String)entry.getValue());
            }
        }
        r.setStoreLocations((Map<String, String>)((Object)v));
        r.setStoreLayout(this.getStoreLayout().map(x -> x.toString()).orNull());
        r.setStoreStrategy(this.getStoreStrategy().map(x -> x.toString()).orNull());
        r.setRepositoryStoreStrategy(this.getRepositoryStoreStrategy().map(x -> x.toString()).orNull());
        r.setFetchStrategy(this.getFetchStrategy().map(x -> x.toString()).orNull());
        r.setCached(this.getCached().orNull());
        r.setIndexed(this.getIndexed().orNull());
        r.setTransitive(this.getTransitive().orNull());
        r.setBot(this.getBot().orNull());
        r.setStdin(this.getStdin().orNull());
        r.setStdout(this.getStdout().orNull());
        r.setStderr(this.getStderr().orNull());
        r.setExecutorService(this.getExecutorService().orNull());
        r.setExcludedExtensions(this.getExcludedExtensions().orNull());
        r.setRepositories(this.getRepositories().orNull());
        r.setBootRepositories(this.getBootRepositories().orNull());
        r.setApplicationArguments(this.getApplicationArguments().orNull());
        r.setCustomOptions(this.getCustomOptions().orNull());
        r.setExpireTime(this.getExpireTime().orNull());
        r.setErrors(this.getErrors().isNotPresent() ? new ArrayList<String>() : this.getErrors().get().stream().map(x -> x.toString()).collect(Collectors.toList()));
        r.setSkipErrors(this.getSkipErrors().orNull());
        r.setSwitchWorkspace(this.getSwitchWorkspace().orNull());
        r.setLocale(this.getLocale().orNull());
        r.setTheme(this.getTheme().orNull());
        r.setDependencySolver(this.getDependencySolver().orNull());
        r.setIsolationLevel(this.getIsolationLevel().map(x -> x.id()).orNull());
        r.setInitLaunchers(this.getInitLaunchers().orNull());
        r.setInitJava(this.getInitJava().orNull());
        r.setInitScripts(this.getInitScripts().orNull());
        r.setInitPlatforms(this.getInitPlatforms().orNull());
        r.setDesktopLauncher(this.getDesktopLauncher().map(x -> x.id()).orNull());
        r.setMenuLauncher(this.getMenuLauncher().map(x -> x.id()).orNull());
        r.setUserLauncher(this.getUserLauncher().map(x -> x.id()).orNull());
        r.setSharedInstance(this.getSharedInstance().orNull());
        r.setPreviewRepo(this.getPreviewRepo().orNull());
        return r;
    }

    @Override
    public NOptional<Boolean> getPreviewRepo() {
        return NOptional.ofNamed(this.previewRepo, "previewRepo");
    }

    @Override
    public NOptional<Boolean> getSharedInstance() {
        return NOptional.ofNamed(this.sharedInstance, "sharedInstance");
    }

    @Override
    public NOptional<NSupportMode> getDesktopLauncher() {
        return NOptional.ofNamed(this.desktopLauncher, "desktopLauncher");
    }

    @Override
    public NOptional<NSupportMode> getMenuLauncher() {
        return NOptional.ofNamed(this.menuLauncher, "menuLauncher");
    }

    @Override
    public NOptional<NSupportMode> getUserLauncher() {
        return NOptional.ofNamed(this.userLauncher, "userLauncher");
    }

    @Override
    public NOptional<NIsolationLevel> getIsolationLevel() {
        return NOptional.ofNamed(this.isolationLevel, "isolationLevel");
    }

    @Override
    public NOptional<Boolean> getInitLaunchers() {
        return NOptional.ofNamed(this.initLaunchers, "initLaunchers");
    }

    @Override
    public NOptional<Boolean> getInitScripts() {
        return NOptional.ofNamed(this.initScripts, "initScripts");
    }

    @Override
    public NOptional<Boolean> getInitPlatforms() {
        return NOptional.ofNamed(this.initPlatforms, "initPlatforms");
    }

    @Override
    public NOptional<Boolean> getInitJava() {
        return NOptional.ofNamed(this.initJava, "initJava");
    }

    @Override
    public NOptional<NVersion> getApiVersion() {
        return NOptional.ofNamed(this.apiVersion, "apiVersion");
    }

    @Override
    public NOptional<List<String>> getApplicationArguments() {
        return NOptional.ofNamed(this.applicationArguments, "applicationArguments");
    }

    @Override
    public NOptional<String> getArchetype() {
        return NOptional.ofNamed(this.archetype, "archetype");
    }

    @Override
    public NOptional<Supplier<ClassLoader>> getClassLoaderSupplier() {
        return NOptional.ofNamed(this.classLoaderSupplier, "classLoaderSupplier");
    }

    @Override
    public NOptional<NConfirmationMode> getConfirm() {
        return NOptional.ofNamed(this.confirm, "confirm");
    }

    @Override
    public NOptional<Boolean> getDry() {
        return NOptional.ofNamed(this.dry, "dry");
    }

    @Override
    public NOptional<Boolean> getShowStacktrace() {
        return NOptional.ofNamed(this.showStacktrace, "showStacktrace");
    }

    @Override
    public NOptional<Instant> getCreationTime() {
        return NOptional.ofNamed(this.creationTime, "creationTime");
    }

    @Override
    public NOptional<List<String>> getExcludedExtensions() {
        return NOptional.ofNamed(this.excludedExtensions, "excludedExtensions");
    }

    @Override
    public NOptional<NExecutionType> getExecutionType() {
        return NOptional.ofNamed(this.executionType, "executionType");
    }

    @Override
    public NOptional<NRunAs> getRunAs() {
        return NOptional.ofNamed(this.runAs, "runAs");
    }

    @Override
    public NOptional<List<String>> getExecutorOptions() {
        return NOptional.ofNamed(this.executorOptions, "executorOptions");
    }

    @Override
    public NOptional<String> getHomeLocation(NHomeLocation location) {
        return NOptional.ofNamed(this.homeLocations == null ? null : this.homeLocations.get(location), "HomeLocation[" + location + "]");
    }

    @Override
    public NOptional<Map<NHomeLocation, String>> getHomeLocations() {
        return NOptional.ofNamed(this.homeLocations, "homeLocations");
    }

    @Override
    public NOptional<String> getJavaCommand() {
        return NOptional.ofNamed(this.javaCommand, "javaCommand");
    }

    @Override
    public NOptional<String> getJavaOptions() {
        return NOptional.ofNamed(this.javaOptions, "javaOptions");
    }

    @Override
    public NOptional<NLogConfig> getLogConfig() {
        return NOptional.ofNamed(this.logConfig, "logConfig");
    }

    @Override
    public NOptional<String> getName() {
        return NOptional.ofNamed(this.name, "name");
    }

    @Override
    public NOptional<NOpenMode> getOpenMode() {
        return NOptional.ofNamed(this.openMode, "openMode");
    }

    @Override
    public NOptional<NContentType> getOutputFormat() {
        return NOptional.ofNamed(this.outputFormat, "outputFormat");
    }

    @Override
    public NOptional<List<String>> getOutputFormatOptions() {
        return NOptional.ofNamed(this.outputFormatOptions, "outputFormatOptions");
    }

    @Override
    public NOptional<char[]> getCredentials() {
        return NOptional.ofNamed(this.credentials == null ? null : Arrays.copyOf(this.credentials, this.credentials.length), "credentials");
    }

    @Override
    public NOptional<NStoreStrategy> getRepositoryStoreStrategy() {
        return NOptional.ofNamed(this.repositoryStoreStrategy, "repositoryStoreStrategy");
    }

    @Override
    public NOptional<NId> getRuntimeId() {
        return NOptional.ofNamed(this.runtimeId, "runtimeId");
    }

    @Override
    public NOptional<String> getStoreType(NStoreType folder) {
        return NOptional.ofNamed(this.storeLocations == null ? null : this.storeLocations.get(folder), "storeLocations[" + folder + "]");
    }

    @Override
    public NOptional<NOsFamily> getStoreLayout() {
        return NOptional.ofNamed(this.storeLayout, "storeLayout");
    }

    @Override
    public NOptional<NStoreStrategy> getStoreStrategy() {
        return NOptional.ofNamed(this.storeStrategy, "storeStrategy");
    }

    @Override
    public NOptional<Map<NStoreType, String>> getStoreLocations() {
        return NOptional.ofNamed(this.storeLocations, "storeLocations");
    }

    @Override
    public NOptional<NTerminalMode> getTerminalMode() {
        return NOptional.ofNamed(this.terminalMode, "terminalMode");
    }

    @Override
    public NOptional<List<String>> getRepositories() {
        return NOptional.ofNamed(this.repositories, "repositories");
    }

    @Override
    public NOptional<List<String>> getBootRepositories() {
        return NOptional.ofNamed(this.bootRepositories, "initRepositories");
    }

    @Override
    public NOptional<String> getUserName() {
        return NOptional.ofNamed(this.userName, "userName");
    }

    @Override
    public NOptional<String> getWorkspace() {
        return NOptional.ofNamed(this.workspace, "workspace");
    }

    @Override
    public NOptional<String> getDebug() {
        return NOptional.ofNamed(this.debug, "debug");
    }

    @Override
    public NOptional<Boolean> getSystem() {
        return NOptional.ofNamed(this.system, "system");
    }

    @Override
    public NOptional<Boolean> getGui() {
        return NOptional.ofNamed(this.gui, "gui");
    }

    @Override
    public NOptional<Boolean> getInherited() {
        return NOptional.ofNamed(this.inherited, "inherited");
    }

    @Override
    public NOptional<Boolean> getReadOnly() {
        return NOptional.ofNamed(this.readOnly, "readOnly");
    }

    @Override
    public NOptional<Boolean> getRecover() {
        return NOptional.ofNamed(this.recover, "recover");
    }

    @Override
    public NOptional<Boolean> getReset() {
        return NOptional.ofNamed(this.reset, "reset");
    }

    @Override
    public NOptional<Boolean> getResetHard() {
        return NOptional.ofNamed(this.resetHard, "resetHard");
    }

    @Override
    public NOptional<Boolean> getCommandVersion() {
        return NOptional.ofNamed(this.commandVersion, "commandVersion");
    }

    @Override
    public NOptional<Boolean> getCommandHelp() {
        return NOptional.ofNamed(this.commandHelp, "commandHelp");
    }

    @Override
    public NOptional<Boolean> getInstallCompanions() {
        return NOptional.ofNamed(this.installCompanions, "installCompanions");
    }

    @Override
    public NOptional<Boolean> getSkipWelcome() {
        return NOptional.ofNamed(this.skipWelcome, "skipWelcome");
    }

    @Override
    public NOptional<String> getOutLinePrefix() {
        return NOptional.ofNamed(this.outLinePrefix, "outLinePrefix");
    }

    @Override
    public NOptional<String> getErrLinePrefix() {
        return NOptional.ofNamed(this.errLinePrefix, "errLinePrefix");
    }

    @Override
    public NOptional<Boolean> getSkipBoot() {
        return NOptional.ofNamed(this.skipBoot, "skipBoot");
    }

    @Override
    public NOptional<Boolean> getTrace() {
        return NOptional.ofNamed(this.trace, "trace");
    }

    @Override
    public NOptional<String> getProgressOptions() {
        return NOptional.ofNamed(this.progressOptions, "progressOptions");
    }

    @Override
    public NOptional<Boolean> getCached() {
        return NOptional.ofNamed(this.cached, "cached");
    }

    @Override
    public NOptional<Boolean> getIndexed() {
        return NOptional.ofNamed(this.indexed, "indexed");
    }

    @Override
    public NOptional<Boolean> getTransitive() {
        return NOptional.ofNamed(this.transitive, "transitive");
    }

    @Override
    public NOptional<Boolean> getBot() {
        return NOptional.ofNamed(this.bot, "bot");
    }

    @Override
    public NOptional<NFetchStrategy> getFetchStrategy() {
        return NOptional.ofNamed(this.fetchStrategy, "fetchStrategy");
    }

    @Override
    public NOptional<InputStream> getStdin() {
        return NOptional.ofNamed(this.stdin, "stdin");
    }

    @Override
    public NOptional<PrintStream> getStdout() {
        return NOptional.ofNamed(this.stdout, "stdout");
    }

    @Override
    public NOptional<PrintStream> getStderr() {
        return NOptional.ofNamed(this.stderr, "stderr");
    }

    @Override
    public NOptional<ExecutorService> getExecutorService() {
        return NOptional.ofNamed(this.executorService, "executorService");
    }

    @Override
    public NOptional<Instant> getExpireTime() {
        return NOptional.ofNamed(this.expireTime, "expireTime");
    }

    @Override
    public NOptional<Boolean> getSkipErrors() {
        return NOptional.ofNamed(this.skipErrors, "skipErrors");
    }

    @Override
    public NOptional<Boolean> getSwitchWorkspace() {
        return NOptional.ofNamed(this.switchWorkspace, "switchWorkspace");
    }

    @Override
    public NOptional<List<NMsg>> getErrors() {
        return NOptional.ofNamed(this.errors, "errors");
    }

    @Override
    public NOptional<List<String>> getCustomOptions() {
        return NOptional.ofNamed(this.customOptions, "customOptions");
    }

    @Override
    public NOptional<String> getLocale() {
        return NOptional.ofNamed(this.locale, "locale");
    }

    @Override
    public NOptional<String> getTheme() {
        return NOptional.ofNamed(this.theme, "theme");
    }

    @Override
    public NOptional<String> getDependencySolver() {
        return NOptional.ofNamed(this.dependencySolver, "dependencySolver");
    }

    public String toString() {
        return this.toCmdLine().toString();
    }

    @Override
    public NCmdLine toCmdLine() {
        return this.toCmdLine(new NWorkspaceOptionsConfig());
    }

    @Override
    public NCmdLine toCmdLine(NWorkspaceOptionsConfig config) {
        return new NReservedWorkspaceOptionsToCmdLineBuilder(config, this).toCmdLine();
    }

    @Override
    public NWorkspaceOptionsBuilder builder() {
        return NWorkspaceOptionsBuilder.of().copyFrom(this);
    }
}

